/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.type;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.OracleStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.type.OracleDMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.type.OracleTCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyCollectionRetrievalSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.packages.PackageSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.FunctionNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.tablespace.TablespaceSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.type.TypeDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.type.TypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.CursorForLoopStatementSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.ProcedureBodyEndNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.ProcedureCallNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.SQLStatementSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CommentStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.AlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.directory.CreateDirectoryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.directory.DropDirectoryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.operator.AlterOperatorStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.operator.CreateOperatorStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.operator.DropOperatorStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.pkg.AlterPackageStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.pkg.DropPackageStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.DropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.AlterSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.CreateSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.DropSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.synonym.AlterSynonymStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.synonym.CreateSynonymStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.synonym.DropSynonymStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.AlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.CreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.DropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.AlterTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.CreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.DropTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.type.AlterTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleAlterAuditPolicyStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleAlterHierarchyStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleAlterSessionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleAlterSystemStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleAnalyzeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleAuditStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleCreateNestedTableTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleCreateObjectTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleCreateSubTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleCreateVarrayTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleNoAuditStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OraclePLSQLBlockStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OraclePurgeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleRenameStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleSwitchStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.OracleSystemActionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.cluster.OracleAlterClusterStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.cluster.OracleCreateClusterStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.cluster.OracleDropClusterStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.context.OracleCreateContextStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.context.OracleDropContextStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.database.OracleAlterDatabaseDictionaryStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.database.OracleAlterDatabaseLinkStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.database.OracleAlterPluggableDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.database.OracleCreateDatabaseLinkStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.database.OracleDropDatabaseLinkStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.database.OracleDropPluggableDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.dimension.OracleAlterAttributeDimensionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.dimension.OracleAlterDimensionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.dimension.OracleCreateDimensionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.dimension.OracleDropDimensionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.diskgroup.OracleAlterDiskgroupStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.diskgroup.OracleCreateDiskgroupStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.diskgroup.OracleDropDiskgroupStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.edition.OracleCreateEditionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.edition.OracleDropEditionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.file.OracleCreateControlFileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.file.OracleCreatePFileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.file.OracleCreateSPFileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.flashback.OracleAlterFlashbackArchiveStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.flashback.OracleCreateFlashbackArchiveStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.flashback.OracleDropFlashbackArchiveStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.flashback.OracleFlashbackDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.flashback.OracleFlashbackTableStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.function.OracleCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.index.OracleAlterIndexTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.index.OracleDropIndexTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.java.OracleAlterJavaStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.java.OracleCreateJavaStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.java.OracleDropJavaStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.join.OracleAlterInMemoryJoinGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.join.OracleCreateInMemoryJoinGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.join.OracleDropInMemoryJoinGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.library.OracleAlterLibraryStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.library.OracleCreateLibraryStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.library.OracleDropLibraryStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.lockdown.OracleAlterLockdownProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.lockdown.OracleCreateLockdownProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.lockdown.OracleDropLockdownProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.outline.OracleAlterOutlineStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.outline.OracleCreateOutlineStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.outline.OracleDropOutlineStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.procedure.OracleCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.profile.OracleAlterProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.profile.OracleCreateProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.profile.OracleDropProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.restore.OracleCreateRestorePointStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.restore.OracleDropRestorePointStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.rollback.OracleAlterRollbackSegmentStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.rollback.OracleCreateRollbackSegmentStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.rollback.OracleDropRollbackSegmentStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.statistics.OracleAssociateStatisticsStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.statistics.OracleDisassociateStatisticsStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.view.OracleAlterAnalyticViewStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.view.OracleAlterMaterializedViewLogStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.view.OracleCreateMaterializedViewLogStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.view.OracleDropMaterializedViewLogStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.zone.OracleAlterMaterializedZoneMapStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.ddl.zone.OracleDropMaterializedZoneMapStatement;

public final class OracleDDLStatementVisitor
extends OracleStatementVisitor
implements DDLStatementVisitor {
    public OracleDDLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCreateView(OracleStatementParser.CreateViewContext ctx) {
        CreateViewStatement result = new CreateViewStatement(this.getDatabaseType());
        result.setReplaceView(null != ctx.REPLACE());
        OracleDMLStatementVisitor visitor = new OracleDMLStatementVisitor(this.getDatabaseType());
        this.getGlobalParameterMarkerSegments().addAll(visitor.getGlobalParameterMarkerSegments());
        this.getStatementParameterMarkerSegments().addAll(visitor.getStatementParameterMarkerSegments());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setSelect((SelectStatement)visitor.visit((ParseTree)ctx.select()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.addParameterMarkers(this.getGlobalParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitCreateTable(OracleStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateType(OracleStatementParser.CreateTypeContext ctx) {
        boolean isReplace = null != ctx.REPLACE();
        boolean isEditionable = null == ctx.NONEDITIONABLE();
        TypeSegment typeSegment = (TypeSegment)this.visit((ParseTree)ctx.plsqlTypeSource().typeName());
        if (null != ctx.plsqlTypeSource().objectSubTypeDef()) {
            OracleStatementParser.ObjectSubTypeDefContext objectSubTypeDefContext = ctx.plsqlTypeSource().objectSubTypeDef();
            return new OracleCreateSubTypeStatement(this.getDatabaseType(), isReplace, isEditionable, null == objectSubTypeDefContext.finalClause() || null == objectSubTypeDefContext.finalClause().NOT(), null == objectSubTypeDefContext.instantiableClause() || null == objectSubTypeDefContext.instantiableClause().NOT(), typeSegment, (Collection)objectSubTypeDefContext.dataTypeDefinition().stream().map(definition -> (TypeDefinitionSegment)this.visit((ParseTree)definition)).collect(Collectors.toList()));
        }
        return this.visitCreateTypeObjectBaseTypeDef(ctx.plsqlTypeSource().objectBaseTypeDef(), isReplace, isEditionable, typeSegment);
    }

    private ASTNode visitCreateTypeObjectBaseTypeDef(OracleStatementParser.ObjectBaseTypeDefContext ctx, boolean isReplace, boolean isEditionable, TypeSegment typeSegment) {
        if (null != ctx.objectTypeDef()) {
            OracleStatementParser.ObjectTypeDefContext objectTypeDefContext = ctx.objectTypeDef();
            return new OracleCreateObjectTypeStatement(this.getDatabaseType(), isReplace, isEditionable, null == objectTypeDefContext.finalClause() || null == objectTypeDefContext.finalClause().NOT(), null == objectTypeDefContext.instantiableClause() || null == objectTypeDefContext.instantiableClause().NOT(), null == objectTypeDefContext.persistableClause() || null == objectTypeDefContext.persistableClause().NOT(), typeSegment, (Collection)objectTypeDefContext.dataTypeDefinition().stream().map(definition -> (TypeDefinitionSegment)this.visit((ParseTree)definition)).collect(Collectors.toList()));
        }
        if (null != ctx.varrayTypeSpec()) {
            OracleStatementParser.VarrayTypeSpecContext varrayTypeSpecContext = ctx.varrayTypeSpec();
            return new OracleCreateVarrayTypeStatement(this.getDatabaseType(), isReplace, isEditionable, null == varrayTypeSpecContext.INTEGER_() ? -1 : Integer.parseInt(varrayTypeSpecContext.INTEGER_().getText()), null != varrayTypeSpecContext.typeSpec().NULL(), null == varrayTypeSpecContext.typeSpec().persistableClause() || null == varrayTypeSpecContext.typeSpec().persistableClause().NOT(), typeSegment, (DataTypeSegment)this.visit((ParseTree)varrayTypeSpecContext.typeSpec().dataType()));
        }
        OracleStatementParser.NestedTableTypeSpecContext nestedTableTypeSpecContext = ctx.nestedTableTypeSpec();
        return new OracleCreateNestedTableTypeStatement(this.getDatabaseType(), isReplace, isEditionable, null != nestedTableTypeSpecContext.typeSpec().NULL(), null == nestedTableTypeSpecContext.typeSpec().persistableClause() || null == nestedTableTypeSpecContext.typeSpec().persistableClause().NOT(), typeSegment, (DataTypeSegment)this.visit((ParseTree)nestedTableTypeSpecContext.typeSpec().dataType()));
    }

    @Override
    public ASTNode visitDataTypeDefinition(OracleStatementParser.DataTypeDefinitionContext ctx) {
        return new TypeDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.name().getText(), (DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
    }

    @Override
    public ASTNode visitCreateDefinitionClause(OracleStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.createRelationalTableClause()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.createRelationalTableClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateRelationalTableClause(OracleStatementParser.CreateRelationalTableClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null == ctx.relationalProperties()) {
            return result;
        }
        for (OracleStatementParser.RelationalPropertyContext each : ctx.relationalProperties().relationalProperty()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null != each.outOfLineConstraint()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.outOfLineConstraint()));
            }
            if (null == each.outOfLineRefConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.outOfLineRefConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(OracleStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = null == ctx.dataType() ? null : (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.inlineConstraint().stream().anyMatch(each -> null != each.primaryKey());
        boolean isNotNull = ctx.inlineConstraint().stream().anyMatch(each -> null != each.NOT() && null != each.NULL());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, isNotNull, this.getText(ctx));
        if (null != ctx.REF() && null != ctx.dataType()) {
            result.setRef(true);
        }
        for (OracleStatementParser.InlineConstraintContext each2 : ctx.inlineConstraint()) {
            if (null == each2.referencesClause()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each2.referencesClause().tableName()));
        }
        if (null != ctx.inlineRefConstraint()) {
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.inlineRefConstraint().tableName()));
        }
        return result;
    }

    private String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Override
    public ASTNode visitOutOfLineConstraint(OracleStatementParser.OutOfLineConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.primaryKey()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnNames())).getValue());
        }
        if (null != ctx.UNIQUE()) {
            result.getIndexColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnNames())).getValue());
        }
        if (null != ctx.referencesClause()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.referencesClause().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitOutOfLineRefConstraint(OracleStatementParser.OutOfLineRefConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.referencesClause()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.referencesClause().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(OracleStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyConstraintDefinitionSegment) {
                    result.getModifyConstraintDefinitions().add((ModifyConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropConstraintDefinitionSegment) {
                    result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ModifyCollectionRetrievalSegment)) continue;
                result.setModifyCollectionRetrieval((ModifyCollectionRetrievalSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTablespace(OracleStatementParser.AlterTablespaceContext ctx) {
        return new AlterTablespaceStatement(this.getDatabaseType(), null == ctx.tablespaceName() ? null : new TablespaceSegment(ctx.tablespaceName().getStart().getStartIndex(), ctx.tablespaceName().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.tablespaceName())), null == ctx.newTablespaceName() ? null : new TablespaceSegment(ctx.newTablespaceName().getStart().getStartIndex(), ctx.newTablespaceName().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.newTablespaceName())));
    }

    @Override
    public ASTNode visitAlterDefinitionClause(OracleStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.columnClauses()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnClauses())).getValue());
        }
        if (null != ctx.constraintClauses()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.constraintClauses())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitColumnClauses(OracleStatementParser.ColumnClausesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.OperateColumnClauseContext each : ctx.operateColumnClause()) {
            if (null != each.addColumnSpecification()) {
                result.getValue().addAll(((CollectionValue)this.visit((ParseTree)each.addColumnSpecification())).getValue());
            }
            if (null != each.modifyColumnSpecification()) {
                result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)each.modifyColumnSpecification()));
            }
            if (null == each.dropColumnClause()) continue;
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)each.dropColumnClause()));
        }
        if (null != ctx.modifyCollectionRetrieval()) {
            result.getValue().add((ModifyCollectionRetrievalSegment)this.visit((ParseTree)ctx.modifyCollectionRetrieval()));
        }
        return result;
    }

    @Override
    public ASTNode visitConstraintClauses(OracleStatementParser.ConstraintClausesContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.addConstraintSpecification()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.addConstraintSpecification()));
        }
        if (null != ctx.modifyConstraintClause()) {
            result.getValue().add((AlterDefinitionSegment)this.visit((ParseTree)ctx.modifyConstraintClause()));
        }
        for (OracleStatementParser.DropConstraintClauseContext each : ctx.dropConstraintClause()) {
            if (null == each.constraintName()) continue;
            result.getValue().add((AlterDefinitionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitModifyCollectionRetrieval(OracleStatementParser.ModifyCollectionRetrievalContext ctx) {
        return new ModifyCollectionRetrievalSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitAddColumnSpecification(OracleStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.ColumnOrVirtualDefinitionContext each : ctx.columnOrVirtualDefinitions().columnOrVirtualDefinition()) {
            if (null == each.columnDefinition()) continue;
            AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(each.columnDefinition().getStart().getStartIndex(), each.columnDefinition().getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition())));
            result.getValue().add(addColumnDefinition);
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(OracleStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnDefinitionSegment columnDefinition = null;
        for (OracleStatementParser.ModifyColPropertiesContext each : ctx.modifyColProperties()) {
            columnDefinition = (ColumnDefinitionSegment)this.visit((ParseTree)each);
        }
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnClause(OracleStatementParser.DropColumnClauseContext ctx) {
        if (null != ctx.dropColumnSpecification()) {
            return (ASTNode)this.visit((ParseTree)ctx.dropColumnSpecification());
        }
        LinkedList<ColumnSegment> columns = new LinkedList<ColumnSegment>();
        if (null != ctx.columnOrColumnList().columnName()) {
            columns.add((ColumnSegment)this.visit((ParseTree)ctx.columnOrColumnList().columnName()));
        } else {
            for (OracleStatementParser.ColumnNameContext each : ctx.columnOrColumnList().columnNames().columnName()) {
                columns.add((ColumnSegment)this.visit((ParseTree)each));
            }
        }
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitModifyColProperties(OracleStatementParser.ModifyColPropertiesContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = null == ctx.dataType() ? null : (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        return new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false, this.getText(ctx));
    }

    @Override
    public ASTNode visitDropColumnSpecification(OracleStatementParser.DropColumnSpecificationContext ctx) {
        LinkedList<ColumnSegment> columns = new LinkedList<ColumnSegment>();
        if (null != ctx.columnOrColumnList().columnName()) {
            columns.add((ColumnSegment)this.visit((ParseTree)ctx.columnOrColumnList().columnName()));
        } else {
            for (OracleStatementParser.ColumnNameContext each : ctx.columnOrColumnList().columnNames().columnName()) {
                columns.add((ColumnSegment)this.visit((ParseTree)each));
            }
        }
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitAddConstraintSpecification(OracleStatementParser.AddConstraintSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.OutOfLineConstraintContext each : ctx.outOfLineConstraint()) {
            result.getValue().add(new AddConstraintDefinitionSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)each)));
        }
        if (null != ctx.outOfLineRefConstraint()) {
            result.getValue().add(new AddConstraintDefinitionSegment(ctx.outOfLineRefConstraint().getStart().getStartIndex(), ctx.outOfLineRefConstraint().getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.outOfLineRefConstraint())));
        }
        return result;
    }

    @Override
    public ASTNode visitModifyConstraintClause(OracleStatementParser.ModifyConstraintClauseContext ctx) {
        if (null != ctx.constraintOption().constraintWithName()) {
            return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintOption().constraintWithName().constraintName()));
        }
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), null);
    }

    @Override
    public ASTNode visitDropConstraintClause(OracleStatementParser.DropConstraintClauseContext ctx) {
        return new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitDropContext(OracleStatementParser.DropContextContext ctx) {
        return new OracleDropContextStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropTable(OracleStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement(this.getDatabaseType());
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropDatabaseLink(OracleStatementParser.DropDatabaseLinkContext ctx) {
        return new OracleDropDatabaseLinkStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDatabaseLink(OracleStatementParser.AlterDatabaseLinkContext ctx) {
        return new OracleAlterDatabaseLinkStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDatabaseDictionary(OracleStatementParser.AlterDatabaseDictionaryContext ctx) {
        return new OracleAlterDatabaseDictionaryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterView(OracleStatementParser.AlterViewContext ctx) {
        AlterViewStatement result = new AlterViewStatement(this.getDatabaseType());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setConstraintDefinition((ConstraintDefinitionSegment)this.getAlterViewConstraintDefinition(ctx));
        return result;
    }

    private ASTNode getAlterViewConstraintDefinition(OracleStatementParser.AlterViewContext ctx) {
        ConstraintDefinitionSegment result = null;
        if (null != ctx.outOfLineConstraint()) {
            result = (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.outOfLineConstraint());
        } else if (null != ctx.constraintName()) {
            result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        return result;
    }

    @Override
    public ASTNode visitDropPackage(OracleStatementParser.DropPackageContext ctx) {
        return new DropPackageStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterPackage(OracleStatementParser.AlterPackageContext ctx) {
        return new AlterPackageStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateSynonym(OracleStatementParser.CreateSynonymContext ctx) {
        return new CreateSynonymStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropSynonym(OracleStatementParser.DropSynonymContext ctx) {
        return new DropSynonymStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDirectory(OracleStatementParser.CreateDirectoryContext ctx) {
        return new CreateDirectoryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropView(OracleStatementParser.DropViewContext ctx) {
        DropViewStatement result = new DropViewStatement(this.getDatabaseType());
        result.getViews().add((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        return result;
    }

    @Override
    public ASTNode visitCreateEdition(OracleStatementParser.CreateEditionContext ctx) {
        return new OracleCreateEditionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropTrigger(OracleStatementParser.DropTriggerContext ctx) {
        return new DropTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTrigger(OracleStatementParser.CreateTriggerContext ctx) {
        return new CreateTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTrigger(OracleStatementParser.AlterTriggerContext ctx) {
        return new AlterTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitTruncateTable(OracleStatementParser.TruncateTableContext ctx) {
        return new TruncateStatement(this.getDatabaseType(), Collections.singleton((SimpleTableSegment)this.visit((ParseTree)ctx.tableName())));
    }

    @Override
    public ASTNode visitCreateIndex(OracleStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement(this.getDatabaseType());
        if (null != ctx.createIndexDefinitionClause().tableIndexClause()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.createIndexDefinitionClause().tableIndexClause().tableName()));
            result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.createIndexDefinitionClause().tableIndexClause().indexExpressions())).getValue());
        }
        result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        if (null != ctx.createIndexSpecification() && null != ctx.createIndexSpecification().UNIQUE()) {
            result.getIndex().setUniqueKey(true);
        }
        return result;
    }

    @Override
    public ASTNode visitIndexExpressions(OracleStatementParser.IndexExpressionsContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.IndexExpressionContext each : ctx.indexExpression()) {
            ASTNode astNode = (ASTNode)this.visit((ParseTree)each);
            if (astNode instanceof ColumnSegment) {
                result.getValue().add((ColumnSegment)astNode);
            }
            if (!(astNode instanceof FunctionSegment)) continue;
            ((FunctionSegment)astNode).getParameters().forEach(parameter -> {
                if (parameter instanceof ColumnSegment) {
                    result.getValue().add((ColumnSegment)parameter);
                }
            });
        }
        return result;
    }

    @Override
    public ASTNode visitIndexExpression(OracleStatementParser.IndexExpressionContext ctx) {
        return null == ctx.expr() ? (ASTNode)this.visit((ParseTree)ctx.columnName()) : (ASTNode)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public ASTNode visitAlterIndex(OracleStatementParser.AlterIndexContext ctx) {
        AlterIndexStatement result = new AlterIndexStatement(this.getDatabaseType());
        result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(OracleStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement(this.getDatabaseType());
        result.getIndexes().add((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        return result;
    }

    @Override
    public ASTNode visitAlterSynonym(OracleStatementParser.AlterSynonymContext ctx) {
        return new AlterSynonymStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterSession(OracleStatementParser.AlterSessionContext ctx) {
        return new OracleAlterSessionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDatabase(OracleStatementParser.AlterDatabaseContext ctx) {
        return new AlterDatabaseStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterSystem(OracleStatementParser.AlterSystemContext ctx) {
        return new OracleAlterSystemStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAnalyze(OracleStatementParser.AnalyzeContext ctx) {
        return new OracleAnalyzeStatement(this.getDatabaseType(), null == ctx.tableName() ? null : (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), null == ctx.indexName() ? null : (IndexSegment)this.visit((ParseTree)ctx.indexName()));
    }

    @Override
    public ASTNode visitAssociateStatistics(OracleStatementParser.AssociateStatisticsContext ctx) {
        OracleAssociateStatisticsStatement result = new OracleAssociateStatisticsStatement(this.getDatabaseType());
        if (null != ctx.columnAssociation()) {
            for (OracleStatementParser.TableNameContext tableNameContext : ctx.columnAssociation().tableName()) {
                result.getTables().add((SimpleTableSegment)this.visit((ParseTree)tableNameContext));
            }
            for (OracleStatementParser.ColumnNameContext columnNameContext : ctx.columnAssociation().columnName()) {
                result.getColumns().add((ColumnSegment)this.visit((ParseTree)columnNameContext));
            }
        }
        if (null != ctx.functionAssociation()) {
            for (OracleStatementParser.IndexNameContext indexNameContext : ctx.functionAssociation().indexName()) {
                result.getIndexes().add((IndexSegment)this.visit((ParseTree)indexNameContext));
            }
            for (OracleStatementParser.FunctionContext functionContext : ctx.functionAssociation().function()) {
                result.getFunctions().add((FunctionSegment)this.visit((ParseTree)functionContext));
            }
            for (OracleStatementParser.PackageNameContext packageNameContext : ctx.functionAssociation().packageName()) {
                result.getPackages().add((PackageSegment)this.visit((ParseTree)packageNameContext));
            }
            for (OracleStatementParser.TypeNameContext typeNameContext : ctx.functionAssociation().typeName()) {
                result.getTypes().add((TypeSegment)this.visit((ParseTree)typeNameContext));
            }
            for (OracleStatementParser.IndexTypeNameContext indexTypeNameContext : ctx.functionAssociation().indexTypeName()) {
                result.getIndexTypes().add((IndexTypeSegment)this.visit((ParseTree)indexTypeNameContext));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDisassociateStatistics(OracleStatementParser.DisassociateStatisticsContext ctx) {
        OracleDisassociateStatisticsStatement result = new OracleDisassociateStatisticsStatement(this.getDatabaseType());
        if (null != ctx.tableName()) {
            for (OracleStatementParser.TableNameContext tableNameContext : ctx.tableName()) {
                result.getTables().add((SimpleTableSegment)this.visit((ParseTree)tableNameContext));
            }
            for (OracleStatementParser.ColumnNameContext columnNameContext : ctx.columnName()) {
                result.getColumns().add((ColumnSegment)this.visit((ParseTree)columnNameContext));
            }
        }
        if (null != ctx.indexName()) {
            for (OracleStatementParser.IndexNameContext indexNameContext : ctx.indexName()) {
                result.getIndexes().add((IndexSegment)this.visit((ParseTree)indexNameContext));
            }
        }
        if (null != ctx.function()) {
            for (OracleStatementParser.FunctionContext functionContext : ctx.function()) {
                result.getFunctions().add((FunctionSegment)this.visit((ParseTree)functionContext));
            }
        }
        if (null != ctx.packageName()) {
            for (OracleStatementParser.PackageNameContext packageNameContext : ctx.packageName()) {
                result.getPackages().add((PackageSegment)this.visit((ParseTree)packageNameContext));
            }
        }
        if (null != ctx.typeName()) {
            for (OracleStatementParser.TypeNameContext typeNameContext : ctx.typeName()) {
                result.getTypes().add((TypeSegment)this.visit((ParseTree)typeNameContext));
            }
        }
        if (null != ctx.indexTypeName()) {
            for (OracleStatementParser.IndexTypeNameContext indexTypeNameContext : ctx.indexTypeName()) {
                result.getIndexTypes().add((IndexTypeSegment)this.visit((ParseTree)indexTypeNameContext));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAudit(OracleStatementParser.AuditContext ctx) {
        return null == ctx.auditTraditional() ? (ASTNode)this.visit((ParseTree)ctx.auditUnified()) : (ASTNode)this.visit((ParseTree)ctx.auditTraditional());
    }

    @Override
    public ASTNode visitAuditTraditional(OracleStatementParser.AuditTraditionalContext ctx) {
        return new OracleAuditStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAuditUnified(OracleStatementParser.AuditUnifiedContext ctx) {
        return new OracleAuditStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitNoAudit(OracleStatementParser.NoAuditContext ctx) {
        return new OracleNoAuditStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitComment(OracleStatementParser.CommentContext ctx) {
        CommentStatement result = new CommentStatement(this.getDatabaseType());
        if (null != ctx.tableName()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        }
        if (null != ctx.columnName()) {
            result.setColumn((ColumnSegment)this.visit((ParseTree)ctx.columnName()));
        }
        if (null != ctx.indexTypeName()) {
            result.setIndexType((IndexTypeSegment)this.visit((ParseTree)ctx.indexTypeName()));
        }
        result.setComment(new IdentifierValue(ctx.STRING_().getText()));
        return result;
    }

    @Override
    public ASTNode visitFlashbackDatabase(OracleStatementParser.FlashbackDatabaseContext ctx) {
        return new OracleFlashbackDatabaseStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitFlashbackTable(OracleStatementParser.FlashbackTableContext ctx) {
        return new OracleFlashbackTableStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), null == ctx.renameToTable() ? null : (SimpleTableSegment)this.visit((ParseTree)ctx.renameToTable().tableName()));
    }

    @Override
    public ASTNode visitPurge(OracleStatementParser.PurgeContext ctx) {
        return new OraclePurgeStatement(this.getDatabaseType(), null == ctx.tableName() ? null : (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), null == ctx.indexName() ? null : (IndexSegment)this.visit((ParseTree)ctx.indexName()));
    }

    @Override
    public ASTNode visitRename(OracleStatementParser.RenameContext ctx) {
        return new OracleRenameStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDatabase(OracleStatementParser.CreateDatabaseContext ctx) {
        return new CreateDatabaseStatement(this.getDatabaseType(), null, false);
    }

    @Override
    public ASTNode visitCreateDatabaseLink(OracleStatementParser.CreateDatabaseLinkContext ctx) {
        return new OracleCreateDatabaseLinkStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDimension(OracleStatementParser.CreateDimensionContext ctx) {
        return new OracleCreateDimensionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDimension(OracleStatementParser.AlterDimensionContext ctx) {
        return new OracleAlterDimensionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDimension(OracleStatementParser.DropDimensionContext ctx) {
        return new OracleDropDimensionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDirectory(OracleStatementParser.DropDirectoryContext ctx) {
        return new DropDirectoryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateFunction(OracleStatementParser.CreateFunctionContext ctx) {
        return this.visitCreateFunction0(ctx);
    }

    private ASTNode visitCreateFunction0(OracleStatementParser.CreateFunctionContext ctx) {
        if (null != ctx.plsqlFunctionSource().declareSection()) {
            this.visit((ParseTree)ctx.plsqlFunctionSource().declareSection());
        }
        if (null != ctx.plsqlFunctionSource().body()) {
            this.visit((ParseTree)ctx.plsqlFunctionSource().body());
        }
        this.getSqlStatementsInPlsql().sort(Comparator.comparingInt(SQLStatementSegment::getStartIndex));
        this.getProcedureCallNames().sort(Comparator.comparingInt(ProcedureCallNameSegment::getStartIndex));
        this.getDynamicSqlStatementExpressions().sort(Comparator.comparingInt(SQLSegment::getStartIndex));
        OracleCreateFunctionStatement result = new OracleCreateFunctionStatement(this.getDatabaseType(), this.getSqlStatementsInPlsql(), this.getProcedureCallNames());
        result.setFunctionName(this.visitFunctionName(ctx.plsqlFunctionSource()));
        result.getDynamicSqlStatementExpressions().addAll(this.getDynamicSqlStatementExpressions());
        return result;
    }

    private FunctionNameSegment visitFunctionName(OracleStatementParser.PlsqlFunctionSourceContext ctx) {
        OracleStatementParser.OwnerContext schema = ctx.function().owner();
        IdentifierValue functionName = (IdentifierValue)this.visit((ParseTree)ctx.function().name().identifier());
        if (null == schema) {
            return new FunctionNameSegment(ctx.function().name().start.getStartIndex(), ctx.function().name().stop.getStopIndex(), functionName);
        }
        OwnerSegment owner = new OwnerSegment(schema.start.getStartIndex(), schema.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)schema.identifier()));
        FunctionNameSegment result = new FunctionNameSegment(ctx.function().start.getStartIndex(), ctx.function().stop.getStopIndex(), functionName);
        result.setOwner(owner);
        return result;
    }

    @Override
    public ASTNode visitDropEdition(OracleStatementParser.DropEditionContext ctx) {
        return new OracleDropEditionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropOutline(OracleStatementParser.DropOutlineContext ctx) {
        return new OracleDropOutlineStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterOutline(OracleStatementParser.AlterOutlineContext ctx) {
        return new OracleAlterOutlineStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterAnalyticView(OracleStatementParser.AlterAnalyticViewContext ctx) {
        return new OracleAlterAnalyticViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterAttributeDimension(OracleStatementParser.AlterAttributeDimensionContext ctx) {
        return new OracleAlterAttributeDimensionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateSequence(OracleStatementParser.CreateSequenceContext ctx) {
        return new CreateSequenceStatement(this.getDatabaseType(), ctx.sequenceName().getText());
    }

    @Override
    public ASTNode visitAlterSequence(OracleStatementParser.AlterSequenceContext ctx) {
        return new AlterSequenceStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitCreateContext(OracleStatementParser.CreateContextContext ctx) {
        return new OracleCreateContextStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateSPFile(OracleStatementParser.CreateSPFileContext ctx) {
        return new OracleCreateSPFileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreatePFile(OracleStatementParser.CreatePFileContext ctx) {
        return new OracleCreatePFileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateControlFile(OracleStatementParser.CreateControlFileContext ctx) {
        return new OracleCreateControlFileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateFlashbackArchive(OracleStatementParser.CreateFlashbackArchiveContext ctx) {
        return new OracleCreateFlashbackArchiveStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterFlashbackArchive(OracleStatementParser.AlterFlashbackArchiveContext ctx) {
        return new OracleAlterFlashbackArchiveStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropFlashbackArchive(OracleStatementParser.DropFlashbackArchiveContext ctx) {
        return new OracleDropFlashbackArchiveStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDiskgroup(OracleStatementParser.CreateDiskgroupContext ctx) {
        return new OracleCreateDiskgroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDiskgroup(OracleStatementParser.DropDiskgroupContext ctx) {
        return new OracleDropDiskgroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateRollbackSegment(OracleStatementParser.CreateRollbackSegmentContext ctx) {
        return new OracleCreateRollbackSegmentStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRollbackSegment(OracleStatementParser.DropRollbackSegmentContext ctx) {
        return new OracleDropRollbackSegmentStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropTableSpace(OracleStatementParser.DropTableSpaceContext ctx) {
        return new DropTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateLockdownProfile(OracleStatementParser.CreateLockdownProfileContext ctx) {
        return new OracleCreateLockdownProfileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropLockdownProfile(OracleStatementParser.DropLockdownProfileContext ctx) {
        return new OracleDropLockdownProfileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateInmemoryJoinGroup(OracleStatementParser.CreateInmemoryJoinGroupContext ctx) {
        return new OracleCreateInMemoryJoinGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterInmemoryJoinGroup(OracleStatementParser.AlterInmemoryJoinGroupContext ctx) {
        return new OracleAlterInMemoryJoinGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropInmemoryJoinGroup(OracleStatementParser.DropInmemoryJoinGroupContext ctx) {
        return new OracleDropInMemoryJoinGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateRestorePoint(OracleStatementParser.CreateRestorePointContext ctx) {
        return new OracleCreateRestorePointStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRestorePoint(OracleStatementParser.DropRestorePointContext ctx) {
        return new OracleDropRestorePointStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterOperator(OracleStatementParser.AlterOperatorContext ctx) {
        return new AlterOperatorStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterProfile(OracleStatementParser.AlterProfileContext ctx) {
        return new OracleAlterProfileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterRollbackSegment(OracleStatementParser.AlterRollbackSegmentContext ctx) {
        return new OracleAlterRollbackSegmentStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropOperator(OracleStatementParser.DropOperatorContext ctx) {
        return new DropOperatorStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropSequence(OracleStatementParser.DropSequenceContext ctx) {
        return new DropSequenceStatement(this.getDatabaseType(), Collections.emptyList());
    }

    @Override
    public ASTNode visitAlterLibrary(OracleStatementParser.AlterLibraryContext ctx) {
        return new OracleAlterLibraryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropType(OracleStatementParser.DropTypeContext ctx) {
        return new DropPackageStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterMaterializedZonemap(OracleStatementParser.AlterMaterializedZonemapContext ctx) {
        return new OracleAlterMaterializedZoneMapStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterJava(OracleStatementParser.AlterJavaContext ctx) {
        return new OracleAlterJavaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterAuditPolicy(OracleStatementParser.AlterAuditPolicyContext ctx) {
        return new OracleAlterAuditPolicyStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterCluster(OracleStatementParser.AlterClusterContext ctx) {
        return new OracleAlterClusterStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDiskgroup(OracleStatementParser.AlterDiskgroupContext ctx) {
        return new OracleAlterDiskgroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterIndexType(OracleStatementParser.AlterIndexTypeContext ctx) {
        return new OracleAlterIndexTypeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterMaterializedView(OracleStatementParser.AlterMaterializedViewContext ctx) {
        return new AlterMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterMaterializedViewLog(OracleStatementParser.AlterMaterializedViewLogContext ctx) {
        return new OracleAlterMaterializedViewLogStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterFunction(OracleStatementParser.AlterFunctionContext ctx) {
        return new AlterFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterHierarchy(OracleStatementParser.AlterHierarchyContext ctx) {
        return new OracleAlterHierarchyStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterLockdownProfile(OracleStatementParser.AlterLockdownProfileContext ctx) {
        return new OracleAlterLockdownProfileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterPluggableDatabase(OracleStatementParser.AlterPluggableDatabaseContext ctx) {
        return new OracleAlterPluggableDatabaseStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateProcedure(OracleStatementParser.CreateProcedureContext ctx) {
        return this.visitCreateProcedure0(ctx);
    }

    private ASTNode visitCreateProcedure0(OracleStatementParser.CreateProcedureContext ctx) {
        if (null != ctx.plsqlProcedureSource().parameterDeclaration()) {
            for (OracleStatementParser.ParameterDeclarationContext each2 : ctx.plsqlProcedureSource().parameterDeclaration()) {
                this.visit((ParseTree)each2);
            }
        }
        if (null != ctx.plsqlProcedureSource().declareSection()) {
            this.visit((ParseTree)ctx.plsqlProcedureSource().declareSection());
        }
        if (null != ctx.plsqlProcedureSource().body()) {
            this.visit((ParseTree)ctx.plsqlProcedureSource().body());
        }
        this.getSqlStatementsInPlsql().sort(Comparator.comparingInt(SQLStatementSegment::getStartIndex));
        this.getProcedureCallNames().sort(Comparator.comparingInt(ProcedureCallNameSegment::getStartIndex));
        this.getDynamicSqlStatementExpressions().sort(Comparator.comparingInt(SQLSegment::getStartIndex));
        OracleCreateProcedureStatement result = new OracleCreateProcedureStatement(this.getDatabaseType());
        result.getProcedureCallNames().addAll(this.getProcedureCallNames());
        result.getProcedureBodyEndNameSegments().addAll(this.getProcedureBodyEndNameSegments());
        result.getDynamicSqlStatementExpressions().addAll(this.getDynamicSqlStatementExpressions());
        result.setProcedureName(this.visitProcedureName(ctx.plsqlProcedureSource()));
        result.getSqlStatements().addAll(this.getSqlStatementsInPlsql());
        result.getVariableNames().addAll(this.getVariableNames());
        this.getSqlStatementsInPlsql().forEach(each -> each.getSqlStatement().getVariableNames().addAll(this.getVariableNames()));
        result.getCursorForLoopStatements().addAll(this.getCursorForLoopStatementSegments());
        return result;
    }

    @Override
    public ASTNode visitParameterDeclaration(OracleStatementParser.ParameterDeclarationContext ctx) {
        if (null != ctx.parameterName()) {
            IdentifierValue paramName = (IdentifierValue)this.visit((ParseTree)ctx.parameterName().identifier());
            this.getVariableNames().add(paramName.getValue().toLowerCase());
            return new VariableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), paramName.getValue());
        }
        return (ASTNode)super.visitParameterDeclaration(ctx);
    }

    @Override
    public ASTNode visitItemDeclaration(OracleStatementParser.ItemDeclarationContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.collectionVariableDecl() && null != ctx.collectionVariableDecl().variableName()) {
            for (OracleStatementParser.VariableNameContext each : ctx.collectionVariableDecl().variableName()) {
                this.getVariableSegment(each).ifPresent(optional -> result.getValue().add(optional));
            }
        }
        if (null != ctx.constantDeclaration() && null != ctx.constantDeclaration().variableName()) {
            this.getVariableSegment(ctx.constantDeclaration().variableName()).ifPresent(optional -> result.getValue().add(optional));
        }
        if (null != ctx.cursorVariableDeclaration() && null != ctx.cursorVariableDeclaration().variableName()) {
            this.getVariableSegment(ctx.cursorVariableDeclaration().variableName()).ifPresent(optional -> result.getValue().add(optional));
        }
        if (null != ctx.exceptionDeclaration() && null != ctx.exceptionDeclaration().variableName()) {
            this.getVariableSegment(ctx.exceptionDeclaration().variableName()).ifPresent(optional -> result.getValue().add(optional));
        }
        if (null != ctx.recordVariableDeclaration() && null != ctx.recordVariableDeclaration().variableName()) {
            this.getVariableSegment(ctx.recordVariableDeclaration().variableName()).ifPresent(optional -> result.getValue().add(optional));
        }
        if (null != ctx.variableDeclaration() && null != ctx.variableDeclaration().variableName()) {
            this.getVariableSegment(ctx.variableDeclaration().variableName()).ifPresent(optional -> result.getValue().add(optional));
        }
        return result;
    }

    private Optional<VariableSegment> getVariableSegment(OracleStatementParser.VariableNameContext variableNameContext) {
        if (null == variableNameContext) {
            return Optional.empty();
        }
        if (null != variableNameContext.identifier()) {
            String variableName = ((IdentifierValue)this.visitIdentifier(variableNameContext.identifier())).getValue().toLowerCase();
            this.getVariableNames().add(variableName);
            return Optional.of(new VariableSegment(variableNameContext.start.getStartIndex(), variableNameContext.stop.getStopIndex(), variableName));
        }
        if (null != variableNameContext.stringLiterals()) {
            String variableName = variableNameContext.stringLiterals().STRING_().getText().toLowerCase();
            this.getVariableNames().add(variableName);
            return Optional.of(new VariableSegment(variableNameContext.start.getStartIndex(), variableNameContext.stop.getStopIndex(), variableName));
        }
        return Optional.empty();
    }

    @Override
    public ASTNode visitCollectionVariableDecl(OracleStatementParser.CollectionVariableDeclContext ctx) {
        if (null == ctx.variableName()) {
            return (ASTNode)super.visitCollectionVariableDecl(ctx);
        }
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.VariableNameContext each : ctx.variableName()) {
            this.getVariableSegment(each).ifPresent(optional -> result.getValue().add(optional));
        }
        return result;
    }

    private FunctionNameSegment visitProcedureName(OracleStatementParser.PlsqlProcedureSourceContext ctx) {
        OracleStatementParser.SchemaNameContext schemaName = ctx.schemaName();
        IdentifierValue procedureName = (IdentifierValue)this.visit((ParseTree)ctx.procedureName().identifier());
        if (null == schemaName) {
            return new FunctionNameSegment(ctx.procedureName().start.getStartIndex(), ctx.procedureName().stop.getStopIndex(), procedureName);
        }
        OwnerSegment owner = new OwnerSegment(schemaName.start.getStartIndex(), schemaName.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)schemaName.identifier()));
        FunctionNameSegment result = new FunctionNameSegment(schemaName.start.getStartIndex(), ctx.procedureName().stop.getStopIndex(), procedureName);
        result.setOwner(owner);
        return result;
    }

    @Override
    public ASTNode visitCursorDefinition(OracleStatementParser.CursorDefinitionContext ctx) {
        SQLStatement sqlStatement = this.visitSelect0(ctx.select());
        this.getCursorStatements().put(null != ctx.variableName().identifier() ? new IdentifierValue(ctx.variableName().getText()).getValue() : new StringLiteralValue(ctx.variableName().getText()).getValue(), sqlStatement);
        return (ASTNode)this.defaultResult();
    }

    @Override
    public ASTNode visitBody(OracleStatementParser.BodyContext ctx) {
        for (OracleStatementParser.StatementContext each : ctx.statement()) {
            this.visit((ParseTree)each);
        }
        for (OracleStatementParser.ExceptionHandlerContext eachExceptionHandler : ctx.exceptionHandler()) {
            for (OracleStatementParser.StatementContext each : eachExceptionHandler.statement()) {
                this.visit((ParseTree)each);
            }
        }
        if (null != ctx.identifier()) {
            this.getProcedureBodyEndNameSegments().add(new ProcedureBodyEndNameSegment(ctx.identifier().getStart().getStartIndex(), ctx.identifier().getStop().getStopIndex(), new IdentifierValue(ctx.identifier().getText())));
        }
        return (ASTNode)this.defaultResult();
    }

    @Override
    public ASTNode visitProcedureCall(OracleStatementParser.ProcedureCallContext ctx) {
        int startIndex = ctx.procedureName().start.getStartIndex();
        PackageSegment packageSegment = null;
        if (null != ctx.packageName()) {
            startIndex = ctx.packageName().start.getStartIndex();
            packageSegment = (PackageSegment)this.visit((ParseTree)ctx.packageName());
        }
        ProcedureCallNameSegment result = new ProcedureCallNameSegment(startIndex, ctx.procedureName().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.procedureName().identifier()));
        result.setPackageSegment(packageSegment);
        this.getProcedureCallNames().add(result);
        return (ASTNode)this.defaultResult();
    }

    @Override
    public ASTNode visitCursorForLoopStatement(OracleStatementParser.CursorForLoopStatementContext ctx) {
        SQLStatement relatedCursorStatement;
        String cursorName = null;
        if (null != ctx.select()) {
            relatedCursorStatement = this.visitSelect0(ctx.select());
        } else {
            cursorName = null == ctx.cursor().variableName().identifier() ? new StringLiteralValue(ctx.cursor().getText()).getValue() : new IdentifierValue(ctx.cursor().getText()).getValue();
            relatedCursorStatement = this.getCursorStatements().get(cursorName);
        }
        this.increaseCursorForLoopLevel();
        for (OracleStatementParser.StatementContext each : ctx.statement()) {
            this.visit((ParseTree)each);
        }
        Set<SQLStatement> sqlStatements = this.getTempCursorForLoopStatements().remove(this.getCursorForLoopLevel());
        CursorForLoopStatementSegment cursorForLoopStatementSegment = new CursorForLoopStatementSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.record().getText()).getValue(), cursorName, relatedCursorStatement, null == sqlStatements ? Collections.emptyList() : sqlStatements);
        this.getCursorForLoopStatementSegments().add(cursorForLoopStatementSegment);
        this.decreaseCursorForLoopLevel();
        return (ASTNode)this.defaultResult();
    }

    @Override
    public ASTNode visitOpenForStatement(OracleStatementParser.OpenForStatementContext ctx) {
        if (null != ctx.select()) {
            this.visitSelect0(ctx.select());
        }
        return (ASTNode)this.defaultResult();
    }

    private SQLStatement visitSelect0(OracleStatementParser.SelectContext select) {
        OracleStatementVisitor visitor = this.createOracleDMLStatementVisitor();
        SQLStatement result = (SQLStatement)visitor.visitSelect(select);
        this.getSqlStatementsInPlsql().add(new SQLStatementSegment(select.start.getStartIndex(), select.stop.getStopIndex(), result));
        this.addToTempCursorForLoopStatements(result);
        return result;
    }

    private void addToTempCursorForLoopStatements(SQLStatement sqlStatement) {
        if (0 == this.getCursorForLoopLevel()) {
            return;
        }
        for (int i = 1; i <= this.getCursorForLoopLevel(); ++i) {
            this.getTempCursorForLoopStatements().computeIfAbsent(i, key -> new LinkedHashSet()).add(sqlStatement);
        }
    }

    @Override
    public ASTNode visitSqlStatementInPlsql(OracleStatementParser.SqlStatementInPlsqlContext ctx) {
        SQLStatement result;
        OracleStatementVisitor visitor;
        if (null != ctx.commit()) {
            visitor = this.createOracleTCLStatementVisitor();
            result = (SQLStatement)visitor.visitCommit(ctx.commit());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.commit().start.getStartIndex(), ctx.commit().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.delete()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitDelete(ctx.delete());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.delete().start.getStartIndex(), ctx.delete().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.insert()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitInsert(ctx.insert());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.insert().start.getStartIndex(), ctx.insert().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.lock()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitLock(ctx.lock());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.lock().start.getStartIndex(), ctx.lock().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.merge()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitMerge(ctx.merge());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.merge().start.getStartIndex(), ctx.merge().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.rollback()) {
            visitor = this.createOracleTCLStatementVisitor();
            result = (SQLStatement)visitor.visitRollback(ctx.rollback());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.rollback().start.getStartIndex(), ctx.rollback().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.savepoint()) {
            visitor = this.createOracleTCLStatementVisitor();
            result = (SQLStatement)visitor.visitSavepoint(ctx.savepoint());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.savepoint().start.getStartIndex(), ctx.savepoint().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.setTransaction()) {
            visitor = this.createOracleTCLStatementVisitor();
            result = (SQLStatement)visitor.visitSetTransaction(ctx.setTransaction());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.setTransaction().start.getStartIndex(), ctx.setTransaction().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.update()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitUpdate(ctx.update());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.update().start.getStartIndex(), ctx.update().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        return (ASTNode)this.defaultResult();
    }

    private OracleStatementVisitor createOracleTCLStatementVisitor() {
        OracleTCLStatementVisitor result = new OracleTCLStatementVisitor(this.getDatabaseType());
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    private OracleStatementVisitor createOracleDMLStatementVisitor() {
        OracleDMLStatementVisitor result = new OracleDMLStatementVisitor(this.getDatabaseType());
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    @Override
    public ASTNode visitDmlStatement(OracleStatementParser.DmlStatementContext ctx) {
        SQLStatement result;
        OracleStatementVisitor visitor;
        if (null != ctx.insert()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitInsert(ctx.insert());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.insert().start.getStartIndex(), ctx.insert().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.update()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitUpdate(ctx.update());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.update().start.getStartIndex(), ctx.update().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.delete()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitDelete(ctx.delete());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.delete().start.getStartIndex(), ctx.delete().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        if (null != ctx.merge()) {
            visitor = this.createOracleDMLStatementVisitor();
            result = (SQLStatement)visitor.visitMerge(ctx.merge());
            this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.merge().start.getStartIndex(), ctx.merge().stop.getStopIndex(), result));
            this.addToTempCursorForLoopStatements(result);
        }
        return (ASTNode)this.defaultResult();
    }

    @Override
    public ASTNode visitSelectIntoStatement(OracleStatementParser.SelectIntoStatementContext ctx) {
        OracleStatementVisitor visitor = this.createOracleDMLStatementVisitor();
        SelectStatement result = (SelectStatement)visitor.visitSelectIntoStatement(ctx);
        this.getSqlStatementsInPlsql().add(new SQLStatementSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (SQLStatement)result));
        this.addToTempCursorForLoopStatements((SQLStatement)result);
        return result;
    }

    @Override
    public ASTNode visitDynamicSqlStmt(OracleStatementParser.DynamicSqlStmtContext ctx) {
        ExpressionSegment result = (ExpressionSegment)this.visit((ParseTree)ctx.expression().expr());
        this.getDynamicSqlStatementExpressions().add(result);
        return result;
    }

    @Override
    public ASTNode visitPlsqlBlock(OracleStatementParser.PlsqlBlockContext ctx) {
        if (null != ctx.body() && null != ctx.body().statement()) {
            ctx.body().statement().forEach(arg_0 -> ((OracleDDLStatementVisitor)this).visit(arg_0));
        }
        return new OraclePLSQLBlockStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterProcedure(OracleStatementParser.AlterProcedureContext ctx) {
        return new AlterProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropProcedure(OracleStatementParser.DropProcedureContext ctx) {
        return new DropProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropIndexType(OracleStatementParser.DropIndexTypeContext ctx) {
        return new OracleDropIndexTypeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropProfile(OracleStatementParser.DropProfileContext ctx) {
        return new OracleDropProfileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropPluggableDatabase(OracleStatementParser.DropPluggableDatabaseContext ctx) {
        return new OracleDropPluggableDatabaseStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropJava(OracleStatementParser.DropJavaContext ctx) {
        return new OracleDropJavaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropFunction(OracleStatementParser.DropFunctionContext ctx) {
        return new DropFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropLibrary(OracleStatementParser.DropLibraryContext ctx) {
        return new OracleDropLibraryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropCluster(OracleStatementParser.DropClusterContext ctx) {
        return new OracleDropClusterStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropMaterializedView(OracleStatementParser.DropMaterializedViewContext ctx) {
        return new DropMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropMaterializedViewLog(OracleStatementParser.DropMaterializedViewLogContext ctx) {
        return new OracleDropMaterializedViewLogStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropMaterializedZonemap(OracleStatementParser.DropMaterializedZonemapContext ctx) {
        return new OracleDropMaterializedZoneMapStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTablespace(OracleStatementParser.CreateTablespaceContext ctx) {
        return new CreateTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateMaterializedView(OracleStatementParser.CreateMaterializedViewContext ctx) {
        return new CreateMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateMaterializedViewLog(OracleStatementParser.CreateMaterializedViewLogContext ctx) {
        return new OracleCreateMaterializedViewLogStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateCluster(OracleStatementParser.CreateClusterContext ctx) {
        return new OracleCreateClusterStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSystemAction(OracleStatementParser.SystemActionContext ctx) {
        return new OracleSystemActionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterType(OracleStatementParser.AlterTypeContext ctx) {
        return new AlterTypeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateJava(OracleStatementParser.CreateJavaContext ctx) {
        return new OracleCreateJavaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateLibrary(OracleStatementParser.CreateLibraryContext ctx) {
        return new OracleCreateLibraryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSwitch(OracleStatementParser.SwitchContext ctx) {
        return new OracleSwitchStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateProfile(OracleStatementParser.CreateProfileContext ctx) {
        return new OracleCreateProfileStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDatabase(OracleStatementParser.DropDatabaseContext ctx) {
        return new DropDatabaseStatement(this.getDatabaseType(), null, false);
    }

    @Override
    public ASTNode visitCreateOperator(OracleStatementParser.CreateOperatorContext ctx) {
        return new CreateOperatorStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateOutline(OracleStatementParser.CreateOutlineContext ctx) {
        return new OracleCreateOutlineStatement(this.getDatabaseType());
    }
}

