/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SequenceFunction;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.packages.PackageSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.type.TypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.datetime.DatetimeExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.interval.IntervalDayToSecondExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.interval.IntervalYearToMonthExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.IntervalExpressionProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.join.OuterJoinExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.multiset.MultisetExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlElementFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlNamespaceStringAsIdentifierSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlNamespacesClauseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlPiFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlQueryAndExistsFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlSerializeFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlTableColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlTableFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlTableOptionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.CursorForLoopStatementSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.ProcedureBodyEndNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.ProcedureCallNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.procedure.SQLStatementSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.DateTimeLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NullLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.parametermarker.ParameterMarkerValue;

public abstract class OracleStatementVisitor
extends OracleStatementBaseVisitor<ASTNode> {
    private final DatabaseType databaseType;
    private final Collection<ParameterMarkerSegment> globalParameterMarkerSegments = new LinkedList<ParameterMarkerSegment>();
    private final Collection<ParameterMarkerSegment> statementParameterMarkerSegments = new LinkedList<ParameterMarkerSegment>();
    private final List<SQLStatementSegment> sqlStatementsInPlsql = new ArrayList<SQLStatementSegment>();
    private final List<ProcedureCallNameSegment> procedureCallNames = new ArrayList<ProcedureCallNameSegment>();
    private final List<ProcedureBodyEndNameSegment> procedureBodyEndNameSegments = new ArrayList<ProcedureBodyEndNameSegment>();
    private final List<ExpressionSegment> dynamicSqlStatementExpressions = new ArrayList<ExpressionSegment>();
    private final Collection<String> variableNames = new HashSet<String>();
    private final Map<String, SQLStatement> cursorStatements = new HashMap<String, SQLStatement>();
    private final List<CursorForLoopStatementSegment> cursorForLoopStatementSegments = new ArrayList<CursorForLoopStatementSegment>();
    private final Map<Integer, Set<SQLStatement>> tempCursorForLoopStatements = new HashMap<Integer, Set<SQLStatement>>();
    private int cursorForLoopLevel;

    @Override
    public final ASTNode visitParameterMarker(OracleStatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.getParameterMarkerIndex(ctx)), ParameterMarkerType.QUESTION);
    }

    private int getParameterMarkerIndex(OracleStatementParser.ParameterMarkerContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        if (startIndex <= 0) {
            return 0;
        }
        String sql = ctx.getStart().getInputStream().getText(new Interval(0, startIndex - 1));
        return this.countParameterMarkers(sql);
    }

    private int countParameterMarkers(String sql) {
        ParameterMarkerScanState state = new ParameterMarkerScanState();
        while (state.index < sql.length()) {
            if (this.advanceInLineComment(sql, state) || this.advanceInBlockComment(sql, state) || this.advanceInOrToggleStringLiteral(sql, state) || this.enterLineOrBlockComment(sql, state)) continue;
            if (!state.inStringLiteral && sql.charAt(state.index) == '?') {
                state.result++;
            }
            state.index++;
        }
        return state.result;
    }

    private boolean advanceInLineComment(String sql, ParameterMarkerScanState state) {
        if (!state.inLineComment) {
            return false;
        }
        char ch = sql.charAt(state.index);
        if ('\n' == ch || '\r' == ch) {
            state.inLineComment = false;
        }
        state.index++;
        return true;
    }

    private boolean advanceInBlockComment(String sql, ParameterMarkerScanState state) {
        if (!state.inBlockComment) {
            return false;
        }
        char ch = sql.charAt(state.index);
        if ('*' == ch && state.index + 1 < sql.length() && '/' == sql.charAt(state.index + 1)) {
            state.inBlockComment = false;
            state.index += 2;
        } else {
            state.index++;
        }
        return true;
    }

    private boolean advanceInOrToggleStringLiteral(String sql, ParameterMarkerScanState state) {
        if (sql.charAt(state.index) != '\'') {
            return false;
        }
        if (state.inStringLiteral && state.index + 1 < sql.length() && '\'' == sql.charAt(state.index + 1)) {
            state.index += 2;
        } else {
            state.inStringLiteral = !state.inStringLiteral;
            state.index++;
        }
        return true;
    }

    private boolean enterLineOrBlockComment(String sql, ParameterMarkerScanState state) {
        if (state.inStringLiteral) {
            return false;
        }
        char ch = sql.charAt(state.index);
        if ('-' == ch && state.index + 1 < sql.length() && '-' == sql.charAt(state.index + 1)) {
            state.inLineComment = true;
            state.index += 2;
            return true;
        }
        if ('/' == ch && state.index + 1 < sql.length() && '*' == sql.charAt(state.index + 1)) {
            state.inBlockComment = true;
            state.index += 2;
            return true;
        }
        return false;
    }

    @Override
    public final ASTNode visitLiterals(OracleStatementParser.LiteralsContext ctx) {
        if (null != ctx.stringLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.stringLiterals());
        }
        if (null != ctx.numberLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.numberLiterals());
        }
        if (null != ctx.hexadecimalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.hexadecimalLiterals());
        }
        if (null != ctx.bitValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.bitValueLiterals());
        }
        if (null != ctx.booleanLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanLiterals());
        }
        if (null != ctx.nullValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.nullValueLiterals());
        }
        if (null != ctx.dateTimeLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.dateTimeLiterals());
        }
        if (null != ctx.intervalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.intervalLiterals());
        }
        throw new IllegalStateException("Literals must have string, number, dateTime, hex, bit, interval, boolean or null.");
    }

    @Override
    public ASTNode visitDateTimeLiterals(OracleStatementParser.DateTimeLiteralsContext ctx) {
        if (null != ctx.LBE_()) {
            return new DateTimeLiteralValue(ctx.identifier().getText(), ((StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals())).getValue(), true);
        }
        String dateTimeType = null != ctx.DATE() ? ctx.DATE().getText() : (null != ctx.TIME() ? ctx.TIME().getText() : ctx.TIMESTAMP().getText());
        return new DateTimeLiteralValue(dateTimeType, ((StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals())).getValue(), false);
    }

    @Override
    public final ASTNode visitStringLiterals(OracleStatementParser.StringLiteralsContext ctx) {
        if (null != ctx.STRING_()) {
            return new StringLiteralValue(ctx.getText());
        }
        return new StringLiteralValue(ctx.getText().substring(1));
    }

    @Override
    public final ASTNode visitNumberLiterals(OracleStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitHexadecimalLiterals(OracleStatementParser.HexadecimalLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBitValueLiterals(OracleStatementParser.BitValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBooleanLiterals(OracleStatementParser.BooleanLiteralsContext ctx) {
        return new BooleanLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNullValueLiterals(OracleStatementParser.NullValueLiteralsContext ctx) {
        return new NullLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(OracleStatementParser.IdentifierContext ctx) {
        OracleStatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null == unreservedWord ? new IdentifierValue(ctx.getText()) : (ASTNode)this.visit((ParseTree)unreservedWord);
    }

    @Override
    public final ASTNode visitUnreservedWord(OracleStatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(OracleStatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitSynonymName(OracleStatementParser.SynonymNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(OracleStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), new IdentifierValue(ctx.name().identifier().getText())));
        OracleStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(OracleStatementParser.ColumnNameContext ctx) {
        if (SequenceFunction.valueFrom((String)ctx.name().getText()).isPresent()) {
            return this.createSequenceFunction(ctx);
        }
        ColumnSegment result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        OracleStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        if (null != ctx.nestedItem() && !ctx.nestedItem().isEmpty()) {
            result.setNestedObjectAttributes(ctx.nestedItem().stream().map(item -> (IdentifierValue)this.visit((ParseTree)item.identifier())).collect(Collectors.toList()));
        }
        return result;
    }

    private FunctionSegment createSequenceFunction(OracleStatementParser.ColumnNameContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.name().getText(), this.getOriginalText(ctx));
        OracleStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitViewName(OracleStatementParser.ViewNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), new IdentifierValue(ctx.name().identifier().getText())));
        OracleStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitIndexName(OracleStatementParser.IndexNameContext ctx) {
        IndexNameSegment indexName = new IndexNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        return new IndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), indexName);
    }

    @Override
    public final ASTNode visitFunction(OracleStatementParser.FunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((IdentifierValue)this.visit((ParseTree)ctx.name())).getValue(), ctx.getText());
    }

    @Override
    public final ASTNode visitPackageName(OracleStatementParser.PackageNameContext ctx) {
        return new PackageSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
    }

    @Override
    public final ASTNode visitTypeName(OracleStatementParser.TypeNameContext ctx) {
        return new TypeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
    }

    @Override
    public final ASTNode visitIndexTypeName(OracleStatementParser.IndexTypeNameContext ctx) {
        return new IndexTypeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
    }

    @Override
    public final ASTNode visitConstraintName(OracleStatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitTableNames(OracleStatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(OracleStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitExpr(OracleStatementParser.ExprContext ctx) {
        if (null != ctx.booleanPrimary()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanPrimary());
        }
        if (null != ctx.LP_()) {
            return (ASTNode)this.visit((ParseTree)ctx.expr(0));
        }
        if (null != ctx.andOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.andOperator().getText());
        }
        if (null != ctx.orOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.orOperator().getText());
        }
        if (null != ctx.datetimeExpr()) {
            return this.createDatetimeExpression(ctx, ctx.datetimeExpr());
        }
        if (null != ctx.multisetExpr()) {
            return this.createMultisetExpression(ctx);
        }
        return new NotExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)), Boolean.valueOf(false));
    }

    private ASTNode createMultisetExpression(OracleStatementParser.ExprContext ctx) {
        ColumnSegment left = (ColumnSegment)this.visitColumnName(ctx.multisetExpr().columnName(0));
        ColumnSegment right = (ColumnSegment)this.visitColumnName(ctx.multisetExpr().columnName(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        String keyWord = null == ctx.multisetExpr().DISTINCT() ? "ALL" : "DISTINCT";
        return new MultisetExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)left, (ExpressionSegment)right, ctx.multisetExpr().multisetOperator().getText(), keyWord, text);
    }

    private ASTNode createDatetimeExpression(OracleStatementParser.ExprContext ctx, OracleStatementParser.DatetimeExprContext datetimeExpr) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.expr(0));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        if (null == datetimeExpr.expr()) {
            return new DatetimeExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, text);
        }
        ExpressionProjectionSegment right = new ExpressionProjectionSegment(datetimeExpr.getStart().getStartIndex(), datetimeExpr.getStop().getStopIndex(), datetimeExpr.getText(), (ExpressionSegment)this.visit((ParseTree)datetimeExpr.expr()));
        return new DatetimeExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, text);
    }

    private ASTNode createBinaryOperationExpression(OracleStatementParser.ExprContext ctx, String operator) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.expr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.expr(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitBooleanPrimary(OracleStatementParser.BooleanPrimaryContext ctx) {
        if (null != ctx.IS()) {
            String rightText = "";
            if (null != ctx.NOT()) {
                rightText = rightText + ctx.start.getInputStream().getText(new Interval(ctx.NOT().getSymbol().getStartIndex(), ctx.NOT().getSymbol().getStopIndex())) + " ";
            }
            Token operatorToken = null;
            if (null != ctx.NULL()) {
                operatorToken = ctx.NULL().getSymbol();
            }
            if (null != ctx.TRUE()) {
                operatorToken = ctx.TRUE().getSymbol();
            }
            if (null != ctx.FALSE()) {
                operatorToken = ctx.FALSE().getSymbol();
            }
            if (null != ctx.NAN()) {
                operatorToken = ctx.NAN().getSymbol();
            }
            int startIndex = null == operatorToken ? ctx.IS().getSymbol().getStopIndex() + 2 : operatorToken.getStartIndex();
            rightText = rightText + ctx.start.getInputStream().getText(new Interval(startIndex, ctx.stop.getStopIndex()));
            LiteralExpressionSegment right = new LiteralExpressionSegment(ctx.IS().getSymbol().getStopIndex() + 2, ctx.stop.getStopIndex(), (Object)rightText);
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
            String operator = "IS";
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
        }
        if (null != ctx.comparisonOperator() || null != ctx.SAFE_EQ_()) {
            return this.createCompareSegment(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.predicate());
    }

    private ASTNode createCompareSegment(OracleStatementParser.BooleanPrimaryContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
        Object right = null != ctx.predicate() ? (ExpressionSegment)this.visit((ParseTree)ctx.predicate()) : new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery())));
        String operator = null == ctx.SAFE_EQ_() ? ctx.comparisonOperator().getText() : ctx.SAFE_EQ_().getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitPredicate(OracleStatementParser.PredicateContext ctx) {
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.LIKE()) {
            return this.createBinaryOperationExpressionFromLike(ctx);
        }
        if (null != ctx.PRIOR()) {
            return null == ctx.predicate() ? new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx)) : (ASTNode)this.visit((ParseTree)ctx.predicate());
        }
        if (null == ctx.bitExpr(0)) {
            return new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx));
        }
        return (ASTNode)this.visit((ParseTree)ctx.bitExpr(0));
    }

    private InExpression createInSegment(OracleStatementParser.PredicateContext ctx) {
        LiteralExpressionSegment right;
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        if (null == ctx.subquery()) {
            if (null == ctx.LP_() || null == ctx.RP_()) {
                OracleStatementParser.StringLiteralsContext stringLiteralsContext = ctx.stringLiterals();
                right = new LiteralExpressionSegment(stringLiteralsContext.start.getStartIndex(), stringLiteralsContext.stop.getStopIndex(), (Object)((StringLiteralValue)this.visit((ParseTree)stringLiteralsContext)).getValue());
            } else {
                ListExpression listExpression = new ListExpression(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
                for (OracleStatementParser.ExprContext each : ctx.expr()) {
                    listExpression.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
                }
                right = listExpression;
            }
        } else {
            right = new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery())));
        }
        boolean not = null != ctx.NOT();
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, not);
    }

    private BinaryOperationExpression createBinaryOperationExpressionFromLike(OracleStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ListExpression right = new ListExpression(ctx.simpleExpr((int)0).start.getStartIndex(), ctx.simpleExpr().get((int)(ctx.simpleExpr().size() - 1)).stop.getStopIndex());
        for (OracleStatementParser.SimpleExprContext each : ctx.simpleExpr()) {
            right.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        String operator = null == ctx.NOT() ? "LIKE" : "NOT LIKE";
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
    }

    private BetweenExpression createBetweenSegment(OracleStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.predicate());
        boolean not = null != ctx.NOT();
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, not);
    }

    @Override
    public final ASTNode visitBitExpr(OracleStatementParser.BitExprContext ctx) {
        if (null != ctx.simpleExpr()) {
            return this.createExpressionSegment((ASTNode)this.visit((ParseTree)ctx.simpleExpr()), ctx);
        }
        ExpressionSegment left = (ExpressionSegment)this.visit(ctx.getChild(0));
        ExpressionSegment right = (ExpressionSegment)this.visit(ctx.getChild(2));
        String operator = ctx.getChild(1).getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private ASTNode createExpressionSegment(ASTNode astNode, ParserRuleContext context) {
        if (astNode instanceof StringLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((StringLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NumberLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((NumberLiteralValue)astNode).getValue());
        }
        if (astNode instanceof BooleanLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((BooleanLiteralValue)astNode).getValue());
        }
        if (astNode instanceof ParameterMarkerValue) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)astNode;
            ParameterMarkerExpressionSegment segment = new ParameterMarkerExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.globalParameterMarkerSegments.add((ParameterMarkerSegment)segment);
            this.statementParameterMarkerSegments.add((ParameterMarkerSegment)segment);
            return segment;
        }
        if (astNode instanceof SubquerySegment) {
            return new SubqueryExpressionSegment((SubquerySegment)astNode);
        }
        if (astNode instanceof OtherLiteralValue) {
            return new CommonExpressionSegment(context.getStart().getStartIndex(), context.getStop().getStopIndex(), context.getText());
        }
        return astNode;
    }

    @Override
    public final ASTNode visitSimpleExpr(OracleStatementParser.SimpleExprContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        int stopIndex = ctx.getStop().getStopIndex();
        if (null != ctx.subquery()) {
            return new SubquerySegment(startIndex, stopIndex, (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery()));
        }
        if (null != ctx.parameterMarker()) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker());
            ParameterMarkerExpressionSegment segment = new ParameterMarkerExpressionSegment(startIndex, stopIndex, parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.globalParameterMarkerSegments.add((ParameterMarkerSegment)segment);
            this.statementParameterMarkerSegments.add((ParameterMarkerSegment)segment);
            return segment;
        }
        if (null != ctx.literals()) {
            return SQLUtils.createLiteralExpression((ASTNode)((ASTNode)this.visit((ParseTree)ctx.literals())), (int)startIndex, (int)stopIndex, (String)ctx.literals().start.getInputStream().getText(new Interval(startIndex, stopIndex)));
        }
        if (null != ctx.functionCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.functionCall());
        }
        if (null != ctx.columnName()) {
            return null == ctx.joinOperator() ? (ASTNode)this.visit((ParseTree)ctx.columnName()) : new OuterJoinExpression(startIndex, stopIndex, (ColumnSegment)this.visitColumnName(ctx.columnName()), ctx.joinOperator().getText(), this.getOriginalText(ctx));
        }
        if (null != ctx.privateExprOfDb()) {
            return (ASTNode)this.visit((ParseTree)ctx.privateExprOfDb());
        }
        if (null != ctx.LP_()) {
            if (1 == ctx.expr().size()) {
                return (ASTNode)this.visit((ParseTree)ctx.expr(0));
            }
            ListExpression result = new ListExpression(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
            for (OracleStatementParser.ExprContext each : ctx.expr()) {
                result.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
            }
            return result;
        }
        return this.visitRemainSimpleExpr(ctx, startIndex, stopIndex);
    }

    private ASTNode visitRemainSimpleExpr(OracleStatementParser.SimpleExprContext ctx, int startIndex, int stopIndex) {
        if (null != ctx.OR_()) {
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(0));
            ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(1));
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, ctx.OR_().getText(), text);
        }
        if (null != ctx.caseExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.caseExpression());
        }
        if (null != ctx.BINARY()) {
            return (ASTNode)this.visit((ParseTree)ctx.simpleExpr(0));
        }
        for (OracleStatementParser.SimpleExprContext each : ctx.simpleExpr()) {
            this.visit((ParseTree)each);
        }
        return new CommonExpressionSegment(startIndex, stopIndex, ctx.getText());
    }

    @Override
    public ASTNode visitCaseExpression(OracleStatementParser.CaseExpressionContext ctx) {
        ExpressionSegment caseExpr = null == ctx.simpleExpr() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr());
        ArrayList<ExpressionSegment> whenExprs = new ArrayList<ExpressionSegment>(ctx.caseWhen().size());
        ArrayList<ExpressionSegment> thenExprs = new ArrayList<ExpressionSegment>(ctx.caseWhen().size());
        for (OracleStatementParser.CaseWhenContext each : ctx.caseWhen()) {
            whenExprs.add((ExpressionSegment)this.visit((ParseTree)each.expr(0)));
            thenExprs.add((ExpressionSegment)this.visit((ParseTree)each.expr(1)));
        }
        ExpressionSegment elseExpr = null == ctx.caseElse() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.caseElse().expr());
        return new CaseWhenExpression(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), caseExpr, whenExprs, thenExprs, elseExpr);
    }

    @Override
    public ASTNode visitPrivateExprOfDb(OracleStatementParser.PrivateExprOfDbContext ctx) {
        if (null != ctx.intervalExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.intervalExpression());
        }
        return (ASTNode)super.visitPrivateExprOfDb(ctx);
    }

    @Override
    public ASTNode visitIntervalExpression(OracleStatementParser.IntervalExpressionContext ctx) {
        IntervalExpressionProjection result = new IntervalExpressionProjection(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)), (ExpressionSegment)this.visit((ParseTree)ctx.MINUS_()), (ExpressionSegment)this.visit((ParseTree)ctx.expr(1)), this.getOriginalText(ctx));
        if (null != ctx.intervalDayToSecondExpression()) {
            result.setDayToSecondExpression((IntervalDayToSecondExpression)this.visit((ParseTree)ctx.intervalDayToSecondExpression()));
        } else {
            result.setYearToMonthExpression((IntervalYearToMonthExpression)this.visit((ParseTree)ctx.intervalYearToMonthExpression()));
        }
        return result;
    }

    @Override
    public ASTNode visitIntervalDayToSecondExpression(OracleStatementParser.IntervalDayToSecondExpressionContext ctx) {
        IntervalDayToSecondExpression result = new IntervalDayToSecondExpression(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.DAY().getText(), ctx.TO().getText(), ctx.SECOND().getText());
        if (null != ctx.leadingFieldPrecision()) {
            result.setLeadingFieldPrecision(Integer.valueOf(Integer.parseInt(ctx.leadingFieldPrecision().INTEGER_().getText())));
        }
        if (null != ctx.fractionalSecondPrecision()) {
            result.setFractionalSecondPrecision(Integer.valueOf(Integer.parseInt(ctx.fractionalSecondPrecision().getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitIntervalYearToMonthExpression(OracleStatementParser.IntervalYearToMonthExpressionContext ctx) {
        IntervalYearToMonthExpression result = new IntervalYearToMonthExpression(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.YEAR().getText(), ctx.TO().getText(), ctx.MONTH().getText());
        if (null != ctx.leadingFieldPrecision()) {
            result.setLeadingFieldPrecision(Integer.valueOf(Integer.parseInt(ctx.leadingFieldPrecision().INTEGER_().getText())));
        }
        return result;
    }

    @Override
    public final ASTNode visitFunctionCall(OracleStatementParser.FunctionCallContext ctx) {
        if (null != ctx.aggregationFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aggregationFunction());
        }
        if (null != ctx.specialFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialFunction());
        }
        if (null != ctx.analyticFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.analyticFunction());
        }
        if (null != ctx.regularFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.regularFunction());
        }
        if (null != ctx.xmlFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlFunction());
        }
        throw new IllegalStateException("FunctionCallContext must have aggregationFunction, regularFunction, analyticFunction or specialFunction.");
    }

    @Override
    public ASTNode visitAnalyticFunction(OracleStatementParser.AnalyticFunctionContext ctx) {
        String functionName = null == ctx.analyticFunctionName() ? ctx.specifiedAnalyticFunctionName.getText() : ctx.analyticFunctionName().getText();
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), functionName, this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        for (OracleStatementParser.DataTypeContext each : ctx.dataType()) {
            result.getParameters().add((DataTypeSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitAggregationFunction(OracleStatementParser.AggregationFunctionContext ctx) {
        String aggregationType = ctx.aggregationFunctionName().getText();
        return AggregationType.isAggregationType((String)aggregationType) ? this.createAggregationSegment(ctx, aggregationType) : this.createAggregationFunctionSegment(ctx, aggregationType);
    }

    @Override
    public ASTNode visitWmConcatFunction(OracleStatementParser.WmConcatFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.WM_CONCAT().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        if (null != ctx.owner()) {
            OracleStatementParser.OwnerContext owner = ctx.owner();
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    private FunctionSegment createAggregationFunctionSegment(OracleStatementParser.AggregationFunctionContext ctx, String aggregationType) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), aggregationType, this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        return result;
    }

    private ASTNode createAggregationSegment(OracleStatementParser.AggregationFunctionContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        if (null != ctx.DISTINCT()) {
            AggregationDistinctProjectionSegment result = new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx), this.getDistinctExpression(ctx));
            result.getParameters().addAll(this.getExpressions(ctx.expr()));
            return result;
        }
        AggregationProjectionSegment result = new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitXmlFunction(OracleStatementParser.XmlFunctionContext ctx) {
        if (null != ctx.xmlAggFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlAggFunction());
        }
        if (null != ctx.xmlColattvalFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlColattvalFunction());
        }
        if (null != ctx.xmlExistsFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlExistsFunction());
        }
        if (null != ctx.xmlForestFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlForestFunction());
        }
        if (null != ctx.xmlParseFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlParseFunction());
        }
        if (null != ctx.xmlPiFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlPiFunction());
        }
        if (null != ctx.xmlQueryFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlQueryFunction());
        }
        if (null != ctx.xmlRootFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlRootFunction());
        }
        if (null != ctx.xmlSerializeFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlSerializeFunction());
        }
        if (null != ctx.xmlIsSchemaValidFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlIsSchemaValidFunction());
        }
        if (null != ctx.xmlTableFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlTableFunction());
        }
        if (null != ctx.xmlElementFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlElementFunction());
        }
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.specifiedFunctionName.getText(), this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.exprList()));
        return result;
    }

    @Override
    public ASTNode visitXmlElementFunction(OracleStatementParser.XmlElementFunctionContext ctx) {
        XmlElementFunctionSegment result = new XmlElementFunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLELEMENT().getText(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.exprWithAlias().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each.expr())).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        if (null != ctx.xmlAttributes()) {
            Collection xmlAttributes = ctx.xmlAttributes().exprWithAlias().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each.expr())).collect(Collectors.toList());
            result.getXmlAttributes().addAll(xmlAttributes);
        }
        return result;
    }

    @Override
    public ASTNode visitXmlCdataFunction(OracleStatementParser.XmlCdataFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLCDATA().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.stringLiterals()));
        return result;
    }

    @Override
    public ASTNode visitXmlAggFunction(OracleStatementParser.XmlAggFunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.XMLAGG().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitXmlColattvalFunction(OracleStatementParser.XmlColattvalFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLCOLATTVAL().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitXmlExistsFunction(OracleStatementParser.XmlExistsFunctionContext ctx) {
        XmlQueryAndExistsFunctionSegment result = new XmlQueryAndExistsFunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLEXISTS().getText(), ctx.STRING_().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.xmlPassingClause().expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitXmlForestFunction(OracleStatementParser.XmlForestFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLFOREST().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitXmlParseFunction(OracleStatementParser.XmlParseFunctionContext ctx) {
        return new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx), (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public ASTNode visitXmlPiFunction(OracleStatementParser.XmlPiFunctionContext ctx) {
        if (null != ctx.identifier()) {
            return new XmlPiFunctionSegment(ctx.start.getStopIndex(), ctx.stop.getStopIndex(), ctx.XMLPI().getText(), ctx.identifier().getText(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)), this.getOriginalText(ctx));
        }
        return new XmlPiFunctionSegment(ctx.start.getStopIndex(), ctx.stop.getStopIndex(), ctx.XMLPI().getText(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)), (ExpressionSegment)this.visit((ParseTree)ctx.expr(1)), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitXmlQueryFunction(OracleStatementParser.XmlQueryFunctionContext ctx) {
        XmlQueryAndExistsFunctionSegment result = new XmlQueryAndExistsFunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLQUERY().getText(), ctx.STRING_().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.xmlPassingClause().expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitXmlRootFunction(OracleStatementParser.XmlRootFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLROOT().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitXmlSerializeFunction(OracleStatementParser.XmlSerializeFunctionContext ctx) {
        String dataType = null == ctx.dataType() ? null : ctx.dataType().getText();
        String encoding = null == ctx.STRING_() ? null : ctx.STRING_().getText();
        String version = null == ctx.stringLiterals() ? null : ctx.stringLiterals().getText();
        String identSize = null == ctx.INTEGER_() ? null : ctx.INTEGER_().getText();
        return new XmlSerializeFunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLSERIALIZE().getText(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()), dataType, encoding, version, identSize, this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitXmlTableFunction(OracleStatementParser.XmlTableFunctionContext ctx) {
        XmlNamespacesClauseSegment xmlNamespacesClause = null == ctx.xmlNamespacesClause() ? null : (XmlNamespacesClauseSegment)this.visit((ParseTree)ctx.xmlNamespacesClause());
        return new XmlTableFunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.XMLTABLE().getText(), xmlNamespacesClause, ctx.STRING_().getText(), (XmlTableOptionsSegment)this.visit((ParseTree)ctx.xmlTableOptions()), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitXmlNamespacesClause(OracleStatementParser.XmlNamespacesClauseContext ctx) {
        String defaultString = null == ctx.defaultString() ? null : ctx.defaultString(0).STRING_().getText();
        List xmlNamespaceStringAsIdentifierSegments = null == ctx.xmlNamespaceStringAsIdentifier() ? Collections.emptyList() : (Collection)ctx.xmlNamespaceStringAsIdentifier().stream().map(each -> (XmlNamespaceStringAsIdentifierSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        XmlNamespacesClauseSegment result = new XmlNamespacesClauseSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), defaultString, this.getOriginalText(ctx));
        result.getStringAsIdentifier().addAll(xmlNamespaceStringAsIdentifierSegments);
        return result;
    }

    @Override
    public ASTNode visitXmlNamespaceStringAsIdentifier(OracleStatementParser.XmlNamespaceStringAsIdentifierContext ctx) {
        return new XmlNamespaceStringAsIdentifierSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.STRING_().getText(), ctx.identifier().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitXmlTableOptions(OracleStatementParser.XmlTableOptionsContext ctx) {
        XmlTableOptionsSegment result = new XmlTableOptionsSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx));
        List expressionSegments = null == ctx.xmlPassingClause().expr() ? Collections.emptyList() : (Collection)ctx.xmlPassingClause().expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        List xmlTableColumnSegments = null == ctx.xmlTableColumn() ? Collections.emptyList() : (Collection)ctx.xmlTableColumn().stream().map(each -> (XmlTableColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        result.getXmlTableColumnSegments().addAll(xmlTableColumnSegments);
        return result;
    }

    @Override
    public ASTNode visitXmlTableColumn(OracleStatementParser.XmlTableColumnContext ctx) {
        String dataType = null == ctx.dataType() ? null : ctx.dataType().getText();
        String path = null == ctx.STRING_() ? null : ctx.STRING_().getText();
        ExpressionSegment defaultExpr = null == ctx.expr() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new XmlTableColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.columnName().getText(), dataType, path, defaultExpr, this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitXmlIsSchemaValidFunction(OracleStatementParser.XmlIsSchemaValidFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.ISSCHEMAVALID().getText(), this.getOriginalText(ctx));
        if (null != ctx.expr()) {
            for (OracleStatementParser.ExprContext each : ctx.expr()) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return result;
    }

    private Collection<ExpressionSegment> getExpressions(OracleStatementParser.ExprListContext exprList) {
        if (null == exprList) {
            return Collections.emptyList();
        }
        return this.getExpressions(exprList.exprs().expr());
    }

    private Collection<ExpressionSegment> getExpressions(List<OracleStatementParser.ExprContext> exprList) {
        if (null == exprList) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(exprList.size());
        for (OracleStatementParser.ExprContext each : exprList) {
            result.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private String getDistinctExpression(OracleStatementParser.AggregationFunctionContext ctx) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < ctx.getChildCount() - 1; ++i) {
            result.append(ctx.getChild(i).getText());
        }
        return result.toString();
    }

    @Override
    public final ASTNode visitSpecialFunction(OracleStatementParser.SpecialFunctionContext ctx) {
        if (null != ctx.castFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.castFunction());
        }
        if (null != ctx.charFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.charFunction());
        }
        if (null != ctx.extractFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.extractFunction());
        }
        if (null != ctx.formatFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.formatFunction());
        }
        if (null != ctx.firstOrLastValueFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.firstOrLastValueFunction());
        }
        if (null != ctx.trimFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.trimFunction());
        }
        if (null != ctx.featureFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.featureFunction());
        }
        if (null != ctx.setFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.setFunction());
        }
        if (null != ctx.translateFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.translateFunction());
        }
        if (null != ctx.cursorFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.cursorFunction());
        }
        if (null != ctx.toDateFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.toDateFunction());
        }
        if (null != ctx.approxRank()) {
            return (ASTNode)this.visit((ParseTree)ctx.approxRank());
        }
        if (null != ctx.wmConcatFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.wmConcatFunction());
        }
        if (null != ctx.predictionCostFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.predictionCostFunction());
        }
        if (null != ctx.jsonObjectFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.jsonObjectFunction());
        }
        throw new IllegalStateException("SpecialFunctionContext must have castFunction, charFunction, extractFunction, formatFunction, firstOrLastValueFunction, trimFunction, toDateFunction, approxCount, predictionCostFunction, jsonObjectFunction or featureFunction.");
    }

    @Override
    public ASTNode visitJsonObjectFunction(OracleStatementParser.JsonObjectFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.JSON_OBJECT().getText(), this.getOriginalText(ctx));
        for (OracleStatementParser.JsonObjectKeyValueContext each : ctx.jsonObjectContent().jsonObjectKeyValue()) {
            result.getParameters().addAll(this.getExpressions(each.expr()));
        }
        return result;
    }

    @Override
    public ASTNode visitPredictionCostFunction(OracleStatementParser.PredictionCostFunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.PREDICTION_COST().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitApproxRank(OracleStatementParser.ApproxRankContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.APPROX_RANK().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitCursorFunction(OracleStatementParser.CursorFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CURSOR().toString(), ctx.getText());
        result.getParameters().add(new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery()))));
        return result;
    }

    @Override
    public ASTNode visitToDateFunction(OracleStatementParser.ToDateFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TO_DATE().getText(), this.getOriginalText(ctx));
        if (null != ctx.STRING_()) {
            ctx.STRING_().forEach(each -> result.getParameters().add(new LiteralExpressionSegment(each.getSymbol().getStartIndex(), each.getSymbol().getStopIndex(), (Object)each.getSymbol().getText())));
        }
        return result;
    }

    @Override
    public final ASTNode visitTranslateFunction(OracleStatementParser.TranslateFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TRANSLATE().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        TerminalNode charSet = null == ctx.NCHAR_CS() ? ctx.CHAR_CS() : ctx.NCHAR_CS();
        result.getParameters().add(new LiteralExpressionSegment(charSet.getSymbol().getStartIndex(), charSet.getSymbol().getStopIndex(), (Object)charSet.getText()));
        return result;
    }

    @Override
    public final ASTNode visitSetFunction(OracleStatementParser.SetFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.SET().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public final ASTNode visitCastFunction(OracleStatementParser.CastFunctionContext ctx) {
        FunctionSegment result = null != ctx.CAST() ? new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CAST().getText(), this.getOriginalText(ctx)) : new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.XMLCAST().getText(), this.getOriginalText(ctx));
        if (null != ctx.MULTISET()) {
            result.getParameters().add(new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery()))));
        } else {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        }
        result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
        return result;
    }

    @Override
    public final ASTNode visitCharFunction(OracleStatementParser.CharFunctionContext ctx) {
        FunctionSegment result = null != ctx.CHR() ? new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CHR().getText(), this.getOriginalText(ctx)) : new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CHAR().getText(), this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitExtractFunction(OracleStatementParser.ExtractFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.EXTRACT().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitFormatFunction(OracleStatementParser.FormatFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.FORMAT().getText(), this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitFirstOrLastValueFunction(OracleStatementParser.FirstOrLastValueFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), null == ctx.FIRST_VALUE() ? ctx.LAST_VALUE().getText() : ctx.FIRST_VALUE().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitTrimFunction(OracleStatementParser.TrimFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TRIM().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitFeatureFunction(OracleStatementParser.FeatureFunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.featureFunctionName().getText(), this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitRegularFunction(OracleStatementParser.RegularFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.regularFunctionName().getText(), this.getOriginalText(ctx));
        if (null != ctx.owner()) {
            OracleStatementParser.OwnerContext owner = ctx.owner();
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        return result;
    }

    @Override
    public final ASTNode visitDataTypeName(OracleStatementParser.DataTypeNameContext ctx) {
        LinkedList<String> dataTypeNames = new LinkedList<String>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            dataTypeNames.add(ctx.getChild(i).getText());
        }
        return new KeywordValue(String.join((CharSequence)" ", dataTypeNames));
    }

    @Override
    public final ASTNode visitOrderByClause(OracleStatementParser.OrderByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (OracleStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public final ASTNode visitOrderByItem(OracleStatementParser.OrderByItemContext ctx) {
        OrderDirection orderDirection = null == ctx.DESC() ? OrderDirection.ASC : OrderDirection.DESC;
        NullsOrderType nullsOrderType = this.generateNullsOrderType(ctx);
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            return new ColumnOrderByItemSegment(column, orderDirection, nullsOrderType);
        }
        if (null != ctx.numberLiterals()) {
            return new IndexOrderByItemSegment(ctx.numberLiterals().getStart().getStartIndex(), ctx.numberLiterals().getStop().getStopIndex(), SQLUtils.getExactlyNumber((String)ctx.numberLiterals().getText(), (int)10).intValue(), orderDirection, nullsOrderType);
        }
        return new ExpressionOrderByItemSegment(ctx.expr().getStart().getStartIndex(), ctx.expr().getStop().getStopIndex(), this.getOriginalText(ctx.expr()), orderDirection, nullsOrderType, (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
    }

    private NullsOrderType generateNullsOrderType(OracleStatementParser.OrderByItemContext ctx) {
        if (null == ctx.FIRST() && null == ctx.LAST()) {
            return null;
        }
        return null == ctx.FIRST() ? NullsOrderType.LAST : NullsOrderType.FIRST;
    }

    @Override
    public final ASTNode visitDataType(OracleStatementParser.DataTypeContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        if (null != ctx.dataTypeName()) {
            result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        }
        if (null != ctx.specialDatatype()) {
            result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.specialDatatype().dataTypeName())).getValue());
        }
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            DataTypeLengthSegment dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitDataTypeLength(OracleStatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.INTEGER_();
        if (1 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (2 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            result.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        if (null != ctx.type) {
            result.setType(ctx.type.getText());
        }
        return result;
    }

    protected String getOriginalText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    protected Collection<ParameterMarkerSegment> popAllStatementParameterMarkerSegments() {
        LinkedList<ParameterMarkerSegment> result = new LinkedList<ParameterMarkerSegment>(this.statementParameterMarkerSegments);
        this.statementParameterMarkerSegments.clear();
        return result;
    }

    protected void increaseCursorForLoopLevel() {
        ++this.cursorForLoopLevel;
    }

    protected void decreaseCursorForLoopLevel() {
        --this.cursorForLoopLevel;
    }

    @Generated
    public OracleStatementVisitor(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public Collection<ParameterMarkerSegment> getGlobalParameterMarkerSegments() {
        return this.globalParameterMarkerSegments;
    }

    @Generated
    public Collection<ParameterMarkerSegment> getStatementParameterMarkerSegments() {
        return this.statementParameterMarkerSegments;
    }

    @Generated
    public List<SQLStatementSegment> getSqlStatementsInPlsql() {
        return this.sqlStatementsInPlsql;
    }

    @Generated
    public List<ProcedureCallNameSegment> getProcedureCallNames() {
        return this.procedureCallNames;
    }

    @Generated
    public List<ProcedureBodyEndNameSegment> getProcedureBodyEndNameSegments() {
        return this.procedureBodyEndNameSegments;
    }

    @Generated
    public List<ExpressionSegment> getDynamicSqlStatementExpressions() {
        return this.dynamicSqlStatementExpressions;
    }

    @Generated
    public Collection<String> getVariableNames() {
        return this.variableNames;
    }

    @Generated
    public Map<String, SQLStatement> getCursorStatements() {
        return this.cursorStatements;
    }

    @Generated
    public List<CursorForLoopStatementSegment> getCursorForLoopStatementSegments() {
        return this.cursorForLoopStatementSegments;
    }

    @Generated
    public Map<Integer, Set<SQLStatement>> getTempCursorForLoopStatements() {
        return this.tempCursorForLoopStatements;
    }

    @Generated
    public int getCursorForLoopLevel() {
        return this.cursorForLoopLevel;
    }

    private static final class ParameterMarkerScanState {
        private int index;
        private int result;
        private boolean inStringLiteral;
        private boolean inLineComment;
        private boolean inBlockComment;

        private ParameterMarkerScanState() {
        }
    }
}

