/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.route.engine;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.route.engine.type.BroadcastRouteEngine;
import org.apache.shardingsphere.broadcast.route.engine.type.broadcast.BroadcastDatabaseBroadcastRouteEngine;
import org.apache.shardingsphere.broadcast.route.engine.type.broadcast.BroadcastTableBroadcastRouteEngine;
import org.apache.shardingsphere.broadcast.route.engine.type.unicast.BroadcastUnicastRouteEngine;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class BroadcastRouteEngineFactory {
    public static BroadcastRouteEngine newInstance(QueryContext queryContext, Collection<String> broadcastTableNames) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof DDLStatement) {
            return BroadcastRouteEngineFactory.getDDLRouteEngine(queryContext, broadcastTableNames, sqlStatementContext);
        }
        if (sqlStatement instanceof DALStatement) {
            return BroadcastRouteEngineFactory.getDALRouteEngine(broadcastTableNames);
        }
        if (sqlStatement instanceof DCLStatement) {
            return BroadcastRouteEngineFactory.getDCLRouteEngine(broadcastTableNames);
        }
        return BroadcastRouteEngineFactory.getDMLRouteEngine(sqlStatementContext, queryContext.getConnectionContext(), broadcastTableNames);
    }

    private static BroadcastRouteEngine getDDLRouteEngine(QueryContext queryContext, Collection<String> broadcastTableNames, SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement().getAttributes().findAttribute(CursorSQLStatementAttribute.class).isPresent() ? new BroadcastUnicastRouteEngine(sqlStatementContext, broadcastTableNames, queryContext.getConnectionContext()) : new BroadcastTableBroadcastRouteEngine(broadcastTableNames);
    }

    private static BroadcastRouteEngine getDALRouteEngine(Collection<String> broadcastTableNames) {
        return new BroadcastTableBroadcastRouteEngine(broadcastTableNames);
    }

    private static BroadcastRouteEngine getDCLRouteEngine(Collection<String> broadcastTableNames) {
        return new BroadcastTableBroadcastRouteEngine(broadcastTableNames);
    }

    private static BroadcastRouteEngine getDMLRouteEngine(SQLStatementContext sqlStatementContext, ConnectionContext connectionContext, Collection<String> broadcastTableNames) {
        return sqlStatementContext.getSqlStatement() instanceof SelectStatement ? new BroadcastUnicastRouteEngine(sqlStatementContext, broadcastTableNames, connectionContext) : new BroadcastDatabaseBroadcastRouteEngine();
    }

    @Generated
    private BroadcastRouteEngineFactory() {
    }
}

