/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLock;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockReleaseStrategy;

public final class ProcessOperationLockRegistry {
    private static final ProcessOperationLockRegistry INSTANCE = new ProcessOperationLockRegistry();
    private final Map<String, ProcessOperationLock> locks = new ConcurrentHashMap<String, ProcessOperationLock>();

    public static ProcessOperationLockRegistry getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilReleaseReady(String processId, int latchCount, ProcessOperationLockReleaseStrategy releaseStrategy) {
        ProcessOperationLock lock = new ProcessOperationLock(latchCount);
        this.locks.put(processId, lock);
        try {
            boolean bl = lock.awaitDefaultTime(releaseStrategy);
            return bl;
        }
        finally {
            this.locks.remove(processId);
        }
    }

    public void notify(String processId) {
        ProcessOperationLock lock = this.locks.get(processId);
        if (null != lock) {
            lock.doNotify();
        }
    }

    @Generated
    private ProcessOperationLockRegistry() {
    }
}

