/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class RawSQLExecutorCallback
implements ExecutorCallback<RawSQLExecutionUnit, ExecuteResult> {
    private final Collection<RawExecutorCallback> callbacks;
    private final ProcessEngine processEngine = new ProcessEngine();

    public RawSQLExecutorCallback() {
        this.callbacks = ShardingSphereServiceLoader.getServiceInstances(RawExecutorCallback.class);
        Preconditions.checkState((!this.callbacks.isEmpty() ? 1 : 0) != 0, (Object)"No raw executor callback implementation found.");
    }

    @Override
    public Collection<ExecuteResult> execute(Collection<RawSQLExecutionUnit> inputs, boolean isTrunkThread, String processId) {
        Collection<ExecuteResult> result = this.callbacks.iterator().next().execute(inputs, isTrunkThread);
        for (RawSQLExecutionUnit each : inputs) {
            this.processEngine.completeSQLUnitExecution(each, processId);
        }
        return result;
    }
}

