/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;

public final class JDBCExecutor {
    private final ExecutorEngine executorEngine;
    private final ConnectionContext connectionContext;

    public <T> List<T> execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, JDBCExecutorCallback<T> callback) throws SQLException {
        return this.execute(executionGroupContext, null, callback);
    }

    public <T> List<T> execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, JDBCExecutorCallback<T> firstCallback, JDBCExecutorCallback<T> callback) throws SQLException {
        try {
            return this.executorEngine.execute(executionGroupContext, firstCallback, callback, this.connectionContext.getTransactionContext().isDistributedTransactionStarted());
        }
        catch (SQLException ex) {
            SQLExecutorExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Generated
    public JDBCExecutor(ExecutorEngine executorEngine, ConnectionContext connectionContext) {
        this.executorEngine = executorEngine;
        this.connectionContext = connectionContext;
    }
}

