/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.keygen.DialectGeneratedKeyOption;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.SQLExceptionTransformEngine;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteUpdateCallback;
import org.apache.shardingsphere.driver.executor.engine.batch.statement.BatchStatementExecutor;
import org.apache.shardingsphere.driver.executor.engine.facade.DriverExecutorFacade;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.statement.GeneratedValueUtils;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.EmptySQLException;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ShardingSphereStatement
extends AbstractStatementAdapter {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final StatementOption statementOption;
    private final StatementManager statementManager;
    private final DriverExecutorFacade driverExecutorFacade;
    private final BatchStatementExecutor batchStatementExecutor;
    private final List<Statement> statements;
    private String usedDatabaseName;
    private QueryContext queryContext;
    private boolean returnGeneratedKeys;
    private ResultSet currentResultSet;

    public ShardingSphereStatement(ShardingSphereConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.metaData = connection.getContextManager().getMetaDataContexts().getMetaData();
        this.statementOption = new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statementManager = new StatementManager();
        connection.getStatementManagers().add(this.statementManager);
        this.driverExecutorFacade = new DriverExecutorFacade(connection, this.statementOption, this.statementManager, JDBCDriverType.STATEMENT, this.metaData.getDatabase(connection.getCurrentDatabaseName()));
        this.batchStatementExecutor = new BatchStatementExecutor(this);
        this.statements = new LinkedList<Statement>();
        this.usedDatabaseName = connection.getCurrentDatabaseName();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        QueryContext queryContext = this.createQueryContext(sql);
        try {
            this.prepareExecute(queryContext);
            ShardingSphereDatabase usedDatabase = this.metaData.getDatabase(this.usedDatabaseName);
            this.currentResultSet = this.driverExecutorFacade.executeQuery(usedDatabase, this.metaData, queryContext, this, null, (statements, parameterSets) -> this.statements.addAll(statements), this::replay);
            return this.currentResultSet;
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            this.currentResultSet = null;
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return this.executeUpdate(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL));
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.currentResultSet = null;
            this.returnGeneratedKeys = true;
        }
        try {
            return this.executeUpdate(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL, autoGeneratedKeys));
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            return this.executeUpdate(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnIndexes));
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            return this.executeUpdate(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnNames));
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    private int executeUpdate(String sql, StatementExecuteUpdateCallback updateCallback) throws SQLException {
        this.currentResultSet = null;
        QueryContext queryContext = this.createQueryContext(sql);
        this.prepareExecute(queryContext);
        ShardingSphereDatabase usedDatabase = this.metaData.getDatabase(this.usedDatabaseName);
        return this.driverExecutorFacade.executeUpdate(usedDatabase, this.metaData, queryContext, updateCallback, (statements, parameterSets) -> this.statements.addAll(statements), this::replay);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.execute(sql, (actualSQL, statement) -> statement.execute(actualSQL));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (1 == autoGeneratedKeys) {
                this.returnGeneratedKeys = true;
            }
            return this.execute(sql, (actualSQL, statement) -> statement.execute(actualSQL, autoGeneratedKeys));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.returnGeneratedKeys = true;
            return this.execute(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnIndexes));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this.returnGeneratedKeys = true;
            return this.execute(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnNames));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaData.getDatabase(this.usedDatabaseName).getProtocolType());
        }
    }

    private boolean execute(String sql, StatementExecuteCallback statementExecuteCallback) throws SQLException {
        this.currentResultSet = null;
        QueryContext queryContext = this.createQueryContext(sql);
        this.prepareExecute(queryContext);
        ShardingSphereDatabase usedDatabase = this.metaData.getDatabase(this.usedDatabaseName);
        return this.driverExecutorFacade.execute(usedDatabase, this.metaData, queryContext, statementExecuteCallback, (statements, parameterSets) -> this.statements.addAll(statements), this::replay);
    }

    private QueryContext createQueryContext(String originSQL) throws SQLException {
        ShardingSpherePreconditions.checkNotEmpty((String)originSQL, () -> new EmptySQLException().toSQLException());
        HintValueContext hintValueContext = SQLHintUtils.extractHint((String)originSQL);
        String sql = SQLHintUtils.removeHint((String)originSQL);
        ShardingSphereDatabase currentDatabase = this.metaData.getDatabase(this.usedDatabaseName);
        DatabaseType databaseType = currentDatabase.getProtocolType();
        SQLStatement sqlStatement = ((SQLParserRule)this.metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(databaseType).parse(sql, false);
        SQLStatementContext sqlStatementContext = new SQLBindEngine(this.metaData, this.connection.getCurrentDatabaseName(), hintValueContext).bind(sqlStatement);
        return new QueryContext(sqlStatementContext, sql, Collections.emptyList(), hintValueContext, this.connection.getDatabaseConnectionManager().getConnectionContext(), this.metaData);
    }

    private void prepareExecute(QueryContext queryContext) throws SQLException {
        this.handleAutoCommitBeforeExecution(queryContext.getSqlStatementContext().getSqlStatement(), this.connection);
        this.queryContext = queryContext;
        ShardingSpherePreconditions.checkNotNull((Object)this.queryContext, () -> new IllegalStateException("Query context can not be null"));
        this.usedDatabaseName = queryContext.getSqlStatementContext().getTablesContext().getDatabaseName().orElse(this.connection.getCurrentDatabaseName());
        this.connection.getDatabaseConnectionManager().getConnectionContext().setCurrentDatabaseName(this.connection.getCurrentDatabaseName());
        this.clearStatements();
    }

    private void clearStatements() throws SQLException {
        for (Statement each : this.statements) {
            each.close();
        }
        this.statements.clear();
    }

    private void replay() throws SQLException {
        for (Statement each : this.statements) {
            this.getMethodInvocationRecorder().replay(each);
        }
    }

    @Override
    public void addBatch(String sql) {
        this.batchStatementExecutor.addBatch(sql);
    }

    @Override
    public void clearBatch() {
        this.batchStatementExecutor.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.batchStatementExecutor.executeBatch();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        this.driverExecutorFacade.getResultSet(this.metaData.getDatabase(this.usedDatabaseName), this.queryContext, this, this.statements).ifPresent(optional -> {
            this.currentResultSet = optional;
        });
        return this.currentResultSet;
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        for (DataNodeRuleAttribute each : this.metaData.getDatabase(this.usedDatabaseName).getRuleMetaData().getAttributes(DataNodeRuleAttribute.class)) {
            if (!each.isNeedAccumulate(this.queryContext.getSqlStatementContext().getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent() && !generatedKey.get().getGeneratedValues().isEmpty()) {
            return new GeneratedKeysResultSet(this.getGeneratedKeysColumnName(generatedKey.get().getColumnName()), generatedKey.get().getGeneratedValues().iterator(), this);
        }
        String columnName = generatedKey.map(GeneratedKeyContext::getColumnName).orElse(null);
        String generatedKeysColumnName = this.getGeneratedKeysColumnName(columnName);
        LinkedList generatedValues = new LinkedList();
        for (Statement each : this.statements) {
            ResultSet resultSet = each.getGeneratedKeys();
            while (resultSet.next()) {
                generatedValues.add(GeneratedValueUtils.getGeneratedValue(resultSet, generatedKeysColumnName, columnName));
            }
        }
        return new GeneratedKeysResultSet(generatedKeysColumnName, generatedValues.iterator(), this);
    }

    private Optional<GeneratedKeyContext> findGeneratedKey() {
        SQLStatementContext sqlStatementContext = this.queryContext.getSqlStatementContext();
        return sqlStatementContext instanceof InsertStatementContext ? ((InsertStatementContext)sqlStatementContext).getGeneratedKeyContext() : Optional.empty();
    }

    private String getGeneratedKeysColumnName(String columnName) {
        Optional generatedKeyOption = new DatabaseTypeRegistry(this.metaData.getDatabase(this.usedDatabaseName).getProtocolType()).getDialectDatabaseMetaData().getGeneratedKeyOption();
        return generatedKeyOption.isPresent() ? ((DialectGeneratedKeyOption)generatedKeyOption.get()).getColumnName() : columnName;
    }

    @Override
    protected void closeExecutor() throws SQLException {
        this.driverExecutorFacade.close();
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    protected StatementManager getStatementManager() {
        return this.statementManager;
    }
}

