/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.WrapperAdapter;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.kernel.syntax.ColumnIndexOutOfRangeException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;

public final class ShardingSphereResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final ResultSetMetaData resultSetMetaData;
    private final ShardingSphereDatabase database;
    private final SQLStatementContext sqlStatementContext;

    @Override
    public int getColumnCount() throws SQLException {
        return this.sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)this.sqlStatementContext).containsDerivedProjections() ? ((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections().size() : this.resultSetMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.resultSetMetaData.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.resultSetMetaData.isCaseSensitive(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.resultSetMetaData.isSearchable(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.resultSetMetaData.isCurrency(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.resultSetMetaData.isNullable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.resultSetMetaData.isSigned(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.resultSetMetaData.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (this.sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)this.sqlStatementContext).containsDerivedProjections()) {
            this.checkColumnIndex(column);
            return ((Projection)((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections().get(column - 1)).getColumnLabel();
        }
        return this.resultSetMetaData.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)this.sqlStatementContext).containsDerivedProjections()) {
            this.checkColumnIndex(column);
            return ((Projection)((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections().get(column - 1)).getColumnName();
        }
        return this.resultSetMetaData.getColumnName(column);
    }

    private void checkColumnIndex(int column) throws SQLException {
        List actualProjections = ((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections();
        if (column > actualProjections.size()) {
            throw new ColumnIndexOutOfRangeException(column).toSQLException();
        }
    }

    @Override
    public String getSchemaName(int column) {
        return "logic_db";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.resultSetMetaData.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.resultSetMetaData.getScale(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.decorateTableName(this.database.getRuleMetaData().getAttributes(DataNodeRuleAttribute.class), this.resultSetMetaData.getTableName(column));
    }

    private String decorateTableName(Collection<DataNodeRuleAttribute> ruleAttributes, String actualTableName) {
        for (DataNodeRuleAttribute each : ruleAttributes) {
            if (!each.findLogicTableByActualTable(actualTableName).isPresent()) continue;
            return (String)each.findLogicTableByActualTable(actualTableName).get();
        }
        return actualTableName;
    }

    @Override
    public String getCatalogName(int column) {
        return "logic_db";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.resultSetMetaData.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.resultSetMetaData.isReadOnly(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.resultSetMetaData.isWritable(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.resultSetMetaData.isDefinitelyWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnClassName(column);
    }

    @Generated
    public ShardingSphereResultSetMetaData(ResultSetMetaData resultSetMetaData, ShardingSphereDatabase database, SQLStatementContext sqlStatementContext) {
        this.resultSetMetaData = resultSetMetaData;
        this.database = database;
        this.sqlStatementContext = sqlStatementContext;
    }
}

