/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSetUtils;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class ShardingSphereResultSetFactory {
    private final ConnectionContext connectionContext;
    private final ShardingSphereMetaData metaData;
    private final ConfigurationProperties props;
    private final Collection<Statement> statements;

    public ResultSet newInstance(ShardingSphereDatabase database, QueryContext queryContext, List<QueryResult> queryResults, Statement statement, Map<String, Integer> columnLabelAndIndexMap) throws SQLException {
        List<ResultSet> resultSets = this.getResultSets(queryResults);
        MergedResult mergedResult = new MergeEngine(this.metaData, database, this.props, this.connectionContext).merge(queryResults, queryContext);
        return new ShardingSphereResultSet(resultSets, mergedResult, statement, queryContext.getSqlStatementContext(), null == columnLabelAndIndexMap ? ShardingSphereResultSetUtils.createColumnLabelAndIndexMap(queryContext.getSqlStatementContext(), resultSets.get(0).getMetaData()) : columnLabelAndIndexMap);
    }

    private List<ResultSet> getResultSets(Collection<QueryResult> queryResults) throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (QueryResult queryResult : queryResults) {
            Optional jdbcResultSet = queryResult.getJDBCResultSet();
            jdbcResultSet.ifPresent(result::add);
        }
        if (!result.isEmpty()) {
            return result;
        }
        for (Statement statement : this.statements) {
            ResultSet resultSet = statement.getResultSet();
            if (null == resultSet) continue;
            result.add(resultSet);
        }
        return result;
    }

    @Generated
    public ShardingSphereResultSetFactory(ConnectionContext connectionContext, ShardingSphereMetaData metaData, ConfigurationProperties props, Collection<Statement> statements) {
        this.connectionContext = connectionContext;
        this.metaData = metaData;
        this.props = props;
        this.statements = statements;
    }
}

