/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.driver;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.url.core.ShardingSphereURL;
import org.apache.shardingsphere.infra.url.core.arg.URLArgumentLineRender;
import org.apache.shardingsphere.infra.url.core.arg.URLArgumentPlaceholderType;
import org.apache.shardingsphere.infra.url.core.arg.URLArgumentPlaceholderTypeFactory;
import org.apache.shardingsphere.infra.url.spi.ShardingSphereLocalFileURLLoader;
import org.apache.shardingsphere.infra.url.spi.ShardingSphereModeConfigurationURLLoader;

public final class ShardingSphereURLLoadEngine {
    private final ShardingSphereURL url;

    public Object loadContent() {
        Optional localFileURLLoader = TypedSPILoader.findService(ShardingSphereLocalFileURLLoader.class, (Object)this.url.getSourceType());
        if (localFileURLLoader.isPresent()) {
            List<String> lines = Arrays.asList(((ShardingSphereLocalFileURLLoader)localFileURLLoader.get()).load(this.url.getConfigurationSubject(), this.url.getQueryProps()).split(System.lineSeparator()));
            return URLArgumentLineRender.render(lines, (URLArgumentPlaceholderType)URLArgumentPlaceholderTypeFactory.valueOf((Properties)this.url.getQueryProps()));
        }
        Optional modeConfigURLLoader = TypedSPILoader.findService(ShardingSphereModeConfigurationURLLoader.class, (Object)this.url.getSourceType());
        if (modeConfigURLLoader.isPresent()) {
            return ((ShardingSphereModeConfigurationURLLoader)modeConfigURLLoader.get()).load(this.url.getConfigurationSubject(), this.url.getQueryProps());
        }
        throw new ServiceProviderNotFoundException(ShardingSphereModeConfigurationURLLoader.class, (Object)this.url.getSourceType());
    }

    @Generated
    public ShardingSphereURLLoadEngine(ShardingSphereURL url) {
        this.url = url;
    }
}

