/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.driver.jdbc.adapter.WrapperAdapter;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.transaction.util.AutoCommitUtils;

public abstract class AbstractStatementAdapter
extends WrapperAdapter
implements Statement {
    private final ForceExecuteTemplate<Statement> forceExecuteTemplate = new ForceExecuteTemplate();
    private boolean poolable;
    private int fetchSize;
    private int fetchDirection;
    private boolean closeOnCompletion;
    private boolean closed;

    protected final void handleAutoCommitBeforeExecution(SQLStatement sqlStatement, ShardingSphereConnection connection) throws SQLException {
        if (AutoCommitUtils.isNeedStartTransaction((SQLStatement)sqlStatement)) {
            connection.beginTransactionIfNeededWhenAutoCommitFalse();
        }
    }

    protected final void handleAutoCommitAfterExecution(ShardingSphereConnection connection) throws SQLException {
        if (connection.getAutoCommit()) {
            connection.getDatabaseConnectionManager().clearCachedConnections();
        }
    }

    protected final void handleExceptionInTransaction(ShardingSphereConnection connection, ShardingSphereMetaData metaData) {
        DatabaseType databaseType;
        DialectDatabaseMetaData dialectDatabaseMetaData;
        if (connection.getDatabaseConnectionManager().getConnectionContext().getTransactionContext().isInTransaction() && (dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType = metaData.getDatabase(connection.getCurrentDatabaseName()).getProtocolType()).getDialectDatabaseMetaData()).getSchemaOption().getDefaultSchema().isPresent()) {
            connection.getDatabaseConnectionManager().getConnectionContext().getTransactionContext().setExceptionOccur(true);
        }
    }

    protected abstract boolean isAccumulate();

    protected abstract Collection<? extends Statement> getRoutedStatements();

    protected abstract StatementManager getStatementManager();

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        this.poolable = poolable;
        this.getMethodInvocationRecorder().record("setPoolable", statement -> statement.setPoolable(poolable));
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), statement -> statement.setPoolable(poolable));
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
        this.getMethodInvocationRecorder().record("setFetchSize", statement -> statement.setFetchSize(rows));
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), statement -> statement.setFetchSize(rows));
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
        this.getMethodInvocationRecorder().record("setFetchDirection", statement -> statement.setFetchDirection(direction));
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), statement -> statement.setFetchDirection(direction));
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        this.getMethodInvocationRecorder().record("setMaxFieldSize", statement -> statement.setMaxFieldSize(max));
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), statement -> statement.setMaxFieldSize(max));
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? -1 : this.getRoutedStatements().iterator().next().getMaxRows();
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.getMethodInvocationRecorder().record("setMaxRows", statement -> statement.setMaxRows(max));
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), statement -> statement.setMaxRows(max));
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        this.getMethodInvocationRecorder().record("setQueryTimeout", statement -> statement.setQueryTimeout(seconds));
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), statement -> statement.setQueryTimeout(seconds));
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.getMethodInvocationRecorder().record("setEscapeProcessing", statement -> statement.setEscapeProcessing(enable));
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), statement -> statement.setEscapeProcessing(enable));
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        if (this.isAccumulate()) {
            return this.accumulate();
        }
        Collection<? extends Statement> statements = this.getRoutedStatements();
        if (statements.isEmpty()) {
            return -1;
        }
        return this.getRoutedStatements().iterator().next().getUpdateCount();
    }

    private int accumulate() throws SQLException {
        long result = 0L;
        boolean hasResult = false;
        for (Statement statement : this.getRoutedStatements()) {
            int updateCount = statement.getUpdateCount();
            if (updateCount > -1) {
                hasResult = true;
            }
            result += (long)updateCount;
        }
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        return hasResult ? (int)result : -1;
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        boolean result = false;
        for (Statement statement : this.getRoutedStatements()) {
            result = statement.getMoreResults();
        }
        return result;
    }

    @Override
    public final boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public final boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    @Override
    public final void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        ShardingSpherePreconditions.checkState((1 == this.getRoutedStatements().size() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("setCursorName"));
        this.getRoutedStatements().iterator().next().setCursorName(name);
    }

    @Override
    public final void cancel() throws SQLException {
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), Statement::cancel);
    }

    @Override
    public final SQLWarning getWarnings() {
        return null;
    }

    @Override
    public final void clearWarnings() {
    }

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        try {
            this.forceExecuteTemplate.execute(this.getRoutedStatements(), Statement::close);
            this.closeExecutor();
            if (null != this.getStatementManager()) {
                this.getStatementManager().close();
                Connection connection = this.getConnection();
                if (connection instanceof ShardingSphereConnection) {
                    ShardingSphereConnection logicalConnection = (ShardingSphereConnection)connection;
                    logicalConnection.getStatementManagers().remove(this.getStatementManager());
                    this.handleAutoCommitAfterExecution(logicalConnection);
                }
            }
        }
        finally {
            this.getRoutedStatements().clear();
        }
    }

    protected abstract void closeExecutor() throws SQLException;

    @Override
    @Generated
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    @Generated
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    @Generated
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    @Generated
    public boolean isClosed() {
        return this.closed;
    }
}

