/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.transaction;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.savepoint.ShardingSphereSavepoint;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;

public final class DriverTransactionSQLStatementExecutor {
    private final ShardingSphereConnection connection;

    public boolean decide(QueryContext queryContext) {
        if (!(queryContext.getSqlStatementContext().getSqlStatement() instanceof TCLStatement)) {
            return false;
        }
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        return sqlStatement instanceof SavepointStatement || sqlStatement instanceof ReleaseSavepointStatement;
    }

    public boolean execute(TCLStatement sqlStatement) throws SQLException {
        if (sqlStatement instanceof SavepointStatement) {
            this.connection.setSavepoint(((SavepointStatement)sqlStatement).getSavepointName());
            return true;
        }
        if (sqlStatement instanceof ReleaseSavepointStatement) {
            this.connection.releaseSavepoint(new ShardingSphereSavepoint(((ReleaseSavepointStatement)sqlStatement).getSavepointName()));
            return true;
        }
        return false;
    }

    @Generated
    public DriverTransactionSQLStatementExecutor(ShardingSphereConnection connection) {
        this.connection = connection;
    }
}

