/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.pushdown.raw;

import java.sql.SQLException;
import java.util.Collection;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class DriverRawPushDownExecuteUpdateExecutor {
    private final ShardingSphereConnection connection;
    private final String processId;
    private final ConfigurationProperties props;
    private final RawExecutor rawExecutor;

    public DriverRawPushDownExecuteUpdateExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, RawExecutor rawExecutor) {
        this.connection = connection;
        this.processId = connection.getProcessId();
        this.props = metaData.getProps();
        this.rawExecutor = rawExecutor;
    }

    public int executeUpdate(ShardingSphereDatabase database, ExecutionContext executionContext) throws SQLException {
        return this.accumulate(this.rawExecutor.execute(this.createRawExecutionGroupContext(database, executionContext), executionContext.getQueryContext(), new RawSQLExecutorCallback()));
    }

    private int accumulate(Collection<ExecuteResult> results) {
        int result = 0;
        for (ExecuteResult each : results) {
            result += ((UpdateResult)each).getUpdateCount();
        }
        return result;
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionGroupContext(ShardingSphereDatabase database, ExecutionContext executionContext) throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.props.getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, database.getRuleMetaData().getRules()).prepare(database.getName(), executionContext, executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.processId, database.getName(), this.connection.getDatabaseConnectionManager().getConnectionContext().getGrantee()));
    }
}

