/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.pushdown.raw;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class DriverRawPushDownExecuteExecutor {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final RawExecutor rawExecutor;

    public boolean execute(ShardingSphereDatabase database, ExecutionContext executionContext) throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.metaData.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        ExecutionGroupContext executionGroupContext = new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, database.getRuleMetaData().getRules()).prepare(database.getName(), executionContext, executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.connection.getProcessId(), database.getName(), this.connection.getDatabaseConnectionManager().getConnectionContext().getGrantee()));
        return this.rawExecutor.execute(executionGroupContext, executionContext.getQueryContext(), new RawSQLExecutorCallback()).iterator().next() instanceof QueryResult;
    }

    @Generated
    public DriverRawPushDownExecuteExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, RawExecutor rawExecutor) {
        this.connection = connection;
        this.metaData = metaData;
        this.rawExecutor = rawExecutor;
    }
}

