/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.ExecuteQueryCallbackFactory;
import org.apache.shardingsphere.driver.executor.callback.replay.StatementReplayCallback;
import org.apache.shardingsphere.driver.executor.engine.pushdown.jdbc.DriverJDBCPushDownExecuteQueryExecutor;
import org.apache.shardingsphere.driver.executor.engine.pushdown.raw.DriverRawPushDownExecuteQueryExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.raw.RawExecutionRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sqlfederation.context.SQLFederationContext;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;

public final class DriverExecuteQueryExecutor {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final DriverJDBCPushDownExecuteQueryExecutor driverJDBCPushDownExecutor;
    private final DriverRawPushDownExecuteQueryExecutor driverRawPushDownExecutor;
    private final SQLFederationEngine sqlFederationEngine;

    public DriverExecuteQueryExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, JDBCExecutor jdbcExecutor, RawExecutor rawExecutor, SQLFederationEngine sqlFederationEngine) {
        this.connection = connection;
        this.metaData = metaData;
        this.driverJDBCPushDownExecutor = new DriverJDBCPushDownExecuteQueryExecutor(connection, metaData, jdbcExecutor);
        this.driverRawPushDownExecutor = new DriverRawPushDownExecuteQueryExecutor(connection, metaData, rawExecutor);
        this.sqlFederationEngine = sqlFederationEngine;
    }

    public ResultSet executeQuery(ShardingSphereDatabase database, QueryContext queryContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, Statement statement, Map<String, Integer> columnLabelAndIndexMap, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        if (this.sqlFederationEngine.decide(queryContext, this.metaData.getGlobalRuleMetaData())) {
            return this.sqlFederationEngine.executeQuery(prepareEngine, (JDBCExecutorCallback)new ExecuteQueryCallbackFactory(prepareEngine.getType()).newInstance(database, queryContext), new SQLFederationContext(false, queryContext, this.metaData, this.connection.getProcessId()));
        }
        return database.getRuleMetaData().getAttributes(RawExecutionRuleAttribute.class).isEmpty() ? this.driverJDBCPushDownExecutor.executeQuery(database, queryContext, prepareEngine, statement, columnLabelAndIndexMap, addCallback, replayCallback) : this.driverRawPushDownExecutor.executeQuery(database, queryContext, statement, columnLabelAndIndexMap);
    }
}

