/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.callback.execute;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ExecuteCallbackFactory {
    private final JDBCDriverType type;

    public JDBCExecutorCallback<Boolean> newInstance(ShardingSphereDatabase database, final StatementExecuteCallback executeCallback, SQLStatement sqlStatement) {
        return new JDBCExecutorCallback<Boolean>(database.getProtocolType(), database.getResourceMetaData(), sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return JDBCDriverType.STATEMENT == ExecuteCallbackFactory.this.type ? executeCallback.execute(sql, statement) : ((PreparedStatement)statement).execute();
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement1, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    @Generated
    public ExecuteCallbackFactory(JDBCDriverType type) {
        this.type = type;
    }
}

