/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.expr.entry;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.expr.spi.InlineExpressionParser;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class InlineExpressionParserFactory {
    private static final String TYPE_NAME_BEGIN_SYMBOL = "<";
    private static final String TYPE_NAME_END_SYMBOL = ">";
    private static final String DEFAULT_TYPE_NAME = null == System.getProperty("org.graalvm.nativeimage.imagecode") ? "GROOVY" : "LITERAL";

    public static InlineExpressionParser newInstance(String inlineExpression) {
        Properties props = new Properties();
        if (null == inlineExpression) {
            return (InlineExpressionParser)TypedSPILoader.getService(InlineExpressionParser.class, (Object)DEFAULT_TYPE_NAME, (Properties)props);
        }
        if (!inlineExpression.startsWith(TYPE_NAME_BEGIN_SYMBOL)) {
            props.setProperty("inlineExpression", inlineExpression);
            return (InlineExpressionParser)TypedSPILoader.getService(InlineExpressionParser.class, (Object)DEFAULT_TYPE_NAME, (Properties)props);
        }
        Integer typeBeginIndex = inlineExpression.indexOf(TYPE_NAME_BEGIN_SYMBOL);
        Integer typeEndIndex = inlineExpression.indexOf(TYPE_NAME_END_SYMBOL);
        props.setProperty("inlineExpression", InlineExpressionParserFactory.getExprWithoutTypeName(inlineExpression, typeBeginIndex, typeEndIndex));
        return (InlineExpressionParser)TypedSPILoader.getService(InlineExpressionParser.class, (Object)InlineExpressionParserFactory.getTypeName(inlineExpression, typeBeginIndex, typeEndIndex), (Properties)props);
    }

    private static String getTypeName(String inlineExpression, Integer beginIndex, Integer endIndex) {
        return beginIndex.equals(-1) || endIndex.equals(-1) ? DEFAULT_TYPE_NAME : inlineExpression.substring(beginIndex + 1, endIndex);
    }

    private static String getExprWithoutTypeName(String inlineExpression, Integer beginIndex, Integer endIndex) {
        return inlineExpression.substring(0, beginIndex) + inlineExpression.substring(endIndex + 1);
    }

    @Generated
    private InlineExpressionParserFactory() {
    }
}

