/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.opengauss.visitor.statement.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementParser;
import org.apache.shardingsphere.sql.parser.engine.opengauss.visitor.statement.OpenGaussStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.DirectionType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ValidateConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.cursor.DirectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.NameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CloseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CommentStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CursorStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DeallocateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.FetchStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.MoveStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.PrepareStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.directory.AlterDirectoryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.directory.CreateDirectoryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.directory.DropDirectoryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.domain.AlterDomainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.domain.CreateDomainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.domain.DropDomainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.pkg.AlterPackageStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.DropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.AlterSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.CreateSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.DropSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.server.DropServerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.synonym.AlterSynonymStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.synonym.CreateSynonymStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.synonym.DropSynonymStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.AlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.CreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.DropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.type.AlterTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.type.CreateTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.type.DropTypeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.PostgreSQLAlterDefaultPrivilegesStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.PostgreSQLDeclareStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.aggregate.PostgreSQLAlterAggregateStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.aggregate.PostgreSQLCreateAggregateStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.cast.PostgreSQLCreateCastStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.cast.PostgreSQLDropCastStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.conversion.PostgreSQLAlterConversionStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.conversion.PostgreSQLCreateConversionStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.conversion.PostgreSQLDropConversionStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.extension.PostgreSQLAlterExtensionStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.extension.PostgreSQLCreateExtensionStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.extension.PostgreSQLDropExtensionStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.foreigntable.PostgreSQLAlterForeignTableStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.group.PostgreSQLAlterGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.language.PostgreSQLAlterLanguageStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.language.PostgreSQLCreateLanguageStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.language.PostgreSQLDropLanguageStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.publication.PostgreSQLCreatePublicationStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.publication.PostgreSQLDropPublicationStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.rule.PostgreSQLAlterRuleStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.rule.PostgreSQLCreateRuleStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.rule.PostgreSQLDropRuleStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.textsearch.PostgreSQLAlterTextSearchStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.ddl.textsearch.PostgreSQLCreateTextSearchStatement;

public final class OpenGaussDDLStatementVisitor
extends OpenGaussStatementVisitor
implements DDLStatementVisitor {
    public OpenGaussDDLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCreateTable(OpenGaussStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setIfNotExists(null != ctx.ifNotExists());
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(OpenGaussStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(OpenGaussStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause().tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ValidateConstraintDefinitionSegment) {
                    result.getValidateConstraintDefinitions().add((ValidateConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyConstraintDefinitionSegment) {
                    result.getModifyConstraintDefinitions().add((ModifyConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropConstraintDefinitionSegment) {
                    result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof RenameTableDefinitionSegment) {
                    result.setRenameTable(((RenameTableDefinitionSegment)each).getRenameTable());
                    continue;
                }
                if (!(each instanceof RenameColumnSegment)) continue;
                result.getRenameColumnDefinitions().add((RenameColumnSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterAggregate(OpenGaussStatementParser.AlterAggregateContext ctx) {
        return new PostgreSQLAlterAggregateStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDefaultPrivileges(OpenGaussStatementParser.AlterDefaultPrivilegesContext ctx) {
        return new PostgreSQLAlterDefaultPrivilegesStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDefinitionClause(OpenGaussStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.alterTableActions()) {
            result.getValue().addAll(ctx.alterTableActions().alterTableAction().stream().flatMap(each -> this.getAlterDefinitionSegments((OpenGaussStatementParser.AlterTableActionContext)((Object)each)).stream()).collect(Collectors.toList()));
        }
        if (null != ctx.renameColumnSpecification()) {
            result.getValue().add((RenameColumnSegment)this.visit((ParseTree)ctx.renameColumnSpecification()));
        }
        if (null != ctx.renameTableSpecification()) {
            result.getValue().add((RenameTableDefinitionSegment)this.visit((ParseTree)ctx.renameTableSpecification()));
        }
        return result;
    }

    private Collection<AlterDefinitionSegment> getAlterDefinitionSegments(OpenGaussStatementParser.AlterTableActionContext ctx) {
        LinkedList<AlterDefinitionSegment> result = new LinkedList<AlterDefinitionSegment>();
        if (null != ctx.addColumnSpecification()) {
            result.addAll(((CollectionValue)this.visit((ParseTree)ctx.addColumnSpecification())).getValue());
        }
        if (null != ctx.addConstraintSpecification() && null != ctx.addConstraintSpecification().tableConstraint()) {
            result.add((AlterDefinitionSegment)((AddConstraintDefinitionSegment)this.visit((ParseTree)ctx.addConstraintSpecification())));
        }
        if (null != ctx.validateConstraintSpecification()) {
            result.add((AlterDefinitionSegment)((ValidateConstraintDefinitionSegment)this.visit((ParseTree)ctx.validateConstraintSpecification())));
        }
        if (null != ctx.modifyColumnSpecification()) {
            result.add((AlterDefinitionSegment)((ModifyColumnDefinitionSegment)this.visit((ParseTree)ctx.modifyColumnSpecification())));
        }
        if (null != ctx.modifyConstraintSpecification()) {
            result.add((AlterDefinitionSegment)((ModifyConstraintDefinitionSegment)this.visit((ParseTree)ctx.modifyConstraintSpecification())));
        }
        if (null != ctx.dropColumnSpecification()) {
            result.add((AlterDefinitionSegment)((DropColumnDefinitionSegment)this.visit((ParseTree)ctx.dropColumnSpecification())));
        }
        if (null != ctx.dropConstraintSpecification()) {
            result.add((AlterDefinitionSegment)((DropConstraintDefinitionSegment)this.visit((ParseTree)ctx.dropConstraintSpecification())));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterForeignTable(OpenGaussStatementParser.AlterForeignTableContext ctx) {
        return new PostgreSQLAlterForeignTableStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterGroup(OpenGaussStatementParser.AlterGroupContext ctx) {
        return new PostgreSQLAlterGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterPackage(OpenGaussStatementParser.AlterPackageContext ctx) {
        return new AlterPackageStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterMaterializedView(OpenGaussStatementParser.AlterMaterializedViewContext ctx) {
        return new AlterMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAddConstraintSpecification(OpenGaussStatementParser.AddConstraintSpecificationContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.tableConstraint()));
    }

    @Override
    public ASTNode visitValidateConstraintSpecification(OpenGaussStatementParser.ValidateConstraintSpecificationContext ctx) {
        return new ValidateConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitModifyConstraintSpecification(OpenGaussStatementParser.ModifyConstraintSpecificationContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitDropConstraintSpecification(OpenGaussStatementParser.DropConstraintSpecificationContext ctx) {
        return new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterDomain(OpenGaussStatementParser.AlterDomainContext ctx) {
        return new AlterDomainStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRenameTableSpecification(OpenGaussStatementParser.RenameTableSpecificationContext ctx) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        TableNameSegment tableName = new TableNameSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        result.setRenameTable(new SimpleTableSegment(tableName));
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(OpenGaussStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        OpenGaussStatementParser.ColumnDefinitionContext columnDefinition = ctx.columnDefinition();
        if (null != columnDefinition) {
            AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(ctx.columnDefinition().getStart().getStartIndex(), columnDefinition.getStop().getStopIndex(), Collections.singleton((ColumnDefinitionSegment)this.visit((ParseTree)columnDefinition)));
            result.getValue().add(addColumnDefinition);
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(OpenGaussStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.columnConstraint().stream().anyMatch(each -> null != each.columnConstraintOption() && null != each.columnConstraintOption().primaryKey());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, false, this.getText(ctx));
        for (OpenGaussStatementParser.ColumnConstraintContext each2 : ctx.columnConstraint()) {
            if (null == each2.columnConstraintOption().tableName()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each2.columnConstraintOption().tableName()));
        }
        return result;
    }

    private String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Override
    public ASTNode visitTableConstraintUsingIndex(OpenGaussStatementParser.TableConstraintUsingIndexContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.indexName()) {
            result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraint(OpenGaussStatementParser.TableConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintClause()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintClause().constraintName()));
        }
        if (null != ctx.tableConstraintOption().primaryKey()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableConstraintOption().columnNames(0))).getValue());
        }
        if (null != ctx.tableConstraintOption().FOREIGN()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableConstraintOption().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(OpenGaussStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.modifyColumn().columnName());
        DataTypeSegment dataType = null == ctx.dataType() ? null : (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false, this.getText(ctx));
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(OpenGaussStatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singleton((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitRenameColumnSpecification(OpenGaussStatementParser.RenameColumnSpecificationContext ctx) {
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnSegment)this.visit((ParseTree)ctx.columnName(0)), (ColumnSegment)this.visit((ParseTree)ctx.columnName(1)));
    }

    @Override
    public ASTNode visitDropTable(OpenGaussStatementParser.DropTableContext ctx) {
        boolean containsCascade = null != ctx.dropTableOpt() && null != ctx.dropTableOpt().CASCADE();
        DropTableStatement result = new DropTableStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.setContainsCascade(containsCascade);
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(OpenGaussStatementParser.TruncateTableContext ctx) {
        return new TruncateStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableNamesClause())).getValue());
    }

    @Override
    public ASTNode visitCreateIndex(OpenGaussStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement(this.getDatabaseType());
        result.setIfNotExists(null != ctx.ifNotExists());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.indexParams())).getValue());
        if (null == ctx.indexName()) {
            result.setAnonymousIndexStartIndex(Integer.valueOf(ctx.ON().getSymbol().getStartIndex() - 1));
        } else {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitIndexParams(OpenGaussStatementParser.IndexParamsContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.IndexElemContext each : ctx.indexElem()) {
            if (null != each.colId()) {
                result.getValue().add(new ColumnSegment(each.colId().start.getStartIndex(), each.colId().stop.getStopIndex(), new IdentifierValue(each.colId().getText())));
            }
            if (null == each.functionExprWindowless()) continue;
            FunctionSegment functionSegment = (FunctionSegment)this.visit((ParseTree)each.functionExprWindowless());
            functionSegment.getParameters().forEach(param -> {
                if (param instanceof ColumnSegment) {
                    result.getValue().add((ColumnSegment)param);
                }
            });
        }
        return result;
    }

    @Override
    public ASTNode visitFunctionExprWindowless(OpenGaussStatementParser.FunctionExprWindowlessContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcApplication().funcName().getText(), this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.funcApplication().funcArgList().funcArgExpr()));
        return result;
    }

    private Collection<ExpressionSegment> getExpressions(Collection<OpenGaussStatementParser.FuncArgExprContext> aExprContexts) {
        if (null == aExprContexts) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(aExprContexts.size());
        for (OpenGaussStatementParser.FuncArgExprContext each : aExprContexts) {
            result.add((ExpressionSegment)this.visit((ParseTree)each.aExpr()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterIndex(OpenGaussStatementParser.AlterIndexContext ctx) {
        AlterIndexStatement result = new AlterIndexStatement(this.getDatabaseType());
        result.setIndex(this.createIndexSegment((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())));
        if (null != ctx.alterIndexDefinitionClause().renameIndexSpecification()) {
            result.setRenameIndex((IndexSegment)this.visit((ParseTree)ctx.alterIndexDefinitionClause().renameIndexSpecification().indexName()));
        }
        return result;
    }

    private IndexSegment createIndexSegment(SimpleTableSegment tableSegment) {
        IndexNameSegment indexName = new IndexNameSegment(tableSegment.getTableName().getStartIndex(), tableSegment.getTableName().getStopIndex(), tableSegment.getTableName().getIdentifier());
        IndexSegment result = new IndexSegment(tableSegment.getStartIndex(), tableSegment.getStopIndex(), indexName);
        tableSegment.getOwner().ifPresent(arg_0 -> ((IndexSegment)result).setOwner(arg_0));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(OpenGaussStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getIndexes().addAll(this.createIndexSegments(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue()));
        return result;
    }

    private Collection<IndexSegment> createIndexSegments(Collection<SimpleTableSegment> tableSegments) {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        for (SimpleTableSegment each : tableSegments) {
            result.add(this.createIndexSegment(each));
        }
        return result;
    }

    @Override
    public ASTNode visitIndexNames(OpenGaussStatementParser.IndexNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.IndexNameContext each : ctx.indexName()) {
            result.getValue().add((IndexSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitTableNameClause(OpenGaussStatementParser.TableNameClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitTableNamesClause(OpenGaussStatementParser.TableNamesClauseContext ctx) {
        LinkedList<SimpleTableSegment> tableSegments = new LinkedList<SimpleTableSegment>();
        for (int i = 0; i < ctx.tableNameClause().size(); ++i) {
            tableSegments.add((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause(i)));
        }
        CollectionValue result = new CollectionValue();
        result.getValue().addAll(tableSegments);
        return result;
    }

    @Override
    public ASTNode visitAlterFunction(OpenGaussStatementParser.AlterFunctionContext ctx) {
        return new AlterFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterProcedure(OpenGaussStatementParser.AlterProcedureContext ctx) {
        return new AlterProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateFunction(OpenGaussStatementParser.CreateFunctionContext ctx) {
        return new CreateFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateProcedure(OpenGaussStatementParser.CreateProcedureContext ctx) {
        return new CreateProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropFunction(OpenGaussStatementParser.DropFunctionContext ctx) {
        return new DropFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropView(OpenGaussStatementParser.DropViewContext ctx) {
        DropViewStatement result = new DropViewStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getViews().addAll(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateView(OpenGaussStatementParser.CreateViewContext ctx) {
        CreateViewStatement result = new CreateViewStatement(this.getDatabaseType());
        result.setReplaceView(null != ctx.REPLACE());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitAlterView(OpenGaussStatementParser.AlterViewContext ctx) {
        AlterViewStatement result = new AlterViewStatement(this.getDatabaseType());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        if (ctx.alterViewClauses() instanceof OpenGaussStatementParser.AlterRenameViewContext) {
            OpenGaussStatementParser.NameContext nameContext = ((OpenGaussStatementParser.AlterRenameViewContext)ctx.alterViewClauses()).name();
            result.setRenameView(new SimpleTableSegment(new TableNameSegment(nameContext.getStart().getStartIndex(), nameContext.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)nameContext.identifier()))));
        }
        return result;
    }

    @Override
    public ASTNode visitDropDatabase(OpenGaussStatementParser.DropDatabaseContext ctx) {
        return new DropDatabaseStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.name())).getValue(), null != ctx.ifExists());
    }

    @Override
    public ASTNode visitDropServer(OpenGaussStatementParser.DropServerContext ctx) {
        return new DropServerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropProcedure(OpenGaussStatementParser.DropProcedureContext ctx) {
        return new DropProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropPublication(OpenGaussStatementParser.DropPublicationContext ctx) {
        return new PostgreSQLDropPublicationStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropCast(OpenGaussStatementParser.DropCastContext ctx) {
        return new PostgreSQLDropCastStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRule(OpenGaussStatementParser.DropRuleContext ctx) {
        return new PostgreSQLDropRuleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDatabase(OpenGaussStatementParser.CreateDatabaseContext ctx) {
        return new CreateDatabaseStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.name())).getValue(), false);
    }

    @Override
    public ASTNode visitCreateSequence(OpenGaussStatementParser.CreateSequenceContext ctx) {
        return new CreateSequenceStatement(this.getDatabaseType(), ((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())).getTableName().getIdentifier().getValue());
    }

    @Override
    public ASTNode visitAlterSequence(OpenGaussStatementParser.AlterSequenceContext ctx) {
        return new AlterSequenceStatement(this.getDatabaseType(), ((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())).getTableName().getIdentifier().getValue());
    }

    @Override
    public ASTNode visitDropSequence(OpenGaussStatementParser.DropSequenceContext ctx) {
        return new DropSequenceStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue());
    }

    @Override
    public ASTNode visitDropSynonym(OpenGaussStatementParser.DropSynonymContext ctx) {
        return new DropSynonymStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropType(OpenGaussStatementParser.DropTypeContext ctx) {
        return new DropTypeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDirectory(OpenGaussStatementParser.DropDirectoryContext ctx) {
        return new DropDirectoryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitPrepare(OpenGaussStatementParser.PrepareContext ctx) {
        PrepareStatement result = new PrepareStatement(this.getDatabaseType());
        if (null != ctx.preparableStmt().select()) {
            result.setSelect((SelectStatement)this.visit((ParseTree)ctx.preparableStmt().select()));
        }
        if (null != ctx.preparableStmt().insert()) {
            result.setInsert((InsertStatement)this.visit((ParseTree)ctx.preparableStmt().insert()));
        }
        if (null != ctx.preparableStmt().update()) {
            result.setUpdate((UpdateStatement)this.visit((ParseTree)ctx.preparableStmt().update()));
        }
        if (null != ctx.preparableStmt().delete()) {
            result.setDelete((DeleteStatement)this.visit((ParseTree)ctx.preparableStmt().delete()));
        }
        return result;
    }

    @Override
    public ASTNode visitDeallocate(OpenGaussStatementParser.DeallocateContext ctx) {
        return new DeallocateStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateSynonym(OpenGaussStatementParser.CreateSynonymContext ctx) {
        return new CreateSynonymStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateAggregate(OpenGaussStatementParser.CreateAggregateContext ctx) {
        return new PostgreSQLCreateAggregateStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreatePublication(OpenGaussStatementParser.CreatePublicationContext ctx) {
        return new PostgreSQLCreatePublicationStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDirectory(OpenGaussStatementParser.CreateDirectoryContext ctx) {
        return new CreateDirectoryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTablespace(OpenGaussStatementParser.CreateTablespaceContext ctx) {
        return new CreateTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTablespace(OpenGaussStatementParser.AlterTablespaceContext ctx) {
        return new AlterTablespaceStatement(this.getDatabaseType(), null, null);
    }

    @Override
    public ASTNode visitDropTablespace(OpenGaussStatementParser.DropTablespaceContext ctx) {
        return new DropTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDomain(OpenGaussStatementParser.DropDomainContext ctx) {
        return new DropDomainStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDomain(OpenGaussStatementParser.CreateDomainContext ctx) {
        return new CreateDomainStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateRule(OpenGaussStatementParser.CreateRuleContext ctx) {
        return new PostgreSQLCreateRuleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateLanguage(OpenGaussStatementParser.CreateLanguageContext ctx) {
        return new PostgreSQLCreateLanguageStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateSchema(OpenGaussStatementParser.CreateSchemaContext ctx) {
        CreateSchemaStatement result = new CreateSchemaStatement(this.getDatabaseType());
        if (null != ctx.createSchemaClauses().colId()) {
            result.setSchemaName(new IdentifierValue(ctx.createSchemaClauses().colId().getText()));
        }
        if (null != ctx.createSchemaClauses().roleSpec() && null != ctx.createSchemaClauses().roleSpec().identifier()) {
            result.setUsername((IdentifierValue)this.visit((ParseTree)ctx.createSchemaClauses().roleSpec().identifier()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterSchema(OpenGaussStatementParser.AlterSchemaContext ctx) {
        AlterSchemaStatement result = new AlterSchemaStatement(this.getDatabaseType());
        result.setSchemaName((IdentifierValue)this.visit((ParseTree)ctx.name().get(0)));
        if (ctx.name().size() > 1) {
            result.setRenameSchema((IdentifierValue)this.visit((ParseTree)ctx.name().get(1)));
        }
        return result;
    }

    @Override
    public ASTNode visitDropSchema(OpenGaussStatementParser.DropSchemaContext ctx) {
        DropSchemaStatement result = new DropSchemaStatement(this.getDatabaseType());
        result.getSchemaNames().addAll(((CollectionValue)this.visit((ParseTree)ctx.nameList())).getValue());
        result.setContainsCascade(null != ctx.dropBehavior() && null != ctx.dropBehavior().CASCADE());
        return result;
    }

    @Override
    public ASTNode visitNameList(OpenGaussStatementParser.NameListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.nameList()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.nameList()));
        }
        if (null != ctx.name()) {
            result.getValue().add((IdentifierValue)this.visit((ParseTree)ctx.name()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterLanguage(OpenGaussStatementParser.AlterLanguageContext ctx) {
        return new PostgreSQLAlterLanguageStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterSynonym(OpenGaussStatementParser.AlterSynonymContext ctx) {
        return new AlterSynonymStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDirectory(OpenGaussStatementParser.AlterDirectoryContext ctx) {
        return new AlterDirectoryStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterRule(OpenGaussStatementParser.AlterRuleContext ctx) {
        return new PostgreSQLAlterRuleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterType(OpenGaussStatementParser.AlterTypeContext ctx) {
        return new AlterTypeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropLanguage(OpenGaussStatementParser.DropLanguageContext ctx) {
        return new PostgreSQLDropLanguageStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateConversion(OpenGaussStatementParser.CreateConversionContext ctx) {
        return new PostgreSQLCreateConversionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateCast(OpenGaussStatementParser.CreateCastContext ctx) {
        return new PostgreSQLCreateCastStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateType(OpenGaussStatementParser.CreateTypeContext ctx) {
        return new CreateTypeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropConversion(OpenGaussStatementParser.DropConversionContext ctx) {
        return new PostgreSQLDropConversionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterConversion(OpenGaussStatementParser.AlterConversionContext ctx) {
        return new PostgreSQLAlterConversionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTextSearch(OpenGaussStatementParser.CreateTextSearchContext ctx) {
        return new PostgreSQLCreateTextSearchStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTextSearchDictionary(OpenGaussStatementParser.AlterTextSearchDictionaryContext ctx) {
        return new PostgreSQLAlterTextSearchStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTextSearchTemplate(OpenGaussStatementParser.AlterTextSearchTemplateContext ctx) {
        return new PostgreSQLAlterTextSearchStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTextSearchParser(OpenGaussStatementParser.AlterTextSearchParserContext ctx) {
        return new PostgreSQLAlterTextSearchStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateExtension(OpenGaussStatementParser.CreateExtensionContext ctx) {
        return new PostgreSQLCreateExtensionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterExtension(OpenGaussStatementParser.AlterExtensionContext ctx) {
        return new PostgreSQLAlterExtensionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropExtension(OpenGaussStatementParser.DropExtensionContext ctx) {
        return new PostgreSQLDropExtensionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDeclare(OpenGaussStatementParser.DeclareContext ctx) {
        return new PostgreSQLDeclareStatement(this.getDatabaseType(), (CursorNameSegment)this.visit((ParseTree)ctx.cursorName()), (SelectStatement)this.visit((ParseTree)ctx.select()));
    }

    @Override
    public ASTNode visitComment(OpenGaussStatementParser.CommentContext ctx) {
        if (null != ctx.commentClauses().objectTypeAnyName() && null != ctx.commentClauses().objectTypeAnyName().TABLE()) {
            return this.commentOnTable(ctx);
        }
        if (null != ctx.commentClauses().COLUMN()) {
            return this.commentOnColumn(ctx);
        }
        return new CommentStatement(this.getDatabaseType());
    }

    private CommentStatement commentOnColumn(OpenGaussStatementParser.CommentContext ctx) {
        CommentStatement result = new CommentStatement(this.getDatabaseType());
        Iterator<NameSegment> nameSegmentIterator = ((CollectionValue)this.visit((ParseTree)ctx.commentClauses().anyName())).getValue().iterator();
        Optional<NameSegment> columnName = nameSegmentIterator.hasNext() ? Optional.of((NameSegment)nameSegmentIterator.next()) : Optional.empty();
        columnName.ifPresent(optional -> result.setColumn(new ColumnSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier())));
        result.setComment(new IdentifierValue(ctx.commentClauses().commentText().getText()));
        this.setTableSegment(result, nameSegmentIterator);
        return result;
    }

    private CommentStatement commentOnTable(OpenGaussStatementParser.CommentContext ctx) {
        CommentStatement result = new CommentStatement(this.getDatabaseType());
        Iterator<NameSegment> nameSegmentIterator = ((CollectionValue)this.visit((ParseTree)ctx.commentClauses().anyName())).getValue().iterator();
        result.setComment(new IdentifierValue(ctx.commentClauses().commentText().getText()));
        this.setTableSegment(result, nameSegmentIterator);
        return result;
    }

    private void setTableSegment(CommentStatement statement, Iterator<NameSegment> nameSegmentIterator) {
        Optional<NameSegment> tableName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        tableName.ifPresent(optional -> statement.setTable(new SimpleTableSegment(new TableNameSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier()))));
        Optional<NameSegment> schemaName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        schemaName.ifPresent(optional -> statement.getTable().setOwner(new OwnerSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier())));
        Optional<NameSegment> databaseName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        databaseName.ifPresent(optional -> statement.getTable().getOwner().ifPresent(owner -> owner.setOwner(new OwnerSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier()))));
    }

    @Override
    public ASTNode visitCursor(OpenGaussStatementParser.CursorContext ctx) {
        return new CursorStatement(this.getDatabaseType(), (CursorNameSegment)this.visit((ParseTree)ctx.cursorName()), (SelectStatement)this.visit((ParseTree)ctx.select()));
    }

    @Override
    public ASTNode visitCursorName(OpenGaussStatementParser.CursorNameContext ctx) {
        return new CursorNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
    }

    @Override
    public ASTNode visitClose(OpenGaussStatementParser.CloseContext ctx) {
        return new CloseStatement(this.getDatabaseType(), null == ctx.cursorName() ? null : (CursorNameSegment)this.visit((ParseTree)ctx.cursorName()), null != ctx.ALL());
    }

    @Override
    public ASTNode visitMove(OpenGaussStatementParser.MoveContext ctx) {
        return new MoveStatement(this.getDatabaseType(), (CursorNameSegment)this.visit((ParseTree)ctx.cursorName()), null == ctx.direction() ? null : (DirectionSegment)this.visit((ParseTree)ctx.direction()));
    }

    @Override
    public ASTNode visitFetch(OpenGaussStatementParser.FetchContext ctx) {
        return new FetchStatement(this.getDatabaseType(), (CursorNameSegment)this.visit((ParseTree)ctx.cursorName()), null == ctx.direction() ? null : (DirectionSegment)this.visit((ParseTree)ctx.direction()));
    }

    @Override
    public ASTNode visitNext(OpenGaussStatementParser.NextContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.NEXT);
    }

    @Override
    public ASTNode visitPrior(OpenGaussStatementParser.PriorContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.PRIOR);
    }

    @Override
    public ASTNode visitFirst(OpenGaussStatementParser.FirstContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.FIRST);
    }

    @Override
    public ASTNode visitLast(OpenGaussStatementParser.LastContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.LAST);
    }

    @Override
    public ASTNode visitAbsoluteCount(OpenGaussStatementParser.AbsoluteCountContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.ABSOLUTE_COUNT, Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
    }

    @Override
    public ASTNode visitRelativeCount(OpenGaussStatementParser.RelativeCountContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.RELATIVE_COUNT, Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
    }

    @Override
    public ASTNode visitCount(OpenGaussStatementParser.CountContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.COUNT, Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
    }

    @Override
    public ASTNode visitAll(OpenGaussStatementParser.AllContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.ALL);
    }

    @Override
    public ASTNode visitForward(OpenGaussStatementParser.ForwardContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.FORWARD);
    }

    @Override
    public ASTNode visitForwardCount(OpenGaussStatementParser.ForwardCountContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.FORWARD_COUNT, Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
    }

    @Override
    public ASTNode visitForwardAll(OpenGaussStatementParser.ForwardAllContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.FORWARD_ALL);
    }

    @Override
    public ASTNode visitBackward(OpenGaussStatementParser.BackwardContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.BACKWARD);
    }

    @Override
    public ASTNode visitBackwardCount(OpenGaussStatementParser.BackwardCountContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.BACKWARD_COUNT, Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
    }

    @Override
    public ASTNode visitBackwardAll(OpenGaussStatementParser.BackwardAllContext ctx) {
        return new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), DirectionType.BACKWARD_ALL);
    }
}

