/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.postgresql.metadata.database.system;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.DialectSystemDatabase;

public final class PostgreSQLSystemDatabase
implements DialectSystemDatabase {
    private static final Map<String, Collection<String>> SYSTEM_DATABASE_SCHEMA_MAP = new HashMap<String, Collection<String>>();
    private static final Collection<String> SYSTEM_SCHEMAS = Arrays.asList("information_schema", "pg_catalog", "shardingsphere");

    public Collection<String> getSystemDatabases() {
        return SYSTEM_DATABASE_SCHEMA_MAP.keySet();
    }

    public Collection<String> getSystemSchemas(String databaseName) {
        return SYSTEM_DATABASE_SCHEMA_MAP.getOrDefault(databaseName, Collections.emptyList());
    }

    public Collection<String> getSystemSchemas() {
        return SYSTEM_SCHEMAS;
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    static {
        SYSTEM_DATABASE_SCHEMA_MAP.put("postgres", SYSTEM_SCHEMAS);
    }
}

