/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.postgresql.metadata.database.option;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.datatype.DefaultDataTypeOption;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.datatype.DialectDataTypeOption;

public final class PostgreSQLDataTypeOption
implements DialectDataTypeOption {
    private static final Map<String, Integer> EXTRA_DATA_TYPES = PostgreSQLDataTypeOption.setUpExtraDataTypes();
    private final DialectDataTypeOption delegate = new DefaultDataTypeOption();

    private static Map<String, Integer> setUpExtraDataTypes() {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        result.put("SMALLINT", 5);
        result.put("INT", 4);
        result.put("INTEGER", 4);
        result.put("BIGINT", -5);
        result.put("DECIMAL", 3);
        result.put("NUMERIC", 2);
        result.put("REAL", 7);
        result.put("BOOL", 16);
        result.put("CHARACTER VARYING", 12);
        return result;
    }

    public Map<String, Integer> getExtraDataTypes() {
        return EXTRA_DATA_TYPES;
    }

    public Optional<Class<?>> findExtraSQLTypeClass(int dataType, boolean unsigned) {
        if (5 == dataType) {
            return Optional.of(Integer.class);
        }
        return Optional.empty();
    }

    public boolean isIntegerDataType(int sqlType) {
        return this.delegate.isIntegerDataType(sqlType);
    }

    public boolean isStringDataType(int sqlType) {
        return this.delegate.isStringDataType(sqlType);
    }

    public boolean isBinaryDataType(int sqlType) {
        return this.delegate.isBinaryDataType(sqlType);
    }
}

