/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.postgresql.metadata.data.loader;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.DialectMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.type.SchemaMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.ColumnMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.ConstraintMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.IndexMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.datatype.DataTypeRegistry;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.TableType;

public final class PostgreSQLMetaDataLoader
implements DialectMetaDataLoader {
    private static final String BASIC_TABLE_META_DATA_SQL = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default, table_schema, is_nullable FROM information_schema.columns WHERE table_schema IN (%s)";
    private static final String TABLE_META_DATA_SQL_WITHOUT_TABLES = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default, table_schema, is_nullable FROM information_schema.columns WHERE table_schema IN (%s) ORDER BY ordinal_position";
    private static final String TABLE_META_DATA_SQL_WITH_TABLES = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default, table_schema, is_nullable FROM information_schema.columns WHERE table_schema IN (%s) AND table_name IN (%s) ORDER BY ordinal_position";
    private static final String FOREIGN_KEY_META_DATA_SQL = "SELECT tc.table_schema,tc.table_name,tc.constraint_name,pgo.relname refer_table_name FROM information_schema.table_constraints tc JOIN pg_constraint pgc ON tc.constraint_name = pgc.conname AND contype='f' JOIN pg_class pgo ON pgc.confrelid = pgo.oid WHERE tc.constraint_type = 'FOREIGN KEY' AND tc.table_schema IN (%s)";
    private static final String PRIMARY_KEY_META_DATA_SQL = "SELECT tc.table_name, kc.column_name, kc.table_schema FROM information_schema.table_constraints tc JOIN information_schema.key_column_usage kc ON kc.table_schema = tc.table_schema AND kc.table_name = tc.table_name AND kc.constraint_name = tc.constraint_name WHERE tc.constraint_type = 'PRIMARY KEY' AND kc.ordinal_position IS NOT NULL AND kc.table_schema IN (%s)";
    private static final String BASIC_INDEX_META_DATA_SQL = "SELECT tablename, indexname, schemaname FROM pg_indexes WHERE schemaname IN (%s)";
    private static final String ADVANCE_INDEX_META_DATA_SQL = "SELECT idx.relname as index_name, insp.nspname as index_schema, tbl.relname as table_name, att.attname AS column_name, pgi.indisunique as is_unique FROM pg_index pgi JOIN pg_class idx ON idx.oid = pgi.indexrelid JOIN pg_namespace insp ON insp.oid = idx.relnamespace JOIN pg_class tbl ON tbl.oid = pgi.indrelid JOIN pg_namespace tnsp ON tnsp.oid = tbl.relnamespace JOIN pg_attribute att ON att.attrelid = tbl.oid AND att.attnum = ANY(pgi.indkey) WHERE tnsp.nspname IN (%s)";
    private static final String LOAD_ALL_ROLE_TABLE_GRANTS_SQL = "SELECT table_name FROM information_schema.role_table_grants";
    private static final String LOAD_FILTERED_ROLE_TABLE_GRANTS_SQL = "SELECT table_name FROM information_schema.role_table_grants WHERE table_name IN (%s)";
    private static final String VIEW_META_DATA_SQL = "SELECT table_schema, table_name FROM information_schema.views WHERE table_schema IN (%s) and table_name IN (%s)";

    public Collection<SchemaMetaData> load(MetaDataLoaderMaterial material) throws SQLException {
        try (Connection connection = material.getDataSource().getConnection();){
            Collection schemaNames = new SchemaMetaDataLoader(this.getType()).loadSchemaNames(connection);
            Map<String, Multimap<String, IndexMetaData>> schemaIndexMetaDataMap = this.loadIndexMetaDataMap(connection, schemaNames);
            Map<String, Multimap<String, ColumnMetaData>> schemaColumnMetaDataMap = this.loadColumnMetaDataMap(connection, material.getActualTableNames(), schemaNames);
            Map<String, Multimap<String, ConstraintMetaData>> schemaConstraintMetaDataMap = this.loadConstraintMetaDataMap(connection, schemaNames);
            Map<String, Collection<String>> schemaViewNames = this.loadViewNames(connection, schemaNames, material.getActualTableNames());
            LinkedList<SchemaMetaData> result = new LinkedList<SchemaMetaData>();
            for (String each : schemaNames) {
                Multimap<String, IndexMetaData> tableIndexMetaDataMap = schemaIndexMetaDataMap.getOrDefault(each, (Multimap<String, IndexMetaData>)LinkedHashMultimap.create());
                Multimap<String, ColumnMetaData> tableColumnMetaDataMap = schemaColumnMetaDataMap.getOrDefault(each, (Multimap<String, ColumnMetaData>)LinkedHashMultimap.create());
                Multimap<String, ConstraintMetaData> tableConstraintMetaDataMap = schemaConstraintMetaDataMap.getOrDefault(each, (Multimap<String, ConstraintMetaData>)LinkedHashMultimap.create());
                Collection viewNames = schemaViewNames.getOrDefault(each, Collections.emptySet());
                result.add(new SchemaMetaData(each, this.createTableMetaDataList(tableIndexMetaDataMap, tableColumnMetaDataMap, tableConstraintMetaDataMap, viewNames)));
            }
            LinkedList<SchemaMetaData> linkedList = result;
            return linkedList;
        }
    }

    private Map<String, Multimap<String, IndexMetaData>> loadIndexMetaDataMap(Connection connection, Collection<String> schemaNames) throws SQLException {
        String tableName;
        String schemaName;
        ResultSet resultSet;
        LinkedHashMap<String, Multimap<String, IndexMetaData>> result = new LinkedHashMap<String, Multimap<String, IndexMetaData>>(schemaNames.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(schemaNames));){
            resultSet = preparedStatement.executeQuery();
            try {
                while (resultSet.next()) {
                    schemaName = resultSet.getString("schemaname");
                    tableName = resultSet.getString("tablename");
                    String indexName = resultSet.getString("indexname");
                    Multimap indexMetaDataMap = result.computeIfAbsent(schemaName, key -> LinkedHashMultimap.create());
                    indexMetaDataMap.put((Object)tableName, (Object)new IndexMetaData(indexName));
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        preparedStatement = connection.prepareStatement(this.getAdvanceIndexMetaDataSQL(schemaNames));
        try {
            resultSet = preparedStatement.executeQuery();
            try {
                while (resultSet.next()) {
                    Optional<IndexMetaData> indexMetaData;
                    schemaName = resultSet.getString("index_schema");
                    tableName = resultSet.getString("table_name");
                    String columnName = resultSet.getString("column_name");
                    String indexName = resultSet.getString("index_name");
                    boolean isUnique = resultSet.getBoolean("is_unique");
                    Collection indexMetaDataList = result.getOrDefault(schemaName, (Multimap<String, IndexMetaData>)LinkedHashMultimap.create()).get((Object)tableName);
                    if (indexMetaDataList.isEmpty() || !(indexMetaData = indexMetaDataList.stream().filter(each -> each.getName().equals(indexName)).findFirst()).isPresent()) continue;
                    indexMetaData.get().setUnique(isUnique);
                    indexMetaData.get().getColumns().add(columnName);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> schemaNames) {
        return String.format(BASIC_INDEX_META_DATA_SQL, schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private String getAdvanceIndexMetaDataSQL(Collection<String> schemaNames) {
        return String.format(ADVANCE_INDEX_META_DATA_SQL, schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Multimap<String, ColumnMetaData>> loadColumnMetaDataMap(Connection connection, Collection<String> tables, Collection<String> schemaNames) throws SQLException {
        LinkedHashMap<String, Multimap<String, ColumnMetaData>> result = new LinkedHashMap<String, Multimap<String, ColumnMetaData>>(schemaNames.size(), 1.0f);
        Collection<String> roleTableGrants = this.loadRoleTableGrants(connection, tables);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getColumnMetaDataSQL(schemaNames, tables));
             ResultSet resultSet = preparedStatement.executeQuery();){
            Set<String> primaryKeys = this.loadPrimaryKeys(connection, schemaNames);
            while (resultSet.next()) {
                String tableName = resultSet.getString("table_name");
                if (!roleTableGrants.contains(tableName)) continue;
                String schemaName = resultSet.getString("table_schema");
                Multimap columnMetaDataMap = result.computeIfAbsent(schemaName, key -> LinkedHashMultimap.create());
                columnMetaDataMap.put((Object)tableName, (Object)this.loadColumnMetaData(primaryKeys, resultSet));
            }
        }
        return result;
    }

    private Collection<String> loadRoleTableGrants(Connection connection, Collection<String> tables) throws SQLException {
        HashSet<String> result = new HashSet<String>(tables.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getLoadRoleTableGrantsSQL(tables));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result.add(resultSet.getString("table_name"));
            }
        }
        return result;
    }

    private String getLoadRoleTableGrantsSQL(Collection<String> tables) {
        return tables.isEmpty() ? LOAD_ALL_ROLE_TABLE_GRANTS_SQL : String.format(LOAD_FILTERED_ROLE_TABLE_GRANTS_SQL, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private String getColumnMetaDataSQL(Collection<String> schemaNames, Collection<String> tables) {
        String schemaNameParam = schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(","));
        return tables.isEmpty() ? String.format(TABLE_META_DATA_SQL_WITHOUT_TABLES, schemaNameParam) : String.format(TABLE_META_DATA_SQL_WITH_TABLES, schemaNameParam, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Set<String> loadPrimaryKeys(Connection connection, Collection<String> schemaNames) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getPrimaryKeyMetaDataSQL(schemaNames));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String schemaName = resultSet.getString("table_schema");
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                result.add(schemaName + "," + tableName + "," + columnName);
            }
        }
        return result;
    }

    private String getPrimaryKeyMetaDataSQL(Collection<String> schemaNames) {
        return String.format(PRIMARY_KEY_META_DATA_SQL, schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private ColumnMetaData loadColumnMetaData(Collection<String> primaryKeys, ResultSet resultSet) throws SQLException {
        String schemaName = resultSet.getString("table_schema");
        String tableName = resultSet.getString("table_name");
        String columnName = resultSet.getString("column_name");
        String dataType = resultSet.getString("udt_name");
        boolean isPrimaryKey = primaryKeys.contains(schemaName + "," + tableName + "," + columnName);
        String columnDefault = resultSet.getString("column_default");
        boolean generated = null != columnDefault && columnDefault.startsWith("nextval(");
        boolean caseSensitive = true;
        boolean isNullable = "YES".equals(resultSet.getString("is_nullable"));
        return new ColumnMetaData(columnName, DataTypeRegistry.getDataType((String)this.getDatabaseType(), (String)dataType).orElse(1111).intValue(), isPrimaryKey, generated, caseSensitive, true, false, isNullable);
    }

    private Map<String, Multimap<String, ConstraintMetaData>> loadConstraintMetaDataMap(Connection connection, Collection<String> schemaNames) throws SQLException {
        LinkedHashMap<String, Multimap<String, ConstraintMetaData>> result = new LinkedHashMap<String, Multimap<String, ConstraintMetaData>>(schemaNames.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getConstraintKeyMetaDataSQL(schemaNames));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String schemaName = resultSet.getString("table_schema");
                Multimap constraintMetaData = result.computeIfAbsent(schemaName, key -> LinkedHashMultimap.create());
                String tableName = resultSet.getString("table_name");
                String constraintName = resultSet.getString("constraint_name");
                String referencedTableName = resultSet.getString("refer_table_name");
                constraintMetaData.put((Object)tableName, (Object)new ConstraintMetaData(constraintName, referencedTableName));
            }
        }
        return result;
    }

    private String getConstraintKeyMetaDataSQL(Collection<String> schemaNames) {
        return String.format(FOREIGN_KEY_META_DATA_SQL, schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<String>> loadViewNames(Connection connection, Collection<String> schemaNames, Collection<String> tables) throws SQLException {
        LinkedHashMap<String, Collection<String>> result = new LinkedHashMap<String, Collection<String>>(schemaNames.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getViewMetaDataSQL(schemaNames, tables));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String schemaName = resultSet.getString("table_schema");
                Collection viewMetaData = result.computeIfAbsent(schemaName, key -> new HashSet());
                String tableName = resultSet.getString("table_name");
                viewMetaData.add(tableName);
            }
        }
        return result;
    }

    private String getViewMetaDataSQL(Collection<String> schemaNames, Collection<String> tables) {
        return String.format(VIEW_META_DATA_SQL, schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")), tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Collection<TableMetaData> createTableMetaDataList(Multimap<String, IndexMetaData> tableIndexMetaDataMap, Multimap<String, ColumnMetaData> tableColumnMetaDataMap, Multimap<String, ConstraintMetaData> tableConstraintMetaDataMap, Collection<String> viewNames) {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        for (String each : tableColumnMetaDataMap.keySet()) {
            Collection columnMetaDataList = tableColumnMetaDataMap.get((Object)each);
            Collection indexMetaDataList = tableIndexMetaDataMap.get((Object)each);
            Collection constraintMetaDataList = tableConstraintMetaDataMap.get((Object)each);
            result.add(new TableMetaData(each, columnMetaDataList, indexMetaDataList, constraintMetaDataList, viewNames.contains(each) ? TableType.VIEW : TableType.TABLE));
        }
        return result;
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

