/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.standalone.memory;

import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;

public final class MemoryRepository
implements StandalonePersistRepository {
    private final TreeMap<String, String> metaDataSortedMap = new TreeMap();

    public String query(String key) {
        return this.metaDataSortedMap.get(key);
    }

    public List<String> getChildrenKeys(String key) {
        String searchPrefix = key.endsWith("/") ? key : key + "/";
        String endBound = key + '\uffff';
        return this.metaDataSortedMap.subMap(searchPrefix, true, endBound, false).keySet().stream().map(each -> {
            String remainder = each.substring(searchPrefix.length());
            int nextSlashIndex = remainder.indexOf(47);
            if (nextSlashIndex == -1) {
                return remainder;
            }
            return remainder.substring(0, nextSlashIndex);
        }).filter(node -> !node.isEmpty()).distinct().collect(Collectors.toList());
    }

    public boolean isExisted(String key) {
        return this.metaDataSortedMap.containsKey(key);
    }

    public void persist(String key, String value) {
        this.metaDataSortedMap.put(key, value);
    }

    public void update(String key, String value) {
        if (this.metaDataSortedMap.containsKey(key)) {
            this.metaDataSortedMap.put(key, value);
        }
    }

    public void delete(String key) {
        this.metaDataSortedMap.remove(key);
    }

    public void close() {
    }

    public Object getType() {
        return "Memory";
    }

    public boolean isDefault() {
        return true;
    }
}

