/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.resultset;

import java.math.BigInteger;
import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sqlfederation.compiler.sql.type.SQLFederationDataTypeFactory;
import org.apache.shardingsphere.sqlfederation.resultset.SQLFederationWrapperAdapter;
import org.apache.shardingsphere.sqlfederation.resultset.converter.DialectSQLFederationColumnTypeConverter;

public final class SQLFederationResultSetMetaData
extends SQLFederationWrapperAdapter
implements ResultSetMetaData {
    private final Schema sqlFederationSchema;
    private final RelDataTypeFactory typeFactory;
    private final List<Projection> expandProjections;
    private final DatabaseType databaseType;
    private final RelDataType resultColumnType;
    private final Map<Integer, String> indexAndColumnLabels;
    private final DialectSQLFederationColumnTypeConverter columnTypeConverter;

    public SQLFederationResultSetMetaData(Schema sqlFederationSchema, List<Projection> expandProjections, DatabaseType databaseType, RelDataType resultColumnType, Map<Integer, String> indexAndColumnLabels, DialectSQLFederationColumnTypeConverter columnTypeConverter) {
        this.sqlFederationSchema = sqlFederationSchema;
        this.typeFactory = SQLFederationDataTypeFactory.getInstance();
        this.expandProjections = expandProjections;
        this.databaseType = databaseType;
        this.resultColumnType = resultColumnType;
        this.indexAndColumnLabels = indexAndColumnLabels;
        this.columnTypeConverter = columnTypeConverter;
    }

    @Override
    public int getColumnCount() {
        return this.indexAndColumnLabels.size();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return false;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable((Table)this.sqlFederationSchema.tables().get(optional)));
        return !table.isPresent() || ((Table)table.get()).getRowType(this.typeFactory).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return this.findTableName(column).flatMap(optional -> Optional.ofNullable((Table)this.sqlFederationSchema.tables().get(optional))).map(optional -> optional.getRowType(this.typeFactory).getPrecision()).orElse(0);
    }

    @Override
    public String getColumnLabel(int column) {
        return this.indexAndColumnLabels.size() < column ? ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getName() : this.indexAndColumnLabels.get(column);
    }

    @Override
    public String getColumnName(int column) {
        return this.expandProjections.size() < column ? ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getName() : this.expandProjections.get(column - 1).getColumnName();
    }

    @Override
    public String getSchemaName(int column) {
        return "logic_db";
    }

    @Override
    public int getPrecision(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable((Table)this.sqlFederationSchema.tables().get(optional)));
        return !table.isPresent() || -1 == ((Table)table.get()).getRowType(this.typeFactory).getPrecision() ? 0 : ((Table)table.get()).getRowType(this.typeFactory).getPrecision();
    }

    @Override
    public int getScale(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable((Table)this.sqlFederationSchema.tables().get(optional)));
        return !table.isPresent() || Integer.MIN_VALUE == ((Table)table.get()).getRowType(this.typeFactory).getScale() ? 0 : ((Table)table.get()).getRowType(this.typeFactory).getScale();
    }

    @Override
    public String getTableName(int column) {
        return this.findTableName(column).orElse("");
    }

    @Override
    public String getCatalogName(int column) {
        return "logic_db";
    }

    @Override
    public int getColumnType(int column) {
        RelDataType relDataType = ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getType();
        if (relDataType instanceof RelDataTypeFactoryImpl.JavaType && BigInteger.class.isAssignableFrom(((RelDataTypeFactoryImpl.JavaType)relDataType).getJavaClass())) {
            return SqlType.BIGINT.id;
        }
        return null == this.columnTypeConverter ? relDataType.getSqlTypeName().getJdbcOrdinal() : this.columnTypeConverter.convertColumnType(relDataType.getSqlTypeName());
    }

    @Override
    public String getColumnTypeName(int column) {
        SqlTypeName originalSqlTypeName = ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getType().getSqlTypeName();
        SqlTypeName convertSqlTypeName = SqlTypeName.getNameForJdbcType((int)(null == this.columnTypeConverter ? originalSqlTypeName.getJdbcOrdinal() : this.columnTypeConverter.convertColumnType(originalSqlTypeName)));
        return null == convertSqlTypeName ? originalSqlTypeName.getName() : convertSqlTypeName.getName();
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getType().getSqlTypeName().getClass().getName();
    }

    private Optional<String> findTableName(int column) {
        ColumnProjection projection = this.expandProjections.size() < column ? new ColumnProjection(null, ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getName(), null, this.databaseType) : this.expandProjections.get(column - 1);
        return projection instanceof ColumnProjection ? Optional.ofNullable(projection.getOriginalTable().getValue()) : Optional.empty();
    }
}

