/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingMatchedEncryptQueryAlgorithmException;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionValues;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateEqualRightValueToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateFunctionRightValueToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateInRightValueToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;

public final class EncryptPredicateValueTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
ParametersAware {
    private final EncryptRule rule;
    private final ShardingSphereDatabase database;
    private final Collection<EncryptCondition> encryptConditions;
    private List<Object> parameters;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereContextAvailable && !this.encryptConditions.isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>(this.encryptConditions.size(), 1.0f);
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(this.database.getName()));
        for (EncryptCondition each : this.encryptConditions) {
            Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(each.getTableName());
            encryptTable.flatMap(optional -> this.generateSQLToken(schemaName, (EncryptTable)optional, each)).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SQLToken> generateSQLToken(String schemaName, EncryptTable encryptTable, EncryptCondition encryptCondition) {
        int startIndex = encryptCondition.getStartIndex();
        int stopIndex = encryptCondition.getStopIndex();
        Map<Integer, Object> indexValues = this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), this.getEncryptedValues(schemaName, encryptTable, encryptCondition, new EncryptConditionValues(encryptCondition).get(this.parameters)));
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        if (encryptCondition instanceof EncryptBinaryCondition && ((EncryptBinaryCondition)encryptCondition).getExpressionSegment() instanceof FunctionSegment) {
            FunctionSegment functionSegment = (FunctionSegment)((EncryptBinaryCondition)encryptCondition).getExpressionSegment();
            return Optional.of(new EncryptPredicateFunctionRightValueToken(startIndex, stopIndex, functionSegment.getFunctionName(), functionSegment.getParameters(), indexValues, parameterMarkerIndexes));
        }
        return encryptCondition instanceof EncryptInCondition ? Optional.of(new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes)) : Optional.of(new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes));
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptTable encryptTable, EncryptCondition encryptCondition, List<Object> originalValues) {
        String columnName = encryptCondition.getColumnSegment().getColumnBoundInfo().getOriginalColumn().getValue();
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        String tableName = encryptCondition.getColumnSegment().getColumnBoundInfo().getOriginalTable().getValue();
        if (encryptCondition instanceof EncryptBinaryCondition && ("LIKE".equalsIgnoreCase(((EncryptBinaryCondition)encryptCondition).getOperator()) || "NOT LIKE".equalsIgnoreCase(((EncryptBinaryCondition)encryptCondition).getOperator()))) {
            return this.getLikeQueryEncryptedValues(schemaName, encryptCondition, originalValues, encryptColumn, tableName, columnName);
        }
        return encryptColumn.getAssistedQuery().map(optional -> optional.encrypt(this.database.getName(), schemaName, tableName, encryptCondition.getColumnSegment().getIdentifier().getValue(), originalValues)).orElseGet(() -> encryptColumn.getCipher().encrypt(this.database.getName(), schemaName, tableName, encryptCondition.getColumnSegment().getIdentifier().getValue(), originalValues));
    }

    private List<Object> getLikeQueryEncryptedValues(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues, EncryptColumn encryptColumn, String tableName, String columnName) {
        ShardingSpherePreconditions.checkState((encryptColumn.getLikeQuery().isPresent() || encryptColumn.getCipher().getEncryptor().getMetaData().isSupportLike() ? 1 : 0) != 0, () -> new MissingMatchedEncryptQueryAlgorithmException(tableName, columnName, "LIKE"));
        if (encryptColumn.getLikeQuery().isPresent()) {
            return encryptColumn.getLikeQuery().get().encrypt(this.database.getName(), schemaName, encryptCondition.getTableName(), columnName, originalValues);
        }
        return encryptColumn.getCipher().encrypt(this.database.getName(), schemaName, tableName, columnName, originalValues);
    }

    private Map<Integer, Object> getPositionValues(Collection<Integer> valuePositions, List<Object> encryptValues) {
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>(valuePositions.size(), 1.0f);
        for (int each : valuePositions) {
            result.put(each, encryptValues.get(each));
        }
        return result;
    }

    @Generated
    public EncryptPredicateValueTokenGenerator(EncryptRule rule, ShardingSphereDatabase database, Collection<EncryptCondition> encryptConditions) {
        this.rule = rule;
        this.database = database;
        this.encryptConditions = encryptConditions;
    }

    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }
}

