/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.enums.EncryptDerivedColumnSuffix;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingMatchedEncryptQueryAlgorithmException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptPredicateColumnTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext> {
    private final EncryptRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereContextAvailable;
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Collection allSubqueryContexts = SQLStatementContextExtractor.getAllSubqueryContexts((SQLStatementContext)sqlStatementContext);
        Collection whereSegments = SQLStatementContextExtractor.getWhereSegments((WhereContextAvailable)((WhereContextAvailable)sqlStatementContext), (Collection)allSubqueryContexts);
        Collection<ExpressionSegment> expressions = this.getAllExpressions(whereSegments);
        return this.generateSQLTokens(expressions, sqlStatementContext.getSqlStatement());
    }

    private Collection<SQLToken> generateSQLTokens(Collection<ExpressionSegment> expressions, SQLStatement sqlStatement) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ExpressionSegment each : expressions) {
            result.addAll(this.generateSQLTokens(sqlStatement, each));
        }
        return result;
    }

    private Collection<SQLToken> generateSQLTokens(SQLStatement sqlStatement, ExpressionSegment expression) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : ColumnExtractor.extract((ExpressionSegment)expression)) {
            Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(each.getColumnBoundInfo().getOriginalTable().getValue());
            if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(each.getColumnBoundInfo().getOriginalColumn().getValue())) continue;
            EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(each.getColumnBoundInfo().getOriginalColumn().getValue());
            result.addAll(this.buildSubstitutableColumnNameTokens(encryptColumn, each, expression, sqlStatement.getDatabaseType(), encryptTable.get().getTable()));
        }
        return result;
    }

    private Collection<ExpressionSegment> getAllExpressions(Collection<WhereSegment> whereSegments) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : whereSegments) {
            Collection expressions = ExpressionExtractor.extractAllExpressions((ExpressionSegment)each.getExpr());
            result.addAll(expressions);
        }
        return result;
    }

    private Collection<SQLToken> buildSubstitutableColumnNameTokens(EncryptColumn encryptColumn, ColumnSegment columnSegment, ExpressionSegment expression, DatabaseType databaseType, String tableName) {
        int startIndex = columnSegment.getOwner().isPresent() ? ((OwnerSegment)columnSegment.getOwner().get()).getStopIndex() + 2 : columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        if (this.isIncludeLike(expression)) {
            return this.generateEncryptLikeTokens(encryptColumn, columnSegment, databaseType, tableName, startIndex, stopIndex);
        }
        Collection columnProjections = encryptColumn.getAssistedQuery().map(optional -> this.createColumnProjections(optional.getName(), columnSegment, EncryptDerivedColumnSuffix.ASSISTED_QUERY, databaseType)).orElseGet(() -> this.createColumnProjections(encryptColumn.getCipher().getName(), columnSegment, EncryptDerivedColumnSuffix.CIPHER, databaseType));
        return Collections.singleton(new SubstitutableColumnNameToken(startIndex, stopIndex, columnProjections, databaseType));
    }

    private Collection<SQLToken> generateEncryptLikeTokens(EncryptColumn encryptColumn, ColumnSegment columnSegment, DatabaseType databaseType, String tableName, int startIndex, int stopIndex) {
        ShardingSpherePreconditions.checkState((encryptColumn.getLikeQuery().isPresent() || encryptColumn.getCipher().getEncryptor().getMetaData().isSupportLike() ? 1 : 0) != 0, () -> new MissingMatchedEncryptQueryAlgorithmException(tableName, columnSegment.getIdentifier().getValue(), "LIKE"));
        return Collections.singleton(new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(encryptColumn.getLikeQuery().map(LikeQueryColumnItem::getName).orElseGet(() -> encryptColumn.getCipher().getName()), columnSegment, EncryptDerivedColumnSuffix.LIKE_QUERY, databaseType), databaseType));
    }

    private boolean isIncludeLike(ExpressionSegment expression) {
        return expression instanceof BinaryOperationExpression && ("LIKE".equalsIgnoreCase(((BinaryOperationExpression)expression).getOperator()) || "NOT LIKE".equalsIgnoreCase(((BinaryOperationExpression)expression).getOperator()));
    }

    private Collection<Projection> createColumnProjections(String actualColumnName, ColumnSegment columnSegment, EncryptDerivedColumnSuffix derivedColumnSuffix, DatabaseType databaseType) {
        String columnName = TableSourceType.TEMPORARY_TABLE == columnSegment.getColumnBoundInfo().getTableSourceType() ? derivedColumnSuffix.getDerivedColumnName(columnSegment.getIdentifier().getValue(), databaseType) : actualColumnName;
        QuoteCharacter quoteCharacter = TableSourceType.TEMPORARY_TABLE == columnSegment.getColumnBoundInfo().getTableSourceType() ? columnSegment.getIdentifier().getQuoteCharacter() : new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getQuoteCharacter();
        ColumnProjection columnProjection = new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, databaseType);
        return Collections.singleton(columnProjection);
    }

    @Generated
    public EncryptPredicateColumnTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }
}

