/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.insert;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.InsertColumnsToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;

public final class EncryptInsertDerivedColumnsTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    private final EncryptRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatementContext)sqlStatementContext).containsInsertColumns();
    }

    public Collection<SQLToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(insertStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse(""));
        if (!encryptTable.isPresent()) {
            return Collections.emptyList();
        }
        QuoteCharacter quoteCharacter = new DatabaseTypeRegistry(insertStatementContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData().getQuoteCharacter();
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : insertStatementContext.getSqlStatement().getColumns()) {
            List<String> derivedColumnNames = this.getDerivedColumnNames(encryptTable.get(), each);
            if (derivedColumnNames.isEmpty()) continue;
            result.add((SQLToken)new InsertColumnsToken(each.getStopIndex() + 1, derivedColumnNames, quoteCharacter));
        }
        return result;
    }

    private List<String> getDerivedColumnNames(EncryptTable encryptTable, ColumnSegment columnSegment) {
        String columnName = columnSegment.getIdentifier().getValue();
        if (!encryptTable.isEncryptColumn(columnName)) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add(optional.getName()));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add(optional.getName()));
        return result;
    }

    @Generated
    public EncryptInsertDerivedColumnsTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }
}

