/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.insert;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.checker.cryptographic.InsertSelectColumnsEncryptorChecker;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptInsertCipherNameTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    private final EncryptRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof InsertStatementContext)) {
            return false;
        }
        Optional insertColumnsSegment = ((InsertStatementContext)sqlStatementContext).getSqlStatement().getInsertColumns();
        return insertColumnsSegment.isPresent() && !((InsertColumnsSegment)insertColumnsSegment.get()).getColumns().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        Optional<EncryptTable> encryptTable;
        Optional insertColumnsSegment = insertStatementContext.getSqlStatement().getInsertColumns();
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        Collection insertColumns = ((InsertColumnsSegment)insertColumnsSegment.get()).getColumns();
        if (null != insertStatementContext.getInsertSelectContext()) {
            this.checkInsertSelectEncryptor(insertStatementContext.getInsertSelectContext().getSelectStatementContext(), insertColumns);
        }
        if (!(encryptTable = this.rule.findEncryptTable(insertStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse(""))).isPresent()) {
            return Collections.emptyList();
        }
        DatabaseType databaseType = insertStatementContext.getSqlStatement().getDatabaseType();
        QuoteCharacter quoteCharacter = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getQuoteCharacter();
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : insertColumns) {
            String columnName = each.getIdentifier().getValue();
            if (!encryptTable.get().isEncryptColumn(columnName)) continue;
            IdentifierValue name = new IdentifierValue(encryptTable.get().getEncryptColumn(columnName).getCipher().getName(), quoteCharacter);
            Set<ColumnProjection> projections = Collections.singleton(new ColumnProjection(null, name, null, databaseType));
            result.add((SQLToken)new SubstitutableColumnNameToken(each.getStartIndex(), each.getStopIndex(), projections, databaseType));
        }
        return result;
    }

    private void checkInsertSelectEncryptor(SelectStatementContext selectStatementContext, Collection<ColumnSegment> insertColumns) {
        List projections = selectStatementContext.getProjectionsContext().getExpandProjections();
        ShardingSpherePreconditions.checkState((insertColumns.size() == projections.size() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Column count doesn't match value count."));
        InsertSelectColumnsEncryptorChecker.checkIsSame(insertColumns, projections, this.rule);
    }

    @Generated
    public EncryptInsertCipherNameTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }
}

