/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.CipherColumnItem;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.ColumnDefinitionToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstituteColumnDefinitionToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;

public final class EncryptCreateTableTokenGenerator
implements CollectionSQLTokenGenerator<CommonSQLStatementContext> {
    private final EncryptRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof CreateTableStatement && !((CreateTableStatement)sqlStatementContext.getSqlStatement()).getColumnDefinitions().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(CommonSQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        CreateTableStatement sqlStatement = (CreateTableStatement)sqlStatementContext.getSqlStatement();
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        EncryptTable encryptTable = this.rule.getEncryptTable(tableName);
        ArrayList<ColumnDefinitionSegment> columns = new ArrayList<ColumnDefinitionSegment>(sqlStatement.getColumnDefinitions());
        for (int index = 0; index < columns.size(); ++index) {
            ColumnDefinitionSegment each = (ColumnDefinitionSegment)columns.get(index);
            String columnName = each.getColumnName().getIdentifier().getValue();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            result.add(this.getSubstituteColumnToken(encryptTable.getEncryptColumn(columnName), each, columns, index));
        }
        return result;
    }

    private SQLToken getSubstituteColumnToken(EncryptColumn encryptColumn, ColumnDefinitionSegment column, List<ColumnDefinitionSegment> columns, int index) {
        LinkedList<SQLToken> columnDefinitionTokens = new LinkedList<SQLToken>();
        columnDefinitionTokens.add(this.getCipherColumnToken(encryptColumn, column));
        this.getAssistedQueryColumnToken(encryptColumn, column).ifPresent(columnDefinitionTokens::add);
        this.getLikeQueryColumnToken(encryptColumn, column).ifPresent(columnDefinitionTokens::add);
        boolean lastColumn = columns.size() - 1 == index;
        int columnStopIndex = lastColumn ? column.getStopIndex() : columns.get(index + 1).getStartIndex() - 1;
        return new SubstituteColumnDefinitionToken(column.getStartIndex(), columnStopIndex, lastColumn, columnDefinitionTokens);
    }

    private SQLToken getCipherColumnToken(EncryptColumn encryptColumn, ColumnDefinitionSegment column) {
        CipherColumnItem cipherColumnItem = encryptColumn.getCipher();
        return new ColumnDefinitionToken(cipherColumnItem.getName(), "VARCHAR(4000)", column.getStartIndex());
    }

    private Optional<? extends SQLToken> getAssistedQueryColumnToken(EncryptColumn encryptColumn, ColumnDefinitionSegment column) {
        return encryptColumn.getAssistedQuery().map(optional -> new ColumnDefinitionToken(encryptColumn.getAssistedQuery().get().getName(), "VARCHAR(4000)", column.getStartIndex()));
    }

    private Optional<? extends SQLToken> getLikeQueryColumnToken(EncryptColumn encryptColumn, ColumnDefinitionSegment column) {
        return encryptColumn.getLikeQuery().map(optional -> new ColumnDefinitionToken(encryptColumn.getLikeQuery().get().getName(), "VARCHAR(4000)", column.getStartIndex()));
    }

    @Generated
    public EncryptCreateTableTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }
}

