/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment.EncryptAssignmentTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class EncryptInsertAssignmentTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    private final EncryptRule rule;
    private final ShardingSphereDatabase database;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatementContext)sqlStatementContext).getSqlStatement().getSetAssignment().isPresent() && this.containsEncryptTable(sqlStatementContext.getTablesContext().getSimpleTables());
    }

    private boolean containsEncryptTable(Collection<SimpleTableSegment> simpleTableSegments) {
        for (SimpleTableSegment each : simpleTableSegments) {
            if (!this.rule.findEncryptTable(each.getTableName().getIdentifier().getValue()).isPresent()) continue;
            return true;
        }
        return false;
    }

    public Collection<SQLToken> generateSQLTokens(InsertStatementContext sqlStatementContext) {
        return new EncryptAssignmentTokenGenerator(this.rule, this.database.getName(), sqlStatementContext.getSqlStatement().getDatabaseType()).generateSQLTokens(sqlStatementContext.getTablesContext(), (SetAssignmentSegment)sqlStatementContext.getSqlStatement().getSetAssignment().get());
    }

    @Generated
    public EncryptInsertAssignmentTokenGenerator(EncryptRule rule, ShardingSphereDatabase database) {
        this.rule = rule;
        this.database = database;
    }
}

