/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.enums.EncryptDerivedColumnSuffix;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;

public final class EncryptAssignmentTokenGenerator {
    private final EncryptRule rule;
    private final String databaseName;
    private final DatabaseType databaseType;

    public Collection<SQLToken> generateSQLTokens(TablesContext tablesContext, SetAssignmentSegment setAssignmentSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        String schemaName = tablesContext.getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(this.databaseType).getDefaultSchemaName(this.databaseName));
        QuoteCharacter quoteCharacter = new DatabaseTypeRegistry(this.databaseType).getDialectDatabaseMetaData().getQuoteCharacter();
        for (ColumnAssignmentSegment each : setAssignmentSegment.getAssignments()) {
            ColumnSegment columnSegment = (ColumnSegment)each.getColumns().get(0);
            Optional<EncryptTable> encryptTable = this.findEncryptTable(columnSegment);
            if (encryptTable.isPresent() && encryptTable.get().isEncryptColumn(columnSegment.getIdentifier().getValue())) {
                this.generateSQLToken(schemaName, encryptTable.get().getTable(), encryptTable.get().getEncryptColumn(columnSegment.getIdentifier().getValue()), each, quoteCharacter).ifPresent(result::add);
                continue;
            }
            if (!(each.getValue() instanceof ColumnSegment) || !this.isEncryptColumn((ColumnSegment)each.getValue())) continue;
            throw new UnsupportedSQLOperationException("Can not use different encryptor for " + columnSegment.getColumnBoundInfo() + " and " + ((ColumnSegment)each.getValue()).getColumnBoundInfo() + " in set clause");
        }
        return result;
    }

    private boolean isEncryptColumn(ColumnSegment columnSegment) {
        ColumnSegmentBoundInfo columnBoundInfo = columnSegment.getColumnBoundInfo();
        String originalTable = columnBoundInfo.getOriginalTable().getValue();
        String originalColumn = columnBoundInfo.getOriginalColumn().getValue();
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(originalTable);
        return encryptTable.isPresent() && encryptTable.get().isEncryptColumn(originalColumn);
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, QuoteCharacter quoteCharacter) {
        if (segment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.generateParameterSQLToken(encryptColumn, segment, quoteCharacter));
        }
        if (segment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of(this.generateLiteralSQLToken(schemaName, tableName, encryptColumn, segment, quoteCharacter));
        }
        return Optional.empty();
    }

    private EncryptAssignmentToken generateParameterSQLToken(EncryptColumn encryptColumn, ColumnAssignmentSegment segment, QuoteCharacter quoteCharacter) {
        ColumnSegment columnSegment = (ColumnSegment)segment.getColumns().get(0);
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(columnSegment.getStartIndex(), segment.getStopIndex(), quoteCharacter);
        result.addColumnName(this.getColumnName(columnSegment, EncryptDerivedColumnSuffix.CIPHER, encryptColumn.getCipher().getName()));
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.addColumnName(this.getColumnName(columnSegment, EncryptDerivedColumnSuffix.ASSISTED_QUERY, optional.getName())));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.addColumnName(this.getColumnName(columnSegment, EncryptDerivedColumnSuffix.LIKE_QUERY, optional.getName())));
        return result;
    }

    private String getColumnName(ColumnSegment columnSegment, EncryptDerivedColumnSuffix derivedColumnSuffix, String actualColumnName) {
        return TableSourceType.TEMPORARY_TABLE == columnSegment.getColumnBoundInfo().getTableSourceType() ? derivedColumnSuffix.getDerivedColumnName(columnSegment.getIdentifier().getValue(), this.databaseType) : actualColumnName;
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, QuoteCharacter quoteCharacter) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(((ColumnSegment)segment.getColumns().get(0)).getStartIndex(), segment.getStopIndex(), quoteCharacter);
        this.addCipherAssignment(schemaName, tableName, encryptColumn, segment, result);
        this.addAssistedQueryAssignment(schemaName, tableName, encryptColumn, segment, result);
        this.addLikeAssignment(schemaName, tableName, encryptColumn, segment, result);
        return result;
    }

    private void addCipherAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        Object cipherValue = encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(this.getColumnName((ColumnSegment)segment.getColumns().get(0), EncryptDerivedColumnSuffix.CIPHER, encryptColumn.getCipher().getName()), cipherValue);
    }

    private void addAssistedQueryAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        if (encryptColumn.getAssistedQuery().isPresent()) {
            Object assistedQueryValue = encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(this.getColumnName((ColumnSegment)segment.getColumns().get(0), EncryptDerivedColumnSuffix.ASSISTED_QUERY, encryptColumn.getAssistedQuery().get().getName()), assistedQueryValue);
        }
    }

    private void addLikeAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        if (encryptColumn.getLikeQuery().isPresent()) {
            Object assistedQueryValue = encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, ((ColumnSegment)segment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(this.getColumnName((ColumnSegment)segment.getColumns().get(0), EncryptDerivedColumnSuffix.LIKE_QUERY, encryptColumn.getLikeQuery().get().getName()), assistedQueryValue);
        }
    }

    private Optional<EncryptTable> findEncryptTable(ColumnSegment columnSegment) {
        return this.rule.findEncryptTable(columnSegment.getColumnBoundInfo().getOriginalTable().getValue());
    }

    @Generated
    public EncryptAssignmentTokenGenerator(EncryptRule rule, String databaseName, DatabaseType databaseType) {
        this.rule = rule;
        this.databaseName = databaseName;
        this.databaseType = databaseType;
    }
}

