/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingMatchedEncryptQueryAlgorithmException;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionValues;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;

public final class EncryptPredicateParameterRewriter
implements ParameterRewriter {
    private final EncryptRule rule;
    private final String databaseName;
    private final Collection<EncryptCondition> encryptConditions;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereContextAvailable && !this.encryptConditions.isEmpty();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (EncryptCondition each : this.encryptConditions) {
            this.encryptParameters(paramBuilder, each.getPositionIndexMap(), this.getEncryptedValues(schemaName, each, new EncryptConditionValues(each).get(params)));
        }
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues) {
        String tableName = encryptCondition.getColumnSegment().getColumnBoundInfo().getOriginalTable().getValue();
        String columnName = encryptCondition.getColumnSegment().getColumnBoundInfo().getOriginalColumn().getValue();
        EncryptTable encryptTable = this.rule.getEncryptTable(tableName);
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        if (encryptCondition instanceof EncryptBinaryCondition && this.containsLikeOperator((EncryptBinaryCondition)encryptCondition)) {
            return this.getEncryptedLikeValues(schemaName, originalValues, encryptColumn, tableName, columnName);
        }
        return encryptColumn.getAssistedQuery().isPresent() ? encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues) : encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues);
    }

    private List<Object> getEncryptedLikeValues(String schemaName, List<Object> originalValues, EncryptColumn encryptColumn, String tableName, String columnName) {
        ShardingSpherePreconditions.checkState((encryptColumn.getLikeQuery().isPresent() || encryptColumn.getCipher().getEncryptor().getMetaData().isSupportLike() ? 1 : 0) != 0, () -> new MissingMatchedEncryptQueryAlgorithmException(tableName, columnName, "LIKE"));
        return encryptColumn.getLikeQuery().map(likeQueryColumnItem -> likeQueryColumnItem.encrypt(this.databaseName, schemaName, tableName, columnName, originalValues)).orElseGet(() -> encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues));
    }

    private boolean containsLikeOperator(EncryptBinaryCondition encryptCondition) {
        return "LIKE".equalsIgnoreCase(encryptCondition.getOperator()) || "NOT LIKE".equalsIgnoreCase(encryptCondition.getOperator());
    }

    private void encryptParameters(ParameterBuilder paramBuilder, Map<Integer, Integer> positionIndexes, List<Object> encryptValues) {
        if (!positionIndexes.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : positionIndexes.entrySet()) {
                ((StandardParameterBuilder)paramBuilder).addReplacedParameters(entry.getValue().intValue(), encryptValues.get(entry.getKey()));
            }
        }
    }

    @Generated
    public EncryptPredicateParameterRewriter(EncryptRule rule, String databaseName, Collection<EncryptCondition> encryptConditions) {
        this.rule = rule;
        this.databaseName = databaseName;
        this.encryptConditions = encryptConditions;
    }
}

