/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.constant.EncryptConstants;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.statement.core.enums.LogicalOperator;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;

public final class EncryptConditionEngine {
    private final EncryptRule rule;

    public Collection<EncryptCondition> createEncryptConditions(Collection<WhereSegment> whereSegments) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        for (WhereSegment each : whereSegments) {
            Collection expressions = ExpressionExtractor.extractAllExpressions((ExpressionSegment)each.getExpr());
            this.addEncryptConditions(result, expressions);
        }
        return result;
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, Collection<ExpressionSegment> predicates) {
        HashSet<Integer> stopIndexes = new HashSet<Integer>(predicates.size(), 1.0f);
        for (ExpressionSegment each : predicates) {
            if (!stopIndexes.add(each.getStopIndex())) continue;
            this.addEncryptConditions(encryptConditions, each);
        }
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, ExpressionSegment expression) {
        if (!this.findNotContainsNullLiteralsExpression(expression).isPresent()) {
            return;
        }
        for (ColumnSegment each : ColumnExtractor.extract((ExpressionSegment)expression)) {
            String tableName = each.getColumnBoundInfo().getOriginalTable().getValue();
            Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(tableName);
            if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(each.getColumnBoundInfo().getOriginalColumn().getValue())) continue;
            encryptConditions.addAll(this.createEncryptCondition(expression, tableName));
        }
    }

    private Optional<ExpressionSegment> findNotContainsNullLiteralsExpression(ExpressionSegment expression) {
        if (this.isContainsNullLiterals(expression)) {
            return Optional.empty();
        }
        if (expression instanceof BinaryOperationExpression && this.isContainsNullLiterals(((BinaryOperationExpression)expression).getRight())) {
            return Optional.empty();
        }
        return Optional.ofNullable(expression);
    }

    private boolean isContainsNullLiterals(ExpressionSegment expression) {
        if (!(expression instanceof LiteralExpressionSegment)) {
            return false;
        }
        String literals = String.valueOf(((LiteralExpressionSegment)expression).getLiterals());
        return "NULL".equalsIgnoreCase(literals) || "NOT NULL".equalsIgnoreCase(literals);
    }

    private Collection<EncryptCondition> createEncryptCondition(ExpressionSegment expression, String tableName) {
        if (expression instanceof BinaryOperationExpression) {
            return this.createBinaryEncryptCondition((BinaryOperationExpression)expression, tableName);
        }
        if (expression instanceof InExpression) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, (InExpression)expression, ((InExpression)expression).getRight());
        }
        if (expression instanceof BetweenExpression) {
            throw new UnsupportedEncryptSQLException("BETWEEN...AND...");
        }
        return Collections.emptyList();
    }

    private Collection<EncryptCondition> createBinaryEncryptCondition(BinaryOperationExpression expression, String tableName) {
        String operator = expression.getOperator();
        if (LogicalOperator.valueFrom((String)operator).isPresent()) {
            return Collections.emptyList();
        }
        ShardingSpherePreconditions.checkContains(EncryptConstants.SUPPORTED_BINARY_OPERATORS, (Object)operator, () -> new UnsupportedEncryptSQLException(operator));
        return this.createCompareEncryptCondition(tableName, expression);
    }

    private Collection<EncryptCondition> createCompareEncryptCondition(String tableName, BinaryOperationExpression expression) {
        if (this.isLeftRightContainsSubquerySegment(expression)) {
            return Collections.emptyList();
        }
        Optional<ColumnSegment> columnSegment = Optional.ofNullable(this.isCompareValueSegment(expression.getLeft()) ? expression.getRight() : expression.getLeft()).filter(ColumnSegment.class::isInstance).map(ColumnSegment.class::cast);
        if (!columnSegment.isPresent()) {
            return Collections.emptyList();
        }
        return this.getEncryptConditions(tableName, expression, columnSegment.get());
    }

    private Collection<EncryptCondition> getEncryptConditions(String tableName, BinaryOperationExpression expression, ColumnSegment columnSegment) {
        ExpressionSegment compareValueSegment = this.isCompareValueSegment(expression.getLeft()) ? expression.getLeft() : expression.getRight();
        return this.getEncryptCondition(tableName, expression, compareValueSegment, columnSegment).map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    private Optional<EncryptCondition> getEncryptCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment expressionSegment, ColumnSegment columnSegment) {
        if (expressionSegment instanceof SimpleExpressionSegment) {
            return Optional.of(this.createEncryptBinaryOperationCondition(tableName, expression, columnSegment, expressionSegment));
        }
        if (expressionSegment instanceof ListExpression) {
            return Optional.of(this.createEncryptBinaryOperationCondition(tableName, expression, columnSegment, (ExpressionSegment)((ListExpression)expressionSegment).getItems().get(0)));
        }
        return Optional.empty();
    }

    private boolean isCompareValueSegment(ExpressionSegment expressionSegment) {
        return expressionSegment instanceof SimpleExpressionSegment || expressionSegment instanceof ListExpression;
    }

    private boolean isLeftRightContainsSubquerySegment(BinaryOperationExpression expression) {
        return expression.getLeft() instanceof SubqueryExpressionSegment || expression.getRight() instanceof SubqueryExpressionSegment;
    }

    private EncryptBinaryCondition createEncryptBinaryOperationCondition(String tableName, BinaryOperationExpression expression, ColumnSegment columnSegment, ExpressionSegment compareValueSegment) {
        return new EncryptBinaryCondition(columnSegment, tableName, expression.getOperator(), compareValueSegment.getStartIndex(), compareValueSegment.getStopIndex(), compareValueSegment);
    }

    private static Collection<EncryptCondition> createInEncryptCondition(String tableName, InExpression inExpression, ExpressionSegment inRightValue) {
        if (!(inExpression.getLeft() instanceof ColumnSegment)) {
            return Collections.emptyList();
        }
        ColumnSegment columnSegment = (ColumnSegment)inExpression.getLeft();
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inExpression.getExpressionList()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        if (expressionSegments.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singleton(new EncryptInCondition(columnSegment, tableName, inRightValue.getStartIndex(), inRightValue.getStopIndex(), expressionSegments));
    }

    @Generated
    public EncryptConditionEngine(EncryptRule rule) {
        this.rule = rule;
    }
}

