/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptShowCreateViewMergedResult
extends DecoratorMergedResult {
    private static final String COMMA = ", ";
    private static final int CREATE_TABLE_DEFINITION_INDEX = 2;
    private final MergedResult mergedResult;
    private final String viewName;
    private final EncryptRule rule;
    private final ShardingSphereMetaData metaData;
    private final SQLParserEngine sqlParserEngine;
    private final String currentDatabaseName;
    private final DatabaseType databaseType;

    public EncryptShowCreateViewMergedResult(ShardingSphereMetaData metaData, MergedResult mergedResult, String viewName, EncryptRule rule, String currentDatabaseName) {
        super(mergedResult);
        this.mergedResult = mergedResult;
        this.viewName = viewName;
        this.rule = rule;
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
        this.databaseType = metaData.getDatabase(this.currentDatabaseName).getProtocolType();
        this.sqlParserEngine = ((SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(this.databaseType);
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (2 != columnIndex) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        String createViewSQL = this.mergedResult.getValue(2, type).toString();
        Optional<EncryptTable> encryptView = this.rule.findEncryptTable(this.viewName);
        if (!encryptView.isPresent()) {
            return createViewSQL;
        }
        CreateViewStatement createViewStatement = (CreateViewStatement)this.sqlParserEngine.parse(createViewSQL, false);
        Optional from = createViewStatement.getSelect().getFrom();
        if (!from.isPresent() || !(from.get() instanceof SimpleTableSegment)) {
            return createViewSQL;
        }
        String tableName = ((SimpleTableSegment)from.get()).getTableName().getIdentifier().getValue();
        Optional encryptTable = this.metaData.getDatabase(EncryptShowCreateViewMergedResult.getDatabaseName((SimpleTableSegment)from.get(), this.databaseType, this.currentDatabaseName).getValue()).getRuleMetaData().findSingleRule(EncryptRule.class).flatMap(encryptRule -> encryptRule.findEncryptTable(tableName));
        if (!encryptTable.isPresent()) {
            return createViewSQL;
        }
        List projections = createViewStatement.getSelect().getProjections().getProjections();
        StringBuilder result = new StringBuilder(createViewSQL.substring(0, ((ProjectionSegment)projections.get(0)).getStartIndex()));
        for (ProjectionSegment each : projections) {
            this.findLogicColumnDefinition(each, encryptView.get(), (EncryptTable)encryptTable.get(), createViewSQL).ifPresent(optional -> result.append((String)optional).append(COMMA));
        }
        result.delete(result.length() - COMMA.length(), result.length()).append(createViewSQL.substring(((ProjectionSegment)projections.get(projections.size() - 1)).getStopIndex() + 1));
        return result.toString();
    }

    private static IdentifierValue getDatabaseName(SimpleTableSegment segment, DatabaseType databaseType, String currentDatabaseName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        Optional<String> owner = dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? segment.getOwner().flatMap(OwnerSegment::getOwner) : segment.getOwner();
        return new IdentifierValue(owner.map(optional -> optional.getIdentifier().getValue()).orElse(currentDatabaseName));
    }

    private Optional<String> findLogicColumnDefinition(ProjectionSegment projectionSegment, EncryptTable encryptView, EncryptTable encryptTable, String createTableSQL) {
        if (!(projectionSegment instanceof ColumnProjectionSegment)) {
            return Optional.of(createTableSQL.substring(projectionSegment.getStartIndex(), projectionSegment.getStopIndex() + 1));
        }
        ColumnSegment columnSegment = ((ColumnProjectionSegment)projectionSegment).getColumn();
        String columnName = ((ColumnProjectionSegment)projectionSegment).getAliasName().orElse(columnSegment.getIdentifier().getValue());
        if (encryptView.isCipherColumn(columnName)) {
            String logicColumn = encryptView.getLogicColumnByCipherColumn(columnName);
            String actualColumn = encryptTable.getLogicColumnByCipherColumn(columnSegment.getIdentifier().getValue());
            StringBuilder result = new StringBuilder(actualColumn);
            Optional alias = ((ColumnProjectionSegment)projectionSegment).getAlias();
            alias.ifPresent(identifierValue -> result.append(" AS ").append(identifierValue.getQuoteCharacter().wrap(logicColumn)));
            return Optional.of(result.toString());
        }
        if (this.isDerivedColumn(encryptView, columnName)) {
            return Optional.empty();
        }
        return Optional.of(createTableSQL.substring(projectionSegment.getStartIndex(), projectionSegment.getStopIndex() + 1));
    }

    private boolean isDerivedColumn(EncryptTable encryptTable, String columnName) {
        return encryptTable.isAssistedQueryColumn(columnName) || encryptTable.isLikeQueryColumn(columnName);
    }
}

