/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableInResultSetSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;

public final class EncryptShowCreateTableMergedResult
extends DecoratorMergedResult {
    private static final String COMMA = ", ";
    private final EncryptRule rule;
    private final String tableName;
    private final int tableNameResultSetIndex;
    private final SQLParserEngine sqlParserEngine;

    public EncryptShowCreateTableMergedResult(RuleMetaData globalRuleMetaData, MergedResult mergedResult, SQLStatementContext sqlStatementContext, EncryptRule rule) {
        super(mergedResult);
        ShardingSpherePreconditions.checkState((1 == sqlStatementContext.getTablesContext().getSimpleTables().size() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("SHOW CREATE TABLE FOR MULTI TABLES"));
        this.rule = rule;
        this.tableName = ((SimpleTableSegment)sqlStatementContext.getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue();
        TableInResultSetSQLStatementAttribute attribute = (TableInResultSetSQLStatementAttribute)sqlStatementContext.getSqlStatement().getAttributes().getAttribute(TableInResultSetSQLStatementAttribute.class);
        this.tableNameResultSetIndex = attribute.getNameResultSetIndex();
        this.sqlParserEngine = ((SQLParserRule)globalRuleMetaData.getSingleRule(SQLParserRule.class)).getSQLParserEngine(sqlStatementContext.getSqlStatement().getDatabaseType());
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (this.tableNameResultSetIndex != columnIndex) {
            return this.getMergedResult().getValue(columnIndex, type);
        }
        String createTableSQL = this.getMergedResult().getValue(this.tableNameResultSetIndex, type).toString();
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(this.tableName);
        if (!encryptTable.isPresent() || !createTableSQL.contains("(")) {
            return createTableSQL;
        }
        CreateTableStatement createTableStatement = (CreateTableStatement)this.sqlParserEngine.parse(createTableSQL, false);
        ArrayList columnDefinitions = new ArrayList(createTableStatement.getColumnDefinitions());
        StringBuilder result = new StringBuilder(createTableSQL.substring(0, ((ColumnDefinitionSegment)columnDefinitions.get(0)).getStartIndex()));
        for (ColumnDefinitionSegment each : columnDefinitions) {
            this.findLogicColumnDefinition(each, encryptTable.get(), createTableSQL).ifPresent(optional -> result.append((String)optional).append(COMMA));
        }
        result.delete(result.length() - COMMA.length(), result.length()).append(createTableSQL.substring(((ColumnDefinitionSegment)columnDefinitions.get(columnDefinitions.size() - 1)).getStopIndex() + 1));
        return result.toString();
    }

    private Optional<String> findLogicColumnDefinition(ColumnDefinitionSegment columnDefinition, EncryptTable encryptTable, String createTableSQL) {
        ColumnSegment columnSegment = columnDefinition.getColumnName();
        String columnName = columnSegment.getIdentifier().getValue();
        if (encryptTable.isCipherColumn(columnName)) {
            String logicColumn = encryptTable.getLogicColumnByCipherColumn(columnName);
            return Optional.of(createTableSQL.substring(columnDefinition.getStartIndex(), columnSegment.getStartIndex()) + columnSegment.getIdentifier().getQuoteCharacter().wrap(logicColumn) + createTableSQL.substring(columnSegment.getStopIndex() + 1, columnDefinition.getStopIndex() + 1));
        }
        if (encryptTable.isDerivedColumn(columnName)) {
            return Optional.empty();
        }
        return Optional.of(createTableSQL.substring(columnDefinition.getStartIndex(), columnDefinition.getStopIndex() + 1));
    }
}

