/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.ColumnInResultSetSQLStatementAttribute;

public final class EncryptShowColumnsMergedResult
extends DecoratorMergedResult {
    private final EncryptRule rule;
    private final String tableName;
    private final int columnNameResultSetIndex;

    public EncryptShowColumnsMergedResult(MergedResult mergedResult, SQLStatementContext sqlStatementContext, EncryptRule rule) {
        super(mergedResult);
        ShardingSpherePreconditions.checkState((1 == sqlStatementContext.getTablesContext().getSimpleTables().size() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("SHOW COLUMNS FOR MULTI TABLES"));
        this.rule = rule;
        this.tableName = ((SimpleTableSegment)sqlStatementContext.getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue();
        ColumnInResultSetSQLStatementAttribute attribute = (ColumnInResultSetSQLStatementAttribute)sqlStatementContext.getSqlStatement().getAttributes().getAttribute(ColumnInResultSetSQLStatementAttribute.class);
        this.columnNameResultSetIndex = attribute.getNameResultSetIndex();
    }

    public boolean next() throws SQLException {
        boolean hasNext = this.getMergedResult().next();
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(this.tableName);
        if (hasNext && !encryptTable.isPresent()) {
            return true;
        }
        if (!hasNext) {
            return false;
        }
        return this.next(encryptTable.get());
    }

    private boolean next(EncryptTable encryptTable) throws SQLException {
        while (encryptTable.isDerivedColumn(this.getMergedResult().getValue(this.columnNameResultSetIndex, String.class).toString())) {
            boolean isFinished = !this.getMergedResult().next();
            if (!isFinished) continue;
            return false;
        }
        return true;
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (this.columnNameResultSetIndex == columnIndex) {
            return this.getColumnNameValue(type);
        }
        return this.getMergedResult().getValue(columnIndex, type);
    }

    private String getColumnNameValue(Class<?> type) throws SQLException {
        String columnName = this.getMergedResult().getValue(this.columnNameResultSetIndex, type).toString();
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(this.tableName);
        return encryptTable.isPresent() && encryptTable.get().isCipherColumn(columnName) ? encryptTable.get().getLogicColumnByCipherColumn(columnName) : columnName;
    }
}

