/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.merge.dal.show.EncryptShowColumnsMergedResult;
import org.apache.shardingsphere.encrypt.merge.dal.show.EncryptShowCreateTableMergedResult;
import org.apache.shardingsphere.encrypt.merge.dal.show.EncryptShowCreateViewMergedResult;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.ColumnInResultSetSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableInResultSetSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.ViewInResultSetSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptDALResultDecorator
implements ResultDecorator {
    private final ShardingSphereDatabase database;
    private final ShardingSphereMetaData metaData;

    public MergedResult decorate(MergedResult mergedResult, QueryContext queryContext) {
        Collection simpleTables = queryContext.getSqlStatementContext().getTablesContext().getSimpleTables();
        if (1 != simpleTables.size()) {
            return mergedResult;
        }
        ShardingSphereDatabase shardingSphereDatabase = ((SimpleTableSegment)simpleTables.iterator().next()).getTableName().getTableBoundInfo().map(TableSegmentBoundInfo::getOriginalDatabase).map(IdentifierValue::getValue).map(arg_0 -> ((ShardingSphereMetaData)this.metaData).getDatabase(arg_0)).orElse(this.database);
        Optional encryptRule = shardingSphereDatabase.getRuleMetaData().findSingleRule(EncryptRule.class);
        if (!encryptRule.isPresent()) {
            return mergedResult;
        }
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        if (sqlStatement.getAttributes().findAttribute(ColumnInResultSetSQLStatementAttribute.class).isPresent()) {
            return new EncryptShowColumnsMergedResult(mergedResult, queryContext.getSqlStatementContext(), (EncryptRule)encryptRule.get());
        }
        if (sqlStatement.getAttributes().findAttribute(TableInResultSetSQLStatementAttribute.class).isPresent()) {
            return new EncryptShowCreateTableMergedResult(this.metaData.getGlobalRuleMetaData(), mergedResult, queryContext.getSqlStatementContext(), (EncryptRule)encryptRule.get());
        }
        Optional viewInResultSetSQLStatementAttribute = sqlStatement.getAttributes().findAttribute(ViewInResultSetSQLStatementAttribute.class);
        if (viewInResultSetSQLStatementAttribute.isPresent()) {
            String currentDatabaseName = queryContext.getConnectionContext().getCurrentDatabaseName().orElse(null);
            return new EncryptShowCreateViewMergedResult(this.metaData, mergedResult, ((ViewInResultSetSQLStatementAttribute)viewInResultSetSQLStatementAttribute.get()).getViewName(), (EncryptRule)encryptRule.get(), currentDatabaseName);
        }
        return mergedResult;
    }

    @Generated
    public EncryptDALResultDecorator(ShardingSphereDatabase database, ShardingSphereMetaData metaData) {
        this.database = database;
        this.metaData = metaData;
    }
}

