/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.with;

import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.WithSQLStatementAttribute;

public final class EncryptWithClauseSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement().getAttributes().findAttribute(WithSQLStatementAttribute.class).map(WithSQLStatementAttribute::containsWith).orElse(false);
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        for (String each : SQLStatementContextExtractor.getTableNames((ShardingSphereDatabase)database, (SQLStatementContext)sqlStatementContext)) {
            ShardingSpherePreconditions.checkState((!rule.findEncryptTable(each).isPresent() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("WITH"));
        }
    }
}

