/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.predicate;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.checker.cryptographic.JoinConditionsEncryptorChecker;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingMatchedEncryptQueryAlgorithmException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;

public final class EncryptPredicateColumnSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereContextAvailable && !((WhereContextAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        Collection allSubqueryContexts = SQLStatementContextExtractor.getAllSubqueryContexts((SQLStatementContext)sqlStatementContext);
        Collection joinConditions = SQLStatementContextExtractor.getJoinConditions((WhereContextAvailable)((WhereContextAvailable)sqlStatementContext), (Collection)allSubqueryContexts);
        JoinConditionsEncryptorChecker.checkIsSame(joinConditions, rule, "join condition");
        this.check(rule, (WhereContextAvailable)sqlStatementContext);
    }

    private void check(EncryptRule rule, WhereContextAvailable sqlStatementContext) {
        for (ColumnSegment each : sqlStatementContext.getColumnSegments()) {
            Optional<EncryptTable> encryptTable = rule.findEncryptTable(each.getColumnBoundInfo().getOriginalTable().getValue());
            String columnName = each.getIdentifier().getValue();
            if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(columnName) || !this.includesLike(sqlStatementContext.getWhereSegments(), each)) continue;
            String tableName = encryptTable.get().getTable();
            ShardingSpherePreconditions.checkState((boolean)encryptTable.get().getEncryptColumn(columnName).getLikeQuery().isPresent(), () -> new MissingMatchedEncryptQueryAlgorithmException(tableName, columnName, "LIKE"));
        }
    }

    private boolean includesLike(Collection<WhereSegment> whereSegments, ColumnSegment targetColumnSegment) {
        for (WhereSegment each : whereSegments) {
            Collection expressions = ExpressionExtractor.extractAllExpressions((ExpressionSegment)each.getExpr());
            if (!this.isLikeColumnSegment(expressions, targetColumnSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean isLikeColumnSegment(Collection<ExpressionSegment> expressions, ColumnSegment targetColumnSegment) {
        for (ExpressionSegment each : expressions) {
            if (!(each instanceof BinaryOperationExpression) || !"LIKE".equalsIgnoreCase(((BinaryOperationExpression)each).getOperator()) && !"NOT LIKE".equalsIgnoreCase(((BinaryOperationExpression)each).getOperator()) || !this.isSameColumnSegment(((BinaryOperationExpression)each).getLeft(), targetColumnSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameColumnSegment(ExpressionSegment columnSegment, ColumnSegment targetColumnSegment) {
        return columnSegment instanceof ColumnSegment && columnSegment.getStartIndex() == targetColumnSegment.getStartIndex() && columnSegment.getStopIndex() == targetColumnSegment.getStopIndex();
    }
}

