/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.orderby;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;

public final class EncryptOrderByItemSupportedChecker
implements SupportedSQLChecker<SelectStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && this.containsOrderByItem((SelectStatementContext)sqlStatementContext);
    }

    private boolean containsOrderByItem(SelectStatementContext sqlStatementContext) {
        if (!sqlStatementContext.getOrderByContext().getItems().isEmpty() && !sqlStatementContext.getOrderByContext().isGenerated()) {
            return true;
        }
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            if (!this.containsOrderByItem(each)) continue;
            return true;
        }
        return false;
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SelectStatementContext sqlStatementContext) {
        for (OrderByItem each : this.getOrderByItems(sqlStatementContext)) {
            if (!(each.getSegment() instanceof ColumnOrderByItemSegment)) continue;
            this.checkColumnOrderByItem(rule, ((ColumnOrderByItemSegment)each.getSegment()).getColumn());
        }
    }

    private Collection<OrderByItem> getOrderByItems(SelectStatementContext sqlStatementContext) {
        LinkedList<OrderByItem> result = new LinkedList<OrderByItem>();
        if (!sqlStatementContext.getOrderByContext().isGenerated()) {
            result.addAll(sqlStatementContext.getOrderByContext().getItems());
        }
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            result.addAll(this.getOrderByItems(each));
        }
        return result;
    }

    private void checkColumnOrderByItem(EncryptRule rule, ColumnSegment columnSegment) {
        Optional<EncryptTable> encryptTable = rule.findEncryptTable(columnSegment.getColumnBoundInfo().getOriginalTable().getValue());
        String columnName = columnSegment.getIdentifier().getValue();
        ShardingSpherePreconditions.checkState((!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(columnName) ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("ORDER BY"));
    }
}

