/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.combine;

import java.util.Collection;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;

public final class EncryptCombineClauseSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        if (EncryptCombineClauseSupportedChecker.isContainsCombine(sqlStatementContext)) {
            return true;
        }
        for (SelectStatementContext each : SQLStatementContextExtractor.getAllSubqueryContexts((SQLStatementContext)sqlStatementContext)) {
            if (!EncryptCombineClauseSupportedChecker.isContainsCombine((SQLStatementContext)each)) continue;
            return true;
        }
        return false;
    }

    private static boolean isContainsCombine(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).isContainsCombine();
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        Collection tableNames = SQLStatementContextExtractor.getTableNames((ShardingSphereDatabase)database, (SQLStatementContext)sqlStatementContext);
        for (String each : tableNames) {
            ShardingSpherePreconditions.checkState((!rule.findEncryptTable(each).isPresent() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("COMBINE"));
        }
    }
}

