/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.cryptographic;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.comparator.EncryptorComparator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;

public final class JoinConditionsEncryptorChecker {
    public static void checkIsSame(Collection<BinaryOperationExpression> joinConditions, EncryptRule encryptRule, String scenario) {
        for (BinaryOperationExpression each : joinConditions) {
            if (!(each.getLeft() instanceof ColumnSegment) || !(each.getRight() instanceof ColumnSegment)) continue;
            ColumnSegmentBoundInfo leftColumnInfo = ((ColumnSegment)each.getLeft()).getColumnBoundInfo();
            ColumnSegmentBoundInfo rightColumnInfo = ((ColumnSegment)each.getRight()).getColumnBoundInfo();
            ShardingSpherePreconditions.checkState((boolean)EncryptorComparator.isSame(encryptRule, leftColumnInfo, rightColumnInfo), () -> new UnsupportedSQLOperationException("Can not use different encryptor for " + leftColumnInfo + " and " + rightColumnInfo + " in " + scenario));
        }
    }

    @Generated
    private JoinConditionsEncryptorChecker() {
    }
}

