/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge.result.impl.stream;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.stream.StreamMergedResult;

public final class IteratorStreamMergedResult
extends StreamMergedResult {
    private final Iterator<QueryResult> queryResults;

    public IteratorStreamMergedResult(List<QueryResult> queryResults) {
        this.queryResults = queryResults.iterator();
        this.setCurrentQueryResult(this.queryResults.next());
    }

    @Override
    public boolean next() throws SQLException {
        if (this.getCurrentQueryResult().next()) {
            return true;
        }
        if (!this.queryResults.hasNext()) {
            return false;
        }
        this.setCurrentQueryResult(this.queryResults.next());
        boolean hasNext = this.getCurrentQueryResult().next();
        if (hasNext) {
            return true;
        }
        while (!hasNext && this.queryResults.hasNext()) {
            this.setCurrentQueryResult(this.queryResults.next());
            hasNext = this.getCurrentQueryResult().next();
        }
        return hasNext;
    }
}

