/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.ResultProcessEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecoratorEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.impl.TransparentResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMergerEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class MergeEngine {
    private final ShardingSphereMetaData metaData;
    private final ShardingSphereDatabase database;
    private final ConfigurationProperties props;
    private final Collection<ResultProcessEngine> engines;
    private final ConnectionContext connectionContext;

    public MergeEngine(ShardingSphereMetaData metaData, ShardingSphereDatabase database, ConfigurationProperties props, ConnectionContext connectionContext) {
        this.metaData = metaData;
        this.database = database;
        this.props = props;
        Map ruleEngines = OrderedSPILoader.getServices(ResultProcessEngine.class, (Collection)database.getRuleMetaData().getRules());
        this.engines = new LinkedList(ruleEngines.values());
        this.connectionContext = connectionContext;
    }

    public MergedResult merge(List<QueryResult> queryResults, QueryContext queryContext) throws SQLException {
        MergedResult mergedResult = this.executeMerge(queryResults, queryContext).orElseGet(() -> new TransparentMergedResult((QueryResult)queryResults.get(0)));
        return this.decorate(mergedResult, queryContext);
    }

    private Optional<MergedResult> executeMerge(List<QueryResult> queryResults, QueryContext queryContext) throws SQLException {
        for (ResultProcessEngine each : this.engines) {
            Optional rule;
            if (!(each instanceof ResultMergerEngine) || !(rule = this.database.getRuleMetaData().findSingleRule(each.getTypeClass())).isPresent()) continue;
            ResultMerger resultMerger = ((ResultMergerEngine)each).newInstance(this.database.getName(), this.database.getProtocolType(), (ShardingSphereRule)rule.get(), this.props, queryContext.getSqlStatementContext());
            return Optional.of(resultMerger.merge(queryResults, queryContext.getSqlStatementContext(), this.database, this.connectionContext));
        }
        return Optional.empty();
    }

    private MergedResult decorate(MergedResult mergedResult, QueryContext queryContext) throws SQLException {
        MergedResult result = null;
        for (ResultProcessEngine each : this.engines) {
            if (!(each instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = this.getResultDecorator(queryContext.getSqlStatementContext(), each);
            result = null == result ? resultDecorator.decorate(mergedResult, queryContext) : resultDecorator.decorate(result, queryContext);
        }
        return null == result ? mergedResult : result;
    }

    private ResultDecorator getResultDecorator(SQLStatementContext sqlStatementContext, ResultProcessEngine resultProcessEngine) {
        return (ResultDecorator)((ResultDecoratorEngine)resultProcessEngine).newInstance(this.metaData, this.database, this.props, sqlStatementContext).orElseGet(TransparentResultDecorator::new);
    }
}

