/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule.attribute;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.rule.attribute.exportable.ExportableRuleAttribute;
import org.apache.shardingsphere.readwritesplitting.group.type.StaticReadwriteSplittingGroup;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;

public final class ReadwriteSplittingExportableRuleAttribute
implements ExportableRuleAttribute {
    private final Map<String, ReadwriteSplittingDataSourceGroupRule> dataSourceGroupRules;

    public Map<String, Object> getExportData() {
        HashMap<String, Object> result = new HashMap<String, Object>(2, 1.0f);
        result.put("static_readwrite_splitting_rules", this.exportStaticDataSources());
        return result;
    }

    private Map<String, Map<String, String>> exportStaticDataSources() {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(this.dataSourceGroupRules.size(), 1.0f);
        for (ReadwriteSplittingDataSourceGroupRule each : this.dataSourceGroupRules.values()) {
            if (!(each.getReadwriteSplittingGroup() instanceof StaticReadwriteSplittingGroup)) continue;
            LinkedHashMap<String, String> exportedDataSources = new LinkedHashMap<String, String>(2, 1.0f);
            exportedDataSources.put("primary_data_source_name", each.getWriteDataSource());
            exportedDataSources.put("replica_data_source_names", String.join((CharSequence)",", each.getReadwriteSplittingGroup().getReadDataSources()));
            result.put(each.getName(), exportedDataSources);
        }
        return result;
    }

    @Generated
    public ReadwriteSplittingExportableRuleAttribute(Map<String, ReadwriteSplittingDataSourceGroupRule> dataSourceGroupRules) {
        this.dataSourceGroupRules = dataSourceGroupRules;
    }
}

