/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route.standard;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.readwritesplitting.route.standard.filter.ReadDataSourcesFilter;
import org.apache.shardingsphere.readwritesplitting.route.standard.filter.type.DisabledReadDataSourcesFilter;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;

public final class StandardReadwriteSplittingDataSourceRouter {
    private static final Collection<ReadDataSourcesFilter> FILTERS = Collections.singleton(new DisabledReadDataSourcesFilter());

    public String route(ReadwriteSplittingDataSourceGroupRule rule) {
        return rule.getLoadBalancer().getTargetName(rule.getName(), this.getFilteredReadDataSources(rule));
    }

    private List<String> getFilteredReadDataSources(ReadwriteSplittingDataSourceGroupRule rule) {
        List<String> result = rule.getReadwriteSplittingGroup().getReadDataSources();
        for (ReadDataSourcesFilter each : FILTERS) {
            result = each.filter(rule, result);
        }
        return result;
    }
}

