/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.checker;

import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.entry.InlineExpressionParserFactory;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.constant.ReadwriteSplittingDataSourceType;
import org.apache.shardingsphere.readwritesplitting.exception.ReadwriteSplittingRuleExceptionIdentifier;
import org.apache.shardingsphere.readwritesplitting.exception.actual.DuplicateReadwriteSplittingActualDataSourceException;
import org.apache.shardingsphere.readwritesplitting.exception.actual.MissingRequiredReadwriteSplittingActualDataSourceException;
import org.apache.shardingsphere.readwritesplitting.exception.actual.ReadwriteSplittingActualDataSourceNotFoundException;
import org.apache.shardingsphere.readwritesplitting.exception.logic.MissingRequiredReadwriteSplittingDataSourceRuleNameException;

public final class ReadwriteSplittingDataSourceRuleConfigurationChecker {
    private final String databaseName;
    private final ReadwriteSplittingDataSourceGroupRuleConfiguration config;
    private final Map<String, DataSource> dataSourceMap;
    private final ReadwriteSplittingRuleExceptionIdentifier exceptionIdentifier;

    public ReadwriteSplittingDataSourceRuleConfigurationChecker(String databaseName, ReadwriteSplittingDataSourceGroupRuleConfiguration config, Map<String, DataSource> dataSourceMap) {
        this.databaseName = databaseName;
        this.config = config;
        this.dataSourceMap = dataSourceMap;
        this.exceptionIdentifier = new ReadwriteSplittingRuleExceptionIdentifier(databaseName, config.getName());
    }

    public void check(Collection<String> builtWriteDataSourceNames, Collection<String> builtReadDataSourceNames, Collection<ShardingSphereRule> builtRules) {
        ShardingSpherePreconditions.checkNotEmpty((String)this.config.getName(), () -> new MissingRequiredReadwriteSplittingDataSourceRuleNameException(this.databaseName));
        ShardingSpherePreconditions.checkNotEmpty((String)this.config.getWriteDataSourceName(), () -> new MissingRequiredReadwriteSplittingActualDataSourceException(ReadwriteSplittingDataSourceType.WRITE, this.exceptionIdentifier));
        ShardingSpherePreconditions.checkNotEmpty((Collection)this.config.getReadDataSourceNames(), () -> new MissingRequiredReadwriteSplittingActualDataSourceException(ReadwriteSplittingDataSourceType.READ, this.exceptionIdentifier));
        this.checkActualSourceNames(ReadwriteSplittingDataSourceType.WRITE, this.config.getWriteDataSourceName(), builtWriteDataSourceNames, builtRules);
        this.config.getReadDataSourceNames().forEach(each -> this.checkActualSourceNames(ReadwriteSplittingDataSourceType.READ, (String)each, builtReadDataSourceNames, builtRules));
    }

    private void checkActualSourceNames(ReadwriteSplittingDataSourceType type, String actualDataSourceName, Collection<String> builtActualDataSourceNames, Collection<ShardingSphereRule> builtRules) {
        for (String each : InlineExpressionParserFactory.newInstance((String)actualDataSourceName).splitAndEvaluate()) {
            ShardingSpherePreconditions.checkState((this.dataSourceMap.containsKey(each) || this.containsInOtherRules(each, builtRules) ? 1 : 0) != 0, () -> new ReadwriteSplittingActualDataSourceNotFoundException(type, each, this.exceptionIdentifier));
            ShardingSpherePreconditions.checkState((boolean)builtActualDataSourceNames.add(each), () -> new DuplicateReadwriteSplittingActualDataSourceException(type, each, this.exceptionIdentifier));
        }
    }

    private boolean containsInOtherRules(String dataSourceName, Collection<ShardingSphereRule> builtRules) {
        return builtRules.stream().map(each -> each.getAttributes().findAttribute(DataSourceMapperRuleAttribute.class)).anyMatch(optional -> optional.isPresent() && ((DataSourceMapperRuleAttribute)optional.get()).getDataSourceMapper().containsKey(dataSourceName));
    }
}

