/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.LiteralValue;

public final class NumberLiteralValue
implements LiteralValue<Number> {
    private final Number value;

    public NumberLiteralValue(String value) {
        this.value = this.getNumber(value);
    }

    private Number getNumber(String value) {
        try {
            return SQLUtils.getExactlyNumber(new BigInteger(value));
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value);
        }
    }

    @Override
    @Generated
    public Number getValue() {
        return this.value;
    }
}

