/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.statement.core.enums.Paren;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NullLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.TemporalLiteralValue;

public final class SQLUtils {
    private static final String BACKTICK = "`";
    private static final String SQL_END = ";";
    private static final String COMMENT_PREFIX = "/*";
    private static final String COMMENT_SUFFIX = "*/";
    private static final String EXCLUDED_CHARACTERS = "[]'\"";
    private static final BigInteger INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public static Number getExactlyNumber(String value, int radix) {
        try {
            return SQLUtils.getExactlyNumber(new BigInteger(value, radix));
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value);
        }
    }

    public static Number getExactlyNumber(BigInteger value) {
        if (value.compareTo(INTEGER_MIN) >= 0 && value.compareTo(INTEGER_MAX) <= 0) {
            return value.intValue();
        }
        if (value.compareTo(LONG_MIN) >= 0 && value.compareTo(LONG_MAX) <= 0) {
            return value.longValue();
        }
        return value;
    }

    public static String getExactlyValue(String value) {
        return null == value ? null : SQLUtils.tryGetRealContentInBackticks(CharMatcher.anyOf((CharSequence)EXCLUDED_CHARACTERS).removeFrom((CharSequence)value));
    }

    public static String getExactlyValue(String value, String reservedCharacters) {
        if (null == value) {
            return null;
        }
        String toBeExcludedCharacters = CharMatcher.anyOf((CharSequence)reservedCharacters).removeFrom((CharSequence)EXCLUDED_CHARACTERS);
        return CharMatcher.anyOf((CharSequence)toBeExcludedCharacters).removeFrom((CharSequence)value);
    }

    public static String tryGetRealContentInBackticks(String value) {
        if (null == value) {
            return null;
        }
        if (value.startsWith(BACKTICK) && value.endsWith(BACKTICK)) {
            return SQLUtils.getRealContentInBackticks(value);
        }
        return value;
    }

    public static String getRealContentInBackticks(String value) {
        if (null == value) {
            return null;
        }
        int stopIndex = value.length() - 1;
        StringBuilder exactlyTableName = new StringBuilder();
        for (int startIndex = 1; startIndex < stopIndex; ++startIndex) {
            if (value.charAt(startIndex) == '`' && (startIndex + 1 >= stopIndex || value.charAt(startIndex + 1) != '`')) {
                return value;
            }
            if (value.charAt(startIndex) == '`' && value.charAt(startIndex + 1) == '`') {
                ++startIndex;
            }
            exactlyTableName.append(value.charAt(startIndex));
        }
        return 0 == exactlyTableName.length() ? value : exactlyTableName.toString();
    }

    public static String getExactlyExpression(String value) {
        return Strings.isNullOrEmpty((String)value) ? value : CharMatcher.anyOf((CharSequence)" ").removeFrom((CharSequence)value);
    }

    public static String getExpressionWithoutOutsideParentheses(String value) {
        int parenthesesOffset = SQLUtils.getParenthesesOffset(value);
        if (0 == parenthesesOffset) {
            return value;
        }
        String result = value.substring(parenthesesOffset, value.length() - parenthesesOffset);
        return SQLUtils.isValidParenthesis(result) ? result : value;
    }

    private static int getParenthesesOffset(String value) {
        int left = 0;
        if (Strings.isNullOrEmpty((String)value)) {
            return left;
        }
        int right = value.length() - 1;
        while (Paren.PARENTHESES.getLeftParen() == value.charAt(left) && Paren.PARENTHESES.getRightParen() == value.charAt(right)) {
            ++left;
            --right;
        }
        return left;
    }

    private static boolean isValidParenthesis(String text) {
        int count = 0;
        for (char each : text.toCharArray()) {
            if (Paren.PARENTHESES.getLeftParen() == each) {
                ++count;
                continue;
            }
            if (Paren.PARENTHESES.getRightParen() != each) continue;
            if (count == 0) {
                return false;
            }
            --count;
        }
        return count == 0;
    }

    public static List<SubqueryTableSegment> getSubqueryTableSegmentFromTableSegment(TableSegment tableSegment) {
        LinkedList<SubqueryTableSegment> result = new LinkedList<SubqueryTableSegment>();
        if (tableSegment instanceof SubqueryTableSegment) {
            result.add((SubqueryTableSegment)tableSegment);
        }
        if (tableSegment instanceof JoinTableSegment) {
            result.addAll(SQLUtils.getSubqueryTableSegmentFromJoinTableSegment((JoinTableSegment)tableSegment));
        }
        return result;
    }

    private static List<SubqueryTableSegment> getSubqueryTableSegmentFromJoinTableSegment(JoinTableSegment joinTableSegment) {
        LinkedList<SubqueryTableSegment> result = new LinkedList<SubqueryTableSegment>();
        if (joinTableSegment.getLeft() instanceof SubqueryTableSegment) {
            result.add((SubqueryTableSegment)joinTableSegment.getLeft());
        } else if (joinTableSegment.getLeft() instanceof JoinTableSegment) {
            result.addAll(SQLUtils.getSubqueryTableSegmentFromJoinTableSegment((JoinTableSegment)joinTableSegment.getLeft()));
        }
        if (joinTableSegment.getRight() instanceof SubqueryTableSegment) {
            result.add((SubqueryTableSegment)joinTableSegment.getRight());
        } else if (joinTableSegment.getRight() instanceof JoinTableSegment) {
            result.addAll(SQLUtils.getSubqueryTableSegmentFromJoinTableSegment((JoinTableSegment)joinTableSegment.getRight()));
        }
        return result;
    }

    public static ExpressionSegment createLiteralExpression(ASTNode astNode, int startIndex, int stopIndex, String text) {
        if (astNode instanceof StringLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, ((StringLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NumberLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, ((NumberLiteralValue)astNode).getValue());
        }
        if (astNode instanceof BooleanLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, ((BooleanLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NullLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, null);
        }
        if (astNode instanceof TemporalLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, ((TemporalLiteralValue)astNode).getValue());
        }
        if (astNode instanceof OtherLiteralValue) {
            return new CommonExpressionSegment(startIndex, stopIndex, ((OtherLiteralValue)astNode).getValue());
        }
        return new CommonExpressionSegment(startIndex, stopIndex, text);
    }

    public static String trimSemicolon(String sql) {
        return sql.endsWith(SQL_END) ? sql.substring(0, sql.length() - 1) : sql;
    }

    public static String trimComment(String sql) {
        String result = sql;
        if (sql.startsWith(COMMENT_PREFIX)) {
            result = result.substring(sql.indexOf(COMMENT_SUFFIX) + 2);
        }
        if (sql.endsWith(SQL_END)) {
            result = result.substring(0, result.length() - 1);
        }
        return result.trim();
    }

    @Generated
    private SQLUtils() {
    }
}

