/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.util;

import com.google.common.base.CharMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;

public final class MultiSQLSplitter {
    public static boolean hasSameTypeMultiStatements(SQLStatement sqlStatementSample, Collection<String> sqls) {
        if (sqls.size() <= 1) {
            return false;
        }
        for (String each : sqls) {
            if (MultiSQLSplitter.matchesStatementType(MultiSQLSplitter.stripLeadingComments(each), sqlStatementSample)) continue;
            return false;
        }
        return true;
    }

    private static String stripLeadingComments(String sql) {
        int index = 0;
        while (index < sql.length() && (index = MultiSQLSplitter.skipWhitespace(sql, index)) < sql.length()) {
            if ('/' == sql.charAt(index) && index + 1 < sql.length() && '*' == sql.charAt(index + 1)) {
                int end = sql.indexOf("*/", index + 2);
                if (end < 0) {
                    return "";
                }
                index = end + 2;
                continue;
            }
            if (MultiSQLSplitter.isDashCommentStart(sql, index)) {
                index = MultiSQLSplitter.skipLine(sql, index + 2);
                continue;
            }
            if ('#' != sql.charAt(index)) break;
            index = MultiSQLSplitter.skipLine(sql, index + 1);
        }
        return sql.substring(index).trim();
    }

    private static int skipWhitespace(String sql, int start) {
        int index = CharMatcher.whitespace().negate().indexIn((CharSequence)sql, start);
        return -1 == index ? sql.length() : index;
    }

    private static int skipLine(String sql, int startIndex) {
        int index;
        for (index = startIndex; index < sql.length(); ++index) {
            char current = sql.charAt(index);
            if ('\n' == current) break;
            if ('\r' != current) continue;
            if (index >= sql.length() || '\n' != sql.charAt(index)) break;
            ++index;
            break;
        }
        return index;
    }

    private static boolean matchesStatementType(String sql, SQLStatement sqlStatementSample) {
        if (sql.isEmpty()) {
            return false;
        }
        if (sqlStatementSample instanceof InsertStatement) {
            return MultiSQLSplitter.startsWithIgnoreCase(sql, "insert");
        }
        if (sqlStatementSample instanceof UpdateStatement) {
            return MultiSQLSplitter.startsWithIgnoreCase(sql, "update");
        }
        if (sqlStatementSample instanceof DeleteStatement) {
            return MultiSQLSplitter.startsWithIgnoreCase(sql, "delete");
        }
        return false;
    }

    private static boolean startsWithIgnoreCase(String text, String prefix) {
        return text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static Collection<String> split(String sql) {
        int step;
        if (null == sql || sql.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        StringBuilder current = new StringBuilder(sql.length());
        ScanState state = ScanState.NORMAL;
        QuoteCharacter quote = QuoteCharacter.NONE;
        int length = sql.length();
        block5: for (int index = 0; index < length; index += step) {
            char ch = sql.charAt(index);
            char next = index + 1 < length ? sql.charAt(index + 1) : (char)'\u0000';
            step = 1;
            switch (state) {
                case QUOTE: {
                    current.append(ch);
                    if (QuoteCharacter.BACK_QUOTE != quote && '\\' == ch && index + 1 < length) {
                        current.append(sql.charAt(index + 1));
                        step = 2;
                        continue block5;
                    }
                    if (!MultiSQLSplitter.isQuoteEnd(quote, ch)) continue block5;
                    if (MultiSQLSplitter.isRepeatedQuote(sql, quote, index)) {
                        current.append(sql.charAt(index + 1));
                        step = 2;
                        continue block5;
                    }
                    quote = QuoteCharacter.NONE;
                    state = ScanState.NORMAL;
                    continue block5;
                }
                case LINE_COMMENT: {
                    current.append(ch);
                    if ('\n' != ch && '\r' != ch) continue block5;
                    state = ScanState.NORMAL;
                    continue block5;
                }
                case BLOCK_COMMENT: {
                    current.append(ch);
                    if ('*' != ch || '/' != next) continue block5;
                    current.append(next);
                    step = 2;
                    state = ScanState.NORMAL;
                    continue block5;
                }
                default: {
                    if (';' == ch) {
                        MultiSQLSplitter.appendStatement(result, current);
                        continue block5;
                    }
                    QuoteCharacter quoteCandidate = QuoteCharacter.getQuoteCharacter((String)String.valueOf(ch));
                    if (MultiSQLSplitter.isSupportedQuote(quoteCandidate)) {
                        quote = quoteCandidate;
                        state = ScanState.QUOTE;
                        current.append(ch);
                        continue block5;
                    }
                    if (MultiSQLSplitter.isDashCommentStart(sql, index)) {
                        state = ScanState.LINE_COMMENT;
                        current.append(ch);
                        current.append(next);
                        step = 2;
                        continue block5;
                    }
                    if ('#' == ch) {
                        state = ScanState.LINE_COMMENT;
                        current.append(ch);
                        continue block5;
                    }
                    if ('/' == ch && '*' == next) {
                        state = ScanState.BLOCK_COMMENT;
                        current.append(ch);
                        current.append(next);
                        step = 2;
                        continue block5;
                    }
                    current.append(ch);
                }
            }
        }
        MultiSQLSplitter.appendStatement(result, current);
        return result;
    }

    private static void appendStatement(Collection<String> statements, StringBuilder current) {
        String value = current.toString().trim();
        if (!value.isEmpty()) {
            statements.add(value);
        }
        current.setLength(0);
    }

    private static boolean isDashCommentStart(String sql, int index) {
        if (index + 1 >= sql.length()) {
            return false;
        }
        if ('-' != sql.charAt(index) || '-' != sql.charAt(index + 1)) {
            return false;
        }
        int commentContentIndex = index + 2;
        return commentContentIndex >= sql.length() || Character.isWhitespace(sql.charAt(commentContentIndex));
    }

    private static boolean isSupportedQuote(QuoteCharacter quote) {
        return QuoteCharacter.SINGLE_QUOTE == quote || QuoteCharacter.QUOTE == quote || QuoteCharacter.BACK_QUOTE == quote;
    }

    private static boolean isQuoteEnd(QuoteCharacter quote, char ch) {
        return QuoteCharacter.NONE != quote && quote.getEndDelimiter().charAt(0) == ch;
    }

    private static boolean isRepeatedQuote(String sql, QuoteCharacter quote, int index) {
        int nextIndex = index + 1;
        return nextIndex < sql.length() && sql.charAt(nextIndex) == quote.getEndDelimiter().charAt(0);
    }

    @Generated
    private MultiSQLSplitter() {
    }

    private static enum ScanState {
        NORMAL,
        QUOTE,
        LINE_COMMENT,
        BLOCK_COMMENT;

    }
}

