/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyCollectionRetrievalSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ReplaceColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ValidateConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.DropIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.RenameIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.partition.RenamePartitionDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.primary.DropPrimaryKeyDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.rollup.RenameRollupDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.AlgorithmTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.ConvertTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.LockTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.ReplaceTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.ConstraintSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;

public final class AlterTableStatement
extends DDLStatement {
    private SimpleTableSegment table;
    private SimpleTableSegment renameTable;
    private ReplaceTableDefinitionSegment replaceTable;
    private ConvertTableDefinitionSegment convertTableDefinition;
    private ModifyCollectionRetrievalSegment modifyCollectionRetrieval;
    private AlgorithmTypeSegment algorithmSegment;
    private LockTableSegment lockTableSegment;
    private DropPrimaryKeyDefinitionSegment dropPrimaryKeyDefinition;
    private final Collection<AddColumnDefinitionSegment> addColumnDefinitions = new LinkedList<AddColumnDefinitionSegment>();
    private final Collection<ModifyColumnDefinitionSegment> modifyColumnDefinitions = new LinkedList<ModifyColumnDefinitionSegment>();
    private final Collection<ChangeColumnDefinitionSegment> changeColumnDefinitions = new LinkedList<ChangeColumnDefinitionSegment>();
    private final Collection<DropColumnDefinitionSegment> dropColumnDefinitions = new LinkedList<DropColumnDefinitionSegment>();
    private final Collection<AddConstraintDefinitionSegment> addConstraintDefinitions = new LinkedList<AddConstraintDefinitionSegment>();
    private final Collection<ValidateConstraintDefinitionSegment> validateConstraintDefinitions = new LinkedList<ValidateConstraintDefinitionSegment>();
    private final Collection<ModifyConstraintDefinitionSegment> modifyConstraintDefinitions = new LinkedList<ModifyConstraintDefinitionSegment>();
    private final Collection<DropConstraintDefinitionSegment> dropConstraintDefinitions = new LinkedList<DropConstraintDefinitionSegment>();
    private final Collection<DropIndexDefinitionSegment> dropIndexDefinitions = new LinkedList<DropIndexDefinitionSegment>();
    private final Collection<RenameColumnSegment> renameColumnDefinitions = new LinkedList<RenameColumnSegment>();
    private final Collection<RenameIndexDefinitionSegment> renameIndexDefinitions = new LinkedList<RenameIndexDefinitionSegment>();
    private final Collection<ReplaceColumnDefinitionSegment> replaceColumnDefinitions = new LinkedList<ReplaceColumnDefinitionSegment>();
    private final Collection<RenameRollupDefinitionSegment> renameRollupDefinitions = new LinkedList<RenameRollupDefinitionSegment>();
    private final Collection<RenamePartitionDefinitionSegment> renamePartitionDefinitions = new LinkedList<RenamePartitionDefinitionSegment>();
    private SQLStatementAttributes attributes;

    public AlterTableStatement(DatabaseType databaseType) {
        super(databaseType);
    }

    public Optional<SimpleTableSegment> getRenameTable() {
        return Optional.ofNullable(this.renameTable);
    }

    public Optional<ReplaceTableDefinitionSegment> getReplaceTable() {
        return Optional.ofNullable(this.replaceTable);
    }

    public Optional<ConvertTableDefinitionSegment> getConvertTableDefinition() {
        return Optional.ofNullable(this.convertTableDefinition);
    }

    public Optional<ModifyCollectionRetrievalSegment> getModifyCollectionRetrieval() {
        return Optional.ofNullable(this.modifyCollectionRetrieval);
    }

    public Optional<AlgorithmTypeSegment> getGetAlgorithmSegment() {
        return Optional.ofNullable(this.algorithmSegment);
    }

    public Optional<LockTableSegment> getLockTableSegment() {
        return Optional.ofNullable(this.lockTableSegment);
    }

    public Optional<DropPrimaryKeyDefinitionSegment> getDropPrimaryKeyDefinition() {
        return Optional.ofNullable(this.dropPrimaryKeyDefinition);
    }

    @Override
    public void buildAttributes() {
        this.attributes = new SQLStatementAttributes(new TableSQLStatementAttribute(this.getTables()), new AlterTableConstraintSQLStatementAttribute(), new AlterTableIndexSQLStatementAttribute());
    }

    private Collection<SimpleTableSegment> getTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(this.table);
        if (this.getRenameTable().isPresent()) {
            result.add(this.getRenameTable().get());
        }
        if (this.getReplaceTable().isPresent() && null != this.getReplaceTable().get().getReplaceTable()) {
            result.add(this.getReplaceTable().get().getReplaceTable());
        }
        for (AddColumnDefinitionSegment addColumnDefinitionSegment : this.addColumnDefinitions) {
            for (ColumnDefinitionSegment columnDefinition : addColumnDefinitionSegment.getColumnDefinitions()) {
                result.addAll(columnDefinition.getReferencedTables());
            }
        }
        for (ModifyColumnDefinitionSegment modifyColumnDefinitionSegment : this.modifyColumnDefinitions) {
            result.addAll(modifyColumnDefinitionSegment.getColumnDefinition().getReferencedTables());
        }
        for (AddConstraintDefinitionSegment addConstraintDefinitionSegment : this.addConstraintDefinitions) {
            addConstraintDefinitionSegment.getConstraintDefinition().getReferencedTable().ifPresent(result::add);
        }
        for (ReplaceColumnDefinitionSegment replaceColumnDefinitionSegment : this.replaceColumnDefinitions) {
            for (ColumnDefinitionSegment columnDefinition : replaceColumnDefinitionSegment.getColumnDefinitions()) {
                result.addAll(columnDefinition.getReferencedTables());
            }
        }
        return result;
    }

    @Generated
    public SimpleTableSegment getTable() {
        return this.table;
    }

    @Generated
    public AlgorithmTypeSegment getAlgorithmSegment() {
        return this.algorithmSegment;
    }

    @Generated
    public Collection<AddColumnDefinitionSegment> getAddColumnDefinitions() {
        return this.addColumnDefinitions;
    }

    @Generated
    public Collection<ModifyColumnDefinitionSegment> getModifyColumnDefinitions() {
        return this.modifyColumnDefinitions;
    }

    @Generated
    public Collection<ChangeColumnDefinitionSegment> getChangeColumnDefinitions() {
        return this.changeColumnDefinitions;
    }

    @Generated
    public Collection<DropColumnDefinitionSegment> getDropColumnDefinitions() {
        return this.dropColumnDefinitions;
    }

    @Generated
    public Collection<AddConstraintDefinitionSegment> getAddConstraintDefinitions() {
        return this.addConstraintDefinitions;
    }

    @Generated
    public Collection<ValidateConstraintDefinitionSegment> getValidateConstraintDefinitions() {
        return this.validateConstraintDefinitions;
    }

    @Generated
    public Collection<ModifyConstraintDefinitionSegment> getModifyConstraintDefinitions() {
        return this.modifyConstraintDefinitions;
    }

    @Generated
    public Collection<DropConstraintDefinitionSegment> getDropConstraintDefinitions() {
        return this.dropConstraintDefinitions;
    }

    @Generated
    public Collection<DropIndexDefinitionSegment> getDropIndexDefinitions() {
        return this.dropIndexDefinitions;
    }

    @Generated
    public Collection<RenameColumnSegment> getRenameColumnDefinitions() {
        return this.renameColumnDefinitions;
    }

    @Generated
    public Collection<RenameIndexDefinitionSegment> getRenameIndexDefinitions() {
        return this.renameIndexDefinitions;
    }

    @Generated
    public Collection<ReplaceColumnDefinitionSegment> getReplaceColumnDefinitions() {
        return this.replaceColumnDefinitions;
    }

    @Generated
    public Collection<RenameRollupDefinitionSegment> getRenameRollupDefinitions() {
        return this.renameRollupDefinitions;
    }

    @Generated
    public Collection<RenamePartitionDefinitionSegment> getRenamePartitionDefinitions() {
        return this.renamePartitionDefinitions;
    }

    @Override
    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setTable(SimpleTableSegment table) {
        this.table = table;
    }

    @Generated
    public void setRenameTable(SimpleTableSegment renameTable) {
        this.renameTable = renameTable;
    }

    @Generated
    public void setReplaceTable(ReplaceTableDefinitionSegment replaceTable) {
        this.replaceTable = replaceTable;
    }

    @Generated
    public void setConvertTableDefinition(ConvertTableDefinitionSegment convertTableDefinition) {
        this.convertTableDefinition = convertTableDefinition;
    }

    @Generated
    public void setModifyCollectionRetrieval(ModifyCollectionRetrievalSegment modifyCollectionRetrieval) {
        this.modifyCollectionRetrieval = modifyCollectionRetrieval;
    }

    @Generated
    public void setAlgorithmSegment(AlgorithmTypeSegment algorithmSegment) {
        this.algorithmSegment = algorithmSegment;
    }

    @Generated
    public void setLockTableSegment(LockTableSegment lockTableSegment) {
        this.lockTableSegment = lockTableSegment;
    }

    @Generated
    public void setDropPrimaryKeyDefinition(DropPrimaryKeyDefinitionSegment dropPrimaryKeyDefinition) {
        this.dropPrimaryKeyDefinition = dropPrimaryKeyDefinition;
    }

    @Generated
    public void setAttributes(SQLStatementAttributes attributes) {
        this.attributes = attributes;
    }

    private class AlterTableConstraintSQLStatementAttribute
    implements ConstraintSQLStatementAttribute {
        private AlterTableConstraintSQLStatementAttribute() {
        }

        @Override
        public Collection<ConstraintSegment> getConstraints() {
            LinkedList<ConstraintSegment> result = new LinkedList<ConstraintSegment>();
            for (AddConstraintDefinitionSegment each : AlterTableStatement.this.addConstraintDefinitions) {
                each.getConstraintDefinition().getConstraintName().ifPresent(result::add);
            }
            AlterTableStatement.this.validateConstraintDefinitions.stream().map(ValidateConstraintDefinitionSegment::getConstraintName).forEach(result::add);
            AlterTableStatement.this.dropConstraintDefinitions.stream().map(DropConstraintDefinitionSegment::getConstraintName).forEach(result::add);
            return result;
        }
    }

    private class AlterTableIndexSQLStatementAttribute
    implements IndexSQLStatementAttribute {
        private AlterTableIndexSQLStatementAttribute() {
        }

        @Override
        public Collection<IndexSegment> getIndexes() {
            LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
            for (AddConstraintDefinitionSegment addConstraintDefinitionSegment : AlterTableStatement.this.addConstraintDefinitions) {
                addConstraintDefinitionSegment.getConstraintDefinition().getIndexName().ifPresent(result::add);
            }
            AlterTableStatement.this.dropIndexDefinitions.stream().map(DropIndexDefinitionSegment::getIndexSegment).forEach(result::add);
            for (RenameIndexDefinitionSegment renameIndexDefinitionSegment : AlterTableStatement.this.getRenameIndexDefinitions()) {
                result.add(renameIndexDefinitionSegment.getIndexSegment());
                result.add(renameIndexDefinitionSegment.getRenameIndexSegment());
            }
            return result;
        }

        @Override
        public Collection<ColumnSegment> getIndexColumns() {
            return AlterTableStatement.this.addConstraintDefinitions.stream().flatMap(each -> each.getConstraintDefinition().getIndexColumns().stream()).collect(Collectors.toList());
        }
    }
}

